/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.HashResult;
import freenet.crypt.MultiHashDigester;
import freenet.support.io.SkipShieldingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultiHashInputStream
extends SkipShieldingInputStream {
    private final MultiHashDigester digester;
    private long readBytes;

    public MultiHashInputStream(InputStream proxy, long generateHashes) {
        super(proxy);
        this.digester = MultiHashDigester.fromBitmask(generateHashes);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        if (ret <= 0) {
            return ret;
        }
        this.digester.update(buf, off, ret);
        this.readBytes += (long)ret;
        return ret;
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret < 0) {
            return ret;
        }
        byte[] b = new byte[]{(byte)ret};
        this.digester.update(b, 0, 1);
        ++this.readBytes;
        return ret;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void mark(int readlimit) {
    }

    public HashResult[] getResults() {
        return this.digester.getResults().toArray(new HashResult[0]);
    }

    public long getReadBytes() {
        return this.readBytes;
    }
}

