/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import freenet.io.AddressTracker;
import freenet.io.comm.IOStatisticCollector;
import freenet.io.comm.IncomingPacketFilter;
import freenet.io.comm.PacketSocketHandler;
import freenet.io.comm.Peer;
import freenet.io.comm.PortForwardSensitiveSocketHandler;
import freenet.node.Node;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Random;
import sun.misc.Unsafe;

public class UdpSocketHandler
implements PrioRunnable,
PacketSocketHandler,
PortForwardSensitiveSocketHandler {
    private final ByteBuffer receiveBuffer = ByteBuffer.allocate(1500);
    private final DatagramChannel datagramChannel;
    private final InetSocketAddress localAddress;
    private final AddressTracker tracker;
    private IncomingPacketFilter lowLevelFilter;
    private Random dropRandom;
    private int _dropProbability;
    private final Node node;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private boolean _isDone;
    private volatile boolean _active = true;
    private final String title;
    private boolean _started;
    private long startTime;
    private final IOStatisticCollector ioStatistics;
    private static final int MAX_RECEIVE_SIZE = 1500;
    static final int MAX_ALLOWED_MTU = 1492;
    static final int UDPv4_HEADERS_LENGTH = 28;
    static final int UDPv6_HEADERS_LENGTH = 48;
    public static final int UDP_HEADERS_LENGTH = 48;
    static final int MIN_IPv4_MTU = 576;
    static final int MIN_IPv6_MTU = 1280;
    public static final int MIN_MTU = 576;
    private volatile int maxPacketSize = 1492;

    public UdpSocketHandler(int listenPort, InetAddress bindToAddress, Node node, long startupTime, String title, IOStatisticCollector ioStatistics) throws IOException {
        this.node = node;
        this.ioStatistics = ioStatistics;
        this.title = title;
        this.localAddress = new InetSocketAddress(bindToAddress, listenPort);
        this.datagramChannel = ((DatagramChannel)DatagramChannel.open().bind(this.localAddress).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536)).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        try {
            this.datagramChannel.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)node.getTrafficClass().value);
        }
        catch (UnsupportedOperationException e) {
            Logger.error(this, "Failed to set IP_TOS socket option", (Throwable)e);
        }
        boolean r = socketOptions.setAddressPreference(this.datagramChannel, socketOptions.SOCKET_ADDR_PREFERENCE.IPV6_PREFER_SRC_PUBLIC);
        if (logMINOR) {
            Logger.minor(this, "Setting IPV6_PREFER_SRC_PUBLIC for port " + listenPort + " is a " + (r ? "success" : "failure"));
        }
        this.dropRandom = node.getFastWeakRandom();
        this.tracker = AddressTracker.create(node.getLastBootId(), node.runDir(), listenPort);
        this.tracker.startSend(startupTime);
    }

    @Override
    public void setLowLevelFilter(IncomingPacketFilter f) {
        this.lowLevelFilter = f;
    }

    public InetAddress getBindTo() {
        return this.localAddress.getAddress();
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.tracker.startReceive(System.currentTimeMillis());
        try {
            this.runLoop();
        }
        catch (Throwable t) {
            try {
                System.err.print(t.getClass().getName());
                System.err.println();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                System.err.print(t.getMessage());
                System.err.println();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Runtime r = Runtime.getRuntime();
                System.err.print(r.freeMemory());
                System.err.println();
                System.err.print(r.totalMemory());
                System.err.println();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            System.err.println("run() exiting for UdpSocketHandler on port " + this.localAddress.getPort());
            Logger.error(this, "run() exiting for UdpSocketHandler on port " + this.localAddress.getPort());
            UdpSocketHandler udpSocketHandler = this;
            synchronized (udpSocketHandler) {
                this._isDone = true;
                this.notifyAll();
            }
        }
    }

    private void runLoop() {
        while (this._active) {
            try {
                this.realRun();
            }
            catch (Throwable t) {
                System.err.println("Caught " + t);
                t.printStackTrace(System.err);
                Logger.error(this, "Caught " + t, t);
            }
        }
    }

    private void realRun() {
        InetSocketAddress remote = this.receive();
        long now = System.currentTimeMillis();
        if (remote != null) {
            long startTime = System.currentTimeMillis();
            Peer peer = new Peer(remote.getAddress(), remote.getPort());
            this.tracker.receivedPacketFrom(peer);
            long endTime = System.currentTimeMillis();
            if (endTime - startTime > 50L) {
                if (endTime - startTime > 3000L) {
                    Logger.error(this, "packet creation took " + (endTime - startTime) + "ms");
                } else if (logMINOR) {
                    Logger.minor(this, "packet creation took " + (endTime - startTime) + "ms");
                }
            }
            try {
                if (logMINOR) {
                    Logger.minor(this, "Processing packet of length " + this.receiveBuffer.limit() + " from " + peer);
                }
                startTime = System.currentTimeMillis();
                this.lowLevelFilter.process(this.receiveBuffer.array(), 0, this.receiveBuffer.limit(), peer, now);
                endTime = System.currentTimeMillis();
                if (endTime - startTime > 50L) {
                    if (endTime - startTime > 3000L) {
                        Logger.error(this, "processing packet took " + (endTime - startTime) + "ms");
                    } else if (logMINOR) {
                        Logger.minor(this, "processing packet took " + (endTime - startTime) + "ms");
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Successfully handled packet length " + this.receiveBuffer.limit());
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " from " + this.lowLevelFilter, t);
            }
        } else if (logDEBUG) {
            Logger.debug(this, "No packet received");
        }
    }

    private InetSocketAddress receive() {
        try {
            this.receiveBuffer.clear();
            InetSocketAddress remote = (InetSocketAddress)this.datagramChannel.receive(this.receiveBuffer);
            this.receiveBuffer.flip();
            InetAddress address = remote.getAddress();
            this.ioStatistics.reportReceivedBytes(address, this.getHeadersLength(address) + this.receiveBuffer.limit());
            return remote;
        }
        catch (SocketTimeoutException e1) {
            return null;
        }
        catch (IOException e2) {
            if (!this._active) {
                return null;
            }
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void sendPacket(byte[] blockToSend, Peer destination, boolean allowLocalAddresses) throws Peer.LocalAddressException {
        if (!this._active) {
            Logger.error(this, "Trying to send packet but no longer active");
            return;
        }
        ByteBuffer packet = ByteBuffer.wrap(blockToSend);
        int port = destination.getPort();
        InetAddress address = destination.getAddress(false, allowLocalAddresses);
        if (address == null) {
            Logger.error(this, "Tried sending to destination without pre-looked up IP address(needs a real Peer.getHostname()): null:" + destination.getPort(), (Throwable)new Exception("error"));
            address = destination.getAddress(true, allowLocalAddresses);
            if (address == null) {
                Logger.error(this, "Tried sending to bad destination address: null:" + destination.getPort(), (Throwable)new Exception("error"));
                return;
            }
        }
        if (this._dropProbability > 0 && this.dropRandom.nextInt() % this._dropProbability == 0) {
            Logger.normal(this, "DROPPED: " + this.localAddress.getPort() + " -> " + destination.getPort());
            return;
        }
        try {
            this.datagramChannel.send(packet, new InetSocketAddress(address, port));
            this.tracker.sentPacketTo(destination);
            this.ioStatistics.reportSentBytes(address, this.getHeadersLength(address) + blockToSend.length);
            if (logMINOR) {
                Logger.minor(this, "Sent packet length " + blockToSend.length + " to " + address + ':' + port);
            }
        }
        catch (IOException | UnsupportedAddressTypeException e) {
            if (address instanceof Inet6Address) {
                Logger.normal(this, "Error while sending packet to IPv6 address: " + destination + ": " + e);
            }
            Logger.error(this, "Error while sending packet to " + destination + ": " + e, (Throwable)e);
        }
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public int calculateMaxPacketSize() {
        int newSize;
        int oldSize = this.maxPacketSize;
        this.maxPacketSize = newSize = this.innerCalculateMaxPacketSize();
        if (oldSize != newSize) {
            System.out.println("Max packet size: " + newSize);
        }
        return this.maxPacketSize;
    }

    int innerCalculateMaxPacketSize() {
        int minAdvertisedMTU = this.node.getMinimumMTU();
        this.maxPacketSize = Math.min(1492, minAdvertisedMTU) - 48;
        return this.maxPacketSize;
    }

    @Override
    public int getPacketSendThreshold() {
        return this.getMaxPacketSize() - 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this._active) {
            return;
        }
        UdpSocketHandler udpSocketHandler = this;
        synchronized (udpSocketHandler) {
            this._started = true;
            this.startTime = System.currentTimeMillis();
        }
        this.node.getExecutor().execute(this, "UdpSocketHandler for port " + this.localAddress.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Logger.normal(this, "Closing.", (Throwable)new Exception("error"));
        UdpSocketHandler udpSocketHandler = this;
        synchronized (udpSocketHandler) {
            this._active = false;
            try {
                this.datagramChannel.close();
            }
            catch (IOException e) {
                Logger.error(this, "Error closing DatagramChannel", (Throwable)e);
            }
            if (!this._started) {
                return;
            }
            while (!this._isDone) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.tracker.storeData(this.node.getBootId(), this.node.runDir(), this.localAddress.getPort());
    }

    public int getDropProbability() {
        return this._dropProbability;
    }

    public void setDropProbability(int dropProbability) {
        this._dropProbability = dropProbability;
    }

    public int getPortNumber() {
        return this.localAddress.getPort();
    }

    public String toString() {
        return this.localAddress.toString();
    }

    @Override
    public int getHeadersLength() {
        return 48;
    }

    @Override
    public int getHeadersLength(Peer peer) {
        return this.getHeadersLength(peer.getAddress(false));
    }

    int getHeadersLength(InetAddress addr) {
        return addr == null || addr instanceof Inet6Address ? 48 : 28;
    }

    public AddressTracker getAddressTracker() {
        return this.tracker;
    }

    @Override
    public void rescanPortForward() {
        this.tracker.rescan();
    }

    @Override
    public AddressTracker.Status getDetectedConnectivityStatus() {
        return this.tracker.getPortForwardStatus();
    }

    @Override
    public int getPriority() {
        return NativeThread.MAX_PRIORITY;
    }

    public long getStartTime() {
        return this.startTime;
    }

    static {
        Logger.registerClass(UdpSocketHandler.class);
    }

    private static class socketOptions {
        private socketOptions() {
        }

        private static int getFd(DatagramChannel channel) {
            try {
                Field unsafe = Unsafe.class.getDeclaredField("theUnsafe");
                unsafe.setAccessible(true);
                Unsafe theUnsafe = (Unsafe)unsafe.get(null);
                Field fdVal = channel.getClass().getDeclaredField("fdVal");
                return theUnsafe.getInt(channel, theUnsafe.objectFieldOffset(fdVal));
            }
            catch (Exception e) {
                Logger.warning(UdpSocketHandler.class, e.getMessage(), (Throwable)e);
                return -1;
            }
        }

        public static boolean setAddressPreference(DatagramChannel channel, SOCKET_ADDR_PREFERENCE p) {
            if (!Platform.isLinux()) {
                return false;
            }
            int fd = socketOptions.getFd(channel);
            if (fd <= 2) {
                return false;
            }
            try {
                int ret = socketOptionsHolder.setsockopt(fd, SOCKET_level.IPPROTO_IPV6.linux, p.option_name.linux, new IntByReference(p.linux).getPointer(), Native.POINTER_SIZE);
                return ret == 0;
            }
            catch (Exception e) {
                Logger.normal(UdpSocketHandler.class, e.getMessage(), (Throwable)e);
                return false;
            }
        }

        public static enum SOCKET_ADDR_PREFERENCE {
            IPV6_PREFER_SRC_TMP(1),
            IPV6_PREFER_SRC_PUBLIC(2),
            IPV6_PREFER_SRC_PUBTMP_DEFAULT(256),
            IPV6_PREFER_SRC_COA(4),
            IPV6_PREFER_SRC_HOME(1024),
            IPV6_PREFER_SRC_CGA(8),
            IPV6_PREFER_SRC_NONCGA(2048);

            final SOCKET_option_name option_name = SOCKET_option_name.IPV6_ADDR_PREFERENCES;
            final int linux;

            private SOCKET_ADDR_PREFERENCE(int linux) {
                this.linux = linux;
            }
        }

        public static enum SOCKET_option_name {
            IPV6_ADDR_PREFERENCES(72);

            final int linux;

            private SOCKET_option_name(int linux) {
                this.linux = linux;
            }
        }

        public static enum SOCKET_level {
            IPPROTO_IPV6(41);

            final int linux;

            private SOCKET_level(int linux) {
                this.linux = linux;
            }
        }

        private static class socketOptionsHolder {
            private socketOptionsHolder() {
            }

            private static native int setsockopt(int var0, int var1, int var2, Pointer var3, int var4) throws LastErrorException;

            static {
                Native.register((String)Platform.C_LIBRARY_NAME);
            }
        }
    }
}

