/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.DummyRandomSource;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKSK;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.Key;
import freenet.keys.SSKEncodeException;
import freenet.keys.SSKVerifyException;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.LowLevelGetException;
import freenet.node.Node;
import freenet.node.NodeDispatcher;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.PeerTooOldException;
import freenet.node.simulator.RealNodeRoutingTest;
import freenet.node.simulator.RealNodeTest;
import freenet.store.KeyCollisionException;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.SimpleFieldSet;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.ArrayBucket;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;

public class RealNodeULPRTest
extends RealNodeTest {
    static final int EXIT_BASE = 1024;
    static final int EXIT_KEY_EXISTS = 1025;
    static final int EXIT_UNKNOWN_ERROR_CHECKING_KEY_NOT_EXIST = 1026;
    static final int EXIT_TEST_FAILED = 1028;
    static final int NUMBER_OF_NODES = 10;
    static final short MAX_HTL = 10;
    static final int NUMBER_OF_TESTS = 100;
    static final boolean ENABLE_SWAPPING = true;
    static final boolean ENABLE_ULPRS = true;
    static final boolean ENABLE_PER_NODE_FAILURE_TABLES = true;
    static final boolean ENABLE_FOAF = true;
    static final boolean REAL_TIME_FLAG = false;
    static final DarknetPeerNode.FRIEND_TRUST trust = DarknetPeerNode.FRIEND_TRUST.LOW;
    static final DarknetPeerNode.FRIEND_VISIBILITY visibility = DarknetPeerNode.FRIEND_VISIBILITY.NO;
    public static final int DARKNET_PORT_BASE = 5035;
    public static final int DARKNET_PORT_END = 5045;

    public static void main(String[] args) throws FSParseException, PeerParseException, CHKEncodeException, LoggerHook.InvalidThresholdException, NodeInitException, ReferenceSignatureVerificationException, KeyCollisionException, SSKEncodeException, IOException, InterruptedException, SSKVerifyException, InvalidCompressionCodecException, PeerTooOldException {
        int i;
        System.err.println("ULPR test");
        System.err.println();
        String testName = "realNodeULPRTest";
        File wd = new File(testName);
        if (!FileUtil.removeAll(wd)) {
            System.err.println("Mass delete failed, test may not be accurate.");
            System.exit(1027);
        }
        wd.mkdir();
        DummyRandomSource random = new DummyRandomSource();
        NodeStarter.globalTestInit(testName, false, Logger.LogLevel.ERROR, "freenet.node.Location:normal,freenet.node.simulator.RealNodeRoutingTest:normal,freenet.node.NodeDispatcher:NORMAL,freenet.node.FailureTable:MINOR,freenet.node.Node:MINOR,freenet.node.Request:MINOR,freenet.io.comm.MessageCore:MINOR,freenet.node.PeerNode:MINOR,freenet.node.DarknetPeerNode:MINOR,freenet.io.xfer.PacketThrottle:MINOR,freenet.node.PeerManager:MINOR,freenet.client.async:MINOR", true);
        Node[] nodes = new Node[10];
        Logger.normal(RealNodeRoutingTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        for (int i2 = 0; i2 < 10; ++i2) {
            nodes[i2] = NodeStarter.createTestNode(5035 + i2, 0, testName, true, (short)10, 20, random, executor, 5000, 0x100000L, true, true, false, true, true, true, true, 0, true, false, true, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created node " + i2);
        }
        SimpleFieldSet[] refs = new SimpleFieldSet[10];
        for (i = 0; i < 10; ++i) {
            refs[i] = nodes[i].exportDarknetPublicFieldSet();
        }
        Logger.normal(RealNodeRoutingTest.class, "Created 10 nodes");
        for (i = 0; i < 10; ++i) {
            int next = (i + 1) % 10;
            int prev = (i + 10 - 1) % 10;
            nodes[i].connect(nodes[next], trust, visibility);
            nodes[i].connect(nodes[prev], trust, visibility);
        }
        Logger.normal(RealNodeRoutingTest.class, "Connected nodes");
        for (i = 0; i < 50; ++i) {
            if (i % 10 == 0) {
                Logger.normal(RealNodeRoutingTest.class, String.valueOf(i));
            }
            int length = (int)Math.pow(10.0, random.nextDouble());
            int nodeA = random.nextInt(10);
            int nodeB = (nodeA + length) % 10;
            Node a = nodes[nodeA];
            Node b = nodes[nodeB];
            a.connect(b, trust, visibility);
            b.connect(a, trust, visibility);
        }
        Logger.normal(RealNodeRoutingTest.class, "Added random links");
        for (Node node : nodes) {
            node.start(false);
        }
        int successfulTests = 0;
        long totalPropagationTime = 0L;
        for (int totalCount = 0; totalCount < 100; ++totalCount) {
            ClientKeyBlock block;
            ClientKey fetchKey;
            ClientKey insertKey;
            FreenetURI testKey;
            final boolean isSSK = (totalCount & 1) == 1;
            byte[] buf = new byte[32];
            random.nextBytes(buf);
            String keyName = HexUtil.bytesToHex(buf);
            if (isSSK) {
                testKey = new FreenetURI("KSK", keyName);
                insertKey = InsertableClientSSK.create(testKey);
                fetchKey = ClientKSK.create(testKey);
                block = ((InsertableClientSSK)insertKey).encode(new ArrayBucket(buf), false, false, (short)-1, buf.length, random, Compressor.COMPRESSOR_TYPE.DEFAULT_COMPRESSORDESCRIPTOR);
            } else {
                block = ClientCHKBlock.encode(buf, false, false, (short)-1, buf.length, Compressor.COMPRESSOR_TYPE.DEFAULT_COMPRESSORDESCRIPTOR);
                insertKey = fetchKey = block.getClientKey();
                testKey = insertKey.getURI();
            }
            final Key nodeKey = fetchKey.getNodeKey(false);
            System.err.println();
            System.err.println("Created random test key " + testKey + " = " + nodeKey);
            System.err.println();
            Logger.error(RealNodeULPRTest.class, "Starting ULPR test #" + successfulTests + ": " + testKey + " = " + fetchKey + " = " + nodeKey);
            RealNodeULPRTest.waitForAllConnected(nodes);
            final boolean[] visited = new boolean[nodes.length];
            NodeDispatcher.NodeDispatcherCallback cb = new NodeDispatcher.NodeDispatcherCallback(){

                @Override
                public void snoop(Message m, Node n) {
                    Key key;
                    if ((!isSSK && m.getSpec() == DMT.FNPCHKDataRequest || isSSK && m.getSpec() == DMT.FNPSSKDataRequest) && (key = (Key)m.getObject("freenetRoutingKey")).equals(nodeKey)) {
                        visited[n.getDarknetPortNumber() - 5035] = true;
                    }
                }
            };
            for (Node node : nodes) {
                node.setDispatcherHook(cb);
            }
            block13: for (int i3 = 0; i3 < nodes.length; ++i3) {
                System.out.println("Searching from node " + i3);
                try {
                    nodes[i3 % nodes.length].getClientCore().realGetKey(fetchKey, false, false, false, false);
                    System.err.println("TEST FAILED: KEY ALREADY PRESENT!!!");
                    System.exit(1025);
                    continue;
                }
                catch (LowLevelGetException e) {
                    switch (e.code) {
                        case 4: 
                        case 5: {
                            System.err.println("Node " + i3 % nodes.length + " : key not found (expected behaviour)");
                            continue block13;
                        }
                        case 10: {
                            System.err.println("Node " + i3 % nodes.length + " : recently failed (expected behaviour on later tests)");
                            continue block13;
                        }
                        default: {
                            System.err.println("Node " + i3 % nodes.length + " : UNEXPECTED ERROR: " + e.toString());
                            System.exit(1026);
                        }
                    }
                }
            }
            int visitedCount = 0;
            StringBuilder sb = new StringBuilder(3 * nodes.length + 1);
            boolean first = true;
            for (int i4 = 0; i4 < visited.length; ++i4) {
                if (!visited[i4]) continue;
                ++visitedCount;
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append(i4);
            }
            System.err.println("Nodes which were asked for the key by another node: " + visitedCount + " : " + sb.toString());
            Logger.normal(RealNodeULPRTest.class, "Inserting to node " + (nodes.length - 1));
            long tStart = System.currentTimeMillis();
            nodes[nodes.length - 1].store(block.getBlock(), false, false, true, false);
            Logger.normal(RealNodeULPRTest.class, "Inserted to node " + (nodes.length - 1));
            int x = -1;
            while (true) {
                ++x;
                Thread.sleep(1000L);
                int count = 0;
                for (Node node : nodes) {
                    if (!node.hasKey(fetchKey.getNodeKey(false), true, true)) continue;
                    ++count;
                }
                System.err.println("T=" + x + " : " + count + '/' + nodes.length + " have the data on test " + successfulTests + ".");
                Logger.normal(RealNodeULPRTest.class, "T=" + x + " : " + count + '/' + nodes.length + " have the data on test " + successfulTests + ".");
                if (x > 300) {
                    System.err.println();
                    System.err.println("TEST FAILED");
                    System.exit(1028);
                }
                if (count == nodes.length) break;
                if (x % nodes.length != 0) continue;
                System.err.print("Nodes that do have the data: ");
                for (int i5 = 0; i5 < nodes.length; ++i5) {
                    if (!nodes[i5].hasKey(fetchKey.getNodeKey(false), true, true)) continue;
                    System.err.print(i5 + " ");
                }
                System.err.println();
            }
            long tEnd = System.currentTimeMillis();
            long propagationTime = tEnd - tStart;
            System.err.println("SUCCESSFUL TEST # " + ++successfulTests + " in " + propagationTime + "ms!!!");
            System.err.println("Average propagation time: " + (totalPropagationTime += propagationTime) / (long)successfulTests + "ms");
            System.err.println();
        }
        System.err.println("Overall average propagation time: " + totalPropagationTime / (long)successfulTests + "ms");
        System.exit(0);
    }
}

