/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.clients.http.ConfigToadlet;
import freenet.config.Config;
import freenet.config.FilePersistentConfig;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginBaseL10n;
import freenet.pluginmanager.FredPluginConfigurable;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginFCPMessageHandler;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginMultiple;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThemed;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.JarClassLoader;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;

public class PluginInfoWrapper
implements Comparable<PluginInfoWrapper> {
    private final String className;
    private Thread thread;
    private final long start;
    final PluginRespirator pr;
    private final String threadName;
    final FredPlugin plug;
    private final Config config;
    private final SubConfig subconfig;
    private final ConfigToadlet configToadlet;
    private final boolean isPproxyPlugin;
    private final boolean isThreadlessPlugin;
    private final boolean isIPDetectorPlugin;
    private final boolean isBandwidthIndicator;
    private final boolean isPortForwardPlugin;
    private final boolean isMultiplePlugin;
    @Deprecated
    private final boolean isFCPPlugin;
    private final boolean isFCPServerPlugin;
    private final boolean isVersionedPlugin;
    private final boolean isLongVersionedPlugin;
    private final boolean isThemedPlugin;
    private final boolean isL10nPlugin;
    private final boolean isBaseL10nPlugin;
    private final boolean isConfigurablePlugin;
    private final boolean isOfficialPlugin;
    private final String filename;
    private HashSet<String> toadletLinks = new HashSet();
    private volatile boolean stopping = false;
    private volatile boolean unregistered = false;

    public PluginInfoWrapper(Node node, FredPlugin plug, String filename, boolean isOfficial) throws IOException {
        this.plug = plug;
        this.className = plug.getClass().toString();
        this.filename = filename;
        this.pr = new PluginRespirator(node, this);
        this.threadName = 'p' + this.className.replaceAll("^class ", "") + '_' + this.hashCode();
        this.start = System.currentTimeMillis();
        this.isBandwidthIndicator = plug instanceof FredPluginBandwidthIndicator;
        this.isPproxyPlugin = plug instanceof FredPluginHTTP;
        this.isThreadlessPlugin = plug instanceof FredPluginThreadless;
        this.isIPDetectorPlugin = plug instanceof FredPluginIPDetector;
        this.isPortForwardPlugin = plug instanceof FredPluginPortForward;
        this.isMultiplePlugin = plug instanceof FredPluginMultiple;
        this.isFCPPlugin = plug instanceof FredPluginFCP;
        this.isFCPServerPlugin = plug instanceof FredPluginFCPMessageHandler.ServerSideFCPMessageHandler;
        this.isVersionedPlugin = plug instanceof FredPluginVersioned;
        this.isLongVersionedPlugin = plug instanceof FredPluginRealVersioned;
        this.isThemedPlugin = plug instanceof FredPluginThemed;
        this.isL10nPlugin = plug instanceof FredPluginL10n;
        this.isBaseL10nPlugin = plug instanceof FredPluginBaseL10n;
        this.isConfigurablePlugin = plug instanceof FredPluginConfigurable;
        if (this.isConfigurablePlugin) {
            this.config = FilePersistentConfig.constructFilePersistentConfig(new File(node.getCfgDir(), "plugin-" + this.getPluginClassName() + ".ini"), "config options for plugin: " + this.getPluginClassName());
            this.subconfig = this.config.createSubConfig(this.getPluginClassName());
            ((FredPluginConfigurable)((Object)plug)).setupConfig(this.subconfig);
            this.config.finishedInit();
            this.configToadlet = new ConfigToadlet(this.pr.getHLSimpleClient(), this.config, this.subconfig, node, node.getClientCore(), (FredPluginConfigurable)((Object)plug));
        } else {
            this.config = null;
            this.subconfig = null;
            this.configToadlet = null;
        }
        this.isOfficialPlugin = isOfficial;
    }

    void setThread(Thread ps) {
        if (this.thread != null) {
            throw new IllegalStateException("Already set a thread");
        }
        this.thread = ps;
        this.thread.setName(this.threadName);
    }

    public String toString() {
        return "ID: \"" + this.threadName + "\", Name: " + this.className + ", Started: " + new Date(this.start).toString();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getStarted() {
        return this.start;
    }

    public String getPluginClassName() {
        return this.plug.getClass().getName();
    }

    public String getPluginVersion() {
        if (this.isVersionedPlugin) {
            return ((FredPluginVersioned)((Object)this.plug)).getVersion();
        }
        return NodeL10n.getBase().getString("PproxyToadlet.noVersion");
    }

    public synchronized String[] getPluginToadletSymlinks() {
        return this.toadletLinks.toArray(new String[0]);
    }

    public synchronized boolean addPluginToadletSymlink(String linkfrom) {
        if (this.toadletLinks.isEmpty()) {
            this.toadletLinks = new HashSet();
        }
        return this.toadletLinks.add(linkfrom);
    }

    public synchronized boolean removePluginToadletSymlink(String linkfrom) {
        if (this.toadletLinks.isEmpty()) {
            return false;
        }
        return this.toadletLinks.remove(linkfrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startShutdownPlugin(PluginManager manager, boolean reloading) {
        this.unregister(manager, reloading);
        System.out.println("Terminating plugin " + this.getFilename());
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.plug.getClass().getClassLoader());
        try {
            this.plug.terminate();
        }
        catch (Throwable t) {
            Logger.error(this, "Error while terminating plugin.", t);
            System.err.println("Error while terminating plugin: " + t);
            t.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        PluginInfoWrapper pluginInfoWrapper = this;
        synchronized (pluginInfoWrapper) {
            this.stopping = true;
        }
    }

    public boolean finishShutdownPlugin(PluginManager manager, long maxWaitTime, boolean reloading) {
        ClassLoader cl;
        boolean success = true;
        if (this.thread != null) {
            this.thread.interrupt();
            if (maxWaitTime >= 0L) {
                try {
                    this.thread.join(maxWaitTime);
                }
                catch (InterruptedException e) {
                    Logger.normal(this, "stopPlugin interrupted while join()ed to terminating plugin thread - maybe one plugin stopping another???");
                }
                if (this.thread.isAlive()) {
                    String error = "Waited for " + this.thread + " for " + this.plug + " to exit for " + maxWaitTime + "ms, and it is still alive!";
                    Logger.error(this, error);
                    System.err.println(error);
                    success = false;
                }
            }
        }
        if ((cl = this.plug.getClass().getClassLoader()) instanceof JarClassLoader) {
            Closer.close((JarClassLoader)cl);
        }
        return success;
    }

    public void stopPlugin(PluginManager manager, long maxWaitTime, boolean reloading) {
        this.startShutdownPlugin(manager, reloading);
        this.finishShutdownPlugin(manager, maxWaitTime, reloading);
        manager.removePlugin(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(PluginManager manager, boolean reloading) {
        PluginInfoWrapper pluginInfoWrapper = this;
        synchronized (pluginInfoWrapper) {
            if (this.unregistered) {
                return;
            }
            this.unregistered = true;
        }
        manager.unregisterPlugin(this, this.plug, reloading);
    }

    public boolean isPproxyPlugin() {
        return this.isPproxyPlugin;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isBandwidthIndicator() {
        return this.isBandwidthIndicator;
    }

    public boolean isThreadlessPlugin() {
        return this.isThreadlessPlugin;
    }

    public boolean isIPDetectorPlugin() {
        return this.isIPDetectorPlugin;
    }

    public boolean isPortForwardPlugin() {
        return this.isPortForwardPlugin;
    }

    public boolean isMultiplePlugin() {
        return this.isMultiplePlugin;
    }

    @Deprecated
    public boolean isFCPPlugin() {
        return this.isFCPPlugin;
    }

    public boolean isFCPServerPlugin() {
        return this.isFCPServerPlugin;
    }

    public FredPluginFCPMessageHandler.ServerSideFCPMessageHandler getFCPServerPlugin() {
        return (FredPluginFCPMessageHandler.ServerSideFCPMessageHandler)((Object)this.plug);
    }

    public boolean isThemedPlugin() {
        return this.isThemedPlugin;
    }

    public boolean isL10nPlugin() {
        return this.isL10nPlugin;
    }

    public boolean isBaseL10nPlugin() {
        return this.isBaseL10nPlugin;
    }

    public boolean isConfigurablePlugin() {
        return this.isConfigurablePlugin;
    }

    public synchronized boolean isStopping() {
        return this.stopping;
    }

    public long getPluginLongVersion() {
        if (this.isLongVersionedPlugin) {
            return ((FredPluginRealVersioned)((Object)this.plug)).getRealVersion();
        }
        return -1L;
    }

    public FredPlugin getPlugin() {
        return this.plug;
    }

    public PluginRespirator getPluginRespirator() {
        return this.pr;
    }

    @Override
    public int compareTo(PluginInfoWrapper pi) {
        return this.className.compareTo(pi.className);
    }

    public Config getConfig() {
        return this.config;
    }

    public SubConfig getSubConfig() {
        return this.subconfig;
    }

    public ConfigToadlet getConfigToadlet() {
        return this.configToadlet;
    }

    public boolean isOfficialPlugin() {
        return this.isOfficialPlugin;
    }

    public String getLocalisedPluginName() {
        String pluginName = this.getFilename();
        if (this.isOfficialPlugin()) {
            return PluginManager.getOfficialPluginLocalisedName(pluginName);
        }
        return pluginName;
    }
}

