/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Fields;
import java.util.Arrays;
import java.util.Comparator;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    private final byte[] data;
    private final int hashCode;
    public static final Comparator<ByteArrayWrapper> FAST_COMPARATOR = Comparator.comparingInt(ByteArrayWrapper::hashCode).thenComparing(Comparator.naturalOrder());

    public ByteArrayWrapper(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
        this.hashCode = Arrays.hashCode(this.data);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ByteArrayWrapper) {
            ByteArrayWrapper b = (ByteArrayWrapper)other;
            return this.hashCode == b.hashCode && Arrays.equals(this.data, b.data);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte[] get() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public int compareTo(ByteArrayWrapper other) {
        if (this == other) {
            return 0;
        }
        return Fields.compareBytes(this.data, other.data);
    }
}

