/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.config.Config;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.support.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class DatastoreUtil {
    public static final long oneMiB = 0x100000L;
    public static final long oneGiB = 0x40000000L;

    public static long maxDatastoreSize() {
        long maxDatastoreSize;
        long maxMemory = NodeStarter.getMemoryLimitBytes();
        if (maxMemory == Long.MAX_VALUE || maxMemory < 0x8000000L) {
            maxDatastoreSize = 0x40000000L;
        } else {
            long available = maxMemory - 0x6400000L;
            long slots = (available /= 2L) / 4L;
            maxDatastoreSize = (slots /= 3L) * 34988L;
        }
        try {
            long unallocatedSpace = Files.getFileStore(Paths.get("", new String[0])).getUnallocatedSpace();
            return Math.min(unallocatedSpace, maxDatastoreSize);
        }
        catch (IOException e) {
            Logger.error(DatastoreUtil.class, "Error querying space", (Throwable)e);
            return maxDatastoreSize;
        }
    }

    public static long autodetectDatastoreSize(NodeClientCore core, Config config) {
        if (!config.get("node").getOption("storeSize").isDefault()) {
            return -1L;
        }
        long freeSpace = core.getNode().getStoreDir().getUsableSpace();
        if (freeSpace <= 0L) {
            return -1L;
        }
        long bloomFilter128MiBMax = 0x4000000000L;
        long diskIoMax = 0x1900000000L;
        long shortSize = freeSpace > 0xC80000000L ? Math.max(0x280000000L, Math.min(freeSpace / 10L, Math.min(diskIoMax, bloomFilter128MiBMax))) : (freeSpace > 0x140000000L ? Math.max(freeSpace / 5L, 0x80000000L) : (freeSpace > 0x80000000L ? 0x20000000L : 0x10000000L));
        return shortSize;
    }
}

