/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.plugins.helpers1;

import freenet.keys.FreenetURI;
import freenet.support.Logger;
import java.net.MalformedURLException;
import java.util.List;

public class URISanitizer {
    public static FreenetURI sanitizeURI(String key, Options ... options) throws MalformedURLException {
        return URISanitizer.sanitizeURI(null, key, false, options);
    }

    public static FreenetURI sanitizeURI(List<String> errors, String key, boolean breakOnErrors, Options ... options) throws MalformedURLException {
        if (key == null) {
            throw new NullPointerException();
        }
        FreenetURI uri = new FreenetURI(key);
        return URISanitizer.sanitizeURI(errors, uri, breakOnErrors, options);
    }

    public static FreenetURI sanitizeURI(List<String> errors, FreenetURI key, boolean breakOnErrors, Options ... options) throws MalformedURLException {
        if (key == null) {
            throw new NullPointerException();
        }
        FreenetURI tempURI = key;
        block4: for (Options option : options) {
            switch (option) {
                case NOMETASTRINGS: {
                    if (!tempURI.hasMetaStrings()) continue block4;
                    if (errors != null) {
                        tempURI = tempURI.setMetaString(null);
                        errors.add("URI did contain meta strings, removed it for you");
                        if (!breakOnErrors) continue block4;
                        break block4;
                    }
                    throw new MalformedURLException("URIs with meta strings not supported");
                }
                case SSKFORUSK: {
                    if (!tempURI.isUSK()) continue block4;
                    if (errors != null) {
                        tempURI = tempURI.sskForUSK();
                        errors.add("URI was an USK, converted it to SSK for you");
                        if (!breakOnErrors) continue block4;
                        break block4;
                    }
                    throw new MalformedURLException("USK not supported, use underlying SSK instead.");
                }
                default: {
                    Logger.error(URISanitizer.class, "Illegal Option, how can this happen?");
                }
            }
        }
        return tempURI;
    }

    public static enum Options {
        NOMETASTRINGS,
        SSKFORUSK;

    }
}

