/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.SingleKeyListener;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeSSK;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.NullSendableRequestItem;
import freenet.node.RequestClient;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.support.Logger;
import freenet.support.TimeUtil;

public abstract class BaseSingleFileFetcher
extends SendableGet
implements HasKeyListener {
    private static final long serialVersionUID = 1L;
    protected final ClientKey key;
    protected boolean cancelled;
    protected boolean finished;
    final int maxRetries;
    private int retryCount;
    protected final FetchContext ctx;
    protected boolean deleteFetchContext;
    static final SendableRequestItem[] keys = new SendableRequestItem[]{NullSendableRequestItem.nullItem};
    private int cachedCooldownTries;
    private long cachedCooldownTime;
    public transient long cooldownWakeupTime;
    private static volatile boolean logMINOR;

    protected BaseSingleFileFetcher(ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent, boolean deleteFetchContext, boolean realTimeFlag) {
        super(parent, realTimeFlag);
        this.deleteFetchContext = deleteFetchContext;
        if (logMINOR) {
            Logger.minor(this, "Creating BaseSingleFileFetcher for " + key);
        }
        this.retryCount = 0;
        this.maxRetries = maxRetries;
        this.key = key;
        this.ctx = ctx;
        if (ctx == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public long countAllKeys(ClientContext context) {
        return 1L;
    }

    @Override
    public long countSendableKeys(ClientContext context) {
        return 1L;
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally fetching, ClientContext context) {
        Key k = this.key.getNodeKey(false);
        if (fetching.hasKey(k, this)) {
            return null;
        }
        long l = fetching.checkRecentlyFailed(k, this.realTimeFlag);
        long now = System.currentTimeMillis();
        if (l > 0L && l > now) {
            if (this.maxRetries == -1 || this.maxRetries >= 3) {
                if (logMINOR) {
                    Logger.minor(this, "RecentlyFailed -> cooldown until " + TimeUtil.formatTime(l - now) + " on " + this);
                }
                this.cooldownWakeupTime = Math.max(this.cooldownWakeupTime, l);
                return null;
            }
            this.onFailure(new LowLevelGetException(10), null, context);
            return null;
        }
        return keys[0];
    }

    @Override
    public ClientKey getKey(SendableRequestItem token) {
        return this.key;
    }

    @Override
    public FetchContext getContext() {
        return this.ctx;
    }

    @Override
    public boolean isSSK() {
        return this.key instanceof ClientSSK;
    }

    protected boolean retry(ClientContext context) {
        if (this.isEmpty()) {
            if (logMINOR) {
                Logger.minor(this, "Not retrying because empty");
            }
            return false;
        }
        int r = ++this.retryCount;
        if (logMINOR) {
            Logger.minor(this, "Attempting to retry... (max " + this.maxRetries + ", current " + r + ") on " + this + " finished=" + this.finished + " cancelled=" + this.cancelled);
        }
        if (r <= this.maxRetries || this.maxRetries == -1) {
            this.checkCachedCooldownData();
            if (this.cachedCooldownTries == 0 || r % this.cachedCooldownTries == 0) {
                long now = System.currentTimeMillis();
                if (this.cooldownWakeupTime > now) {
                    Logger.error(this, "Already on the cooldown queue for " + this + " until " + TimeUtil.formatTime(this.cooldownWakeupTime - now), (Throwable)new Exception("error"));
                } else {
                    if (logMINOR) {
                        Logger.minor(this, "Adding to cooldown queue " + this);
                    }
                    this.cooldownWakeupTime = now + this.cachedCooldownTime;
                    this.reduceWakeupTime(this.cooldownWakeupTime, context);
                    if (logMINOR) {
                        Logger.minor(this, "Added single file fetcher into cooldown until " + TimeUtil.formatTime(this.cooldownWakeupTime - now));
                    }
                }
                this.onEnterFiniteCooldown(context);
            } else {
                this.clearWakeupTime(context);
            }
            return true;
        }
        this.unregister(context, this.getPriorityClass());
        return false;
    }

    private void checkCachedCooldownData() {
        if (this.cachedCooldownTime != 0L || this.cachedCooldownTries != 0) {
            return;
        }
        this.innerCheckCachedCooldownData();
    }

    private void innerCheckCachedCooldownData() {
        this.cachedCooldownTries = this.ctx.getCooldownRetries();
        this.cachedCooldownTime = this.ctx.getCooldownTime();
    }

    protected void onEnterFiniteCooldown(ClientContext context) {
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public short getPriorityClass() {
        return this.parent.getPriorityClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ClientContext context) {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            this.cancelled = true;
        }
        this.unregisterAll(context);
    }

    public void unregisterAll(ClientContext context) {
        this.getScheduler(context).removePendingKeys(this, false);
        this.unregister(context, (short)-1);
    }

    @Override
    public void unregister(ClientContext context, short oldPrio) {
        super.unregister(context, oldPrio);
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isEmpty() {
        return this.cancelled || this.finished;
    }

    @Override
    public RequestClient getClient() {
        return this.parent.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGotKey(Key key, KeyBlock block, ClientContext context) {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "onGotKey() called twice on " + this, (Throwable)new Exception("debug"));
                }
                return;
            }
            this.finished = true;
            if (this.isCancelled()) {
                return;
            }
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.key == null) {
                throw new NullPointerException("Key is null on " + this);
            }
            if (!key.equals(this.key.getNodeKey(false))) {
                Logger.normal(this, "Got sent key " + key + " but want " + this.key + " for " + this);
                return;
            }
        }
        this.unregister(context, this.getPriorityClass());
        this.onSuccess(block, false, null, context);
    }

    public void onSuccess(KeyBlock lowLevelBlock, boolean fromStore, SendableRequestItem token, ClientContext context) {
        try {
            ClientKeyBlock block = Key.createKeyBlock(this.key, lowLevelBlock);
            this.onSuccess(block, fromStore, (Object)token, context);
        }
        catch (KeyVerifyException e) {
            this.onBlockDecodeError(token, context);
        }
    }

    protected abstract void onBlockDecodeError(SendableRequestItem var1, ClientContext var2);

    public abstract void onSuccess(ClientKeyBlock var1, boolean var2, Object var3, ClientContext var4);

    @Override
    public long getCooldownWakeup(SendableRequestItem token, ClientContext context) {
        return this.cooldownWakeupTime;
    }

    public void schedule(ClientContext context) {
        if (this.key == null) {
            throw new NullPointerException();
        }
        this.getScheduler(context).register(this, new SendableGet[]{this}, this.persistent, this.ctx.blocks, false);
    }

    public void reschedule(ClientContext context) {
        this.getScheduler(context).register(null, new SendableGet[]{this}, this.persistent, this.ctx.blocks, true);
    }

    public SendableGet getRequest(Key key) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key[] listKeys() {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.cancelled || this.finished) {
                return new Key[0];
            }
        }
        return new Key[]{this.key.getNodeKey(true)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyListener makeKeyListener(ClientContext context, boolean onStartup) {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.finished) {
                return null;
            }
            if (this.cancelled) {
                return null;
            }
        }
        if (this.key == null) {
            Logger.error(this, "Key is null - left over BSSF? on " + this + " in makeKeyListener()", (Throwable)new Exception("error"));
            return null;
        }
        Key newKey = this.key.getNodeKey(true);
        if (this.parent == null) {
            Logger.error(this, "Parent is null on " + this + " persistent=" + this.persistent + " key=" + this.key + " ctx=" + this.ctx);
            return null;
        }
        short prio = this.parent.getPriorityClass();
        SingleKeyListener ret = new SingleKeyListener(newKey, this, prio, this.persistent);
        return ret;
    }

    protected abstract void notFoundInStore(ClientContext var1);

    @Override
    public boolean preRegister(ClientContext context, boolean toNetwork) {
        if (!toNetwork) {
            return false;
        }
        boolean localOnly = this.ctx.localRequestOnly;
        if (localOnly) {
            this.notFoundInStore(context);
            return true;
        }
        this.parent.toNetwork(context);
        return false;
    }

    @Override
    public synchronized long getWakeupTime(ClientContext context, long now) {
        if (this.cancelled || this.finished) {
            return -1L;
        }
        long wakeTime = this.cooldownWakeupTime;
        if (wakeTime <= now) {
            wakeTime = 0L;
            this.cooldownWakeupTime = 0L;
        }
        KeysFetchingLocally fetching = this.getScheduler(context).fetchingKeys();
        if (wakeTime <= 0L && fetching.hasKey(this.getNodeKey(null), this)) {
            wakeTime = Long.MAX_VALUE;
        }
        if (wakeTime == 0L) {
            return 0L;
        }
        return wakeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangedFetchContext(ClientContext context) {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.cancelled || this.finished) {
                return;
            }
        }
        this.innerCheckCachedCooldownData();
    }

    @Override
    public byte[] getWantedKey() {
        Key newKey = this.key.getNodeKey(false);
        return newKey instanceof NodeSSK ? ((NodeSSK)newKey).getPubKeyHash() : newKey.getRoutingKey();
    }

    public void onResume(ClientContext context) {
        this.schedule(context);
    }

    static {
        Logger.registerClass(BaseSingleFileFetcher.class);
    }
}

