/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.SimpleBlockChooser;
import java.util.Random;

public class CooldownBlockChooser
extends SimpleBlockChooser {
    private final int cooldownTries;
    private final long cooldownTime;
    private long overallCooldownTime;
    private long[] blockCooldownTimes;
    private long now;

    public CooldownBlockChooser(int blocks, Random random, int maxRetries, int cooldownTries, long cooldownTime) {
        super(blocks, random, maxRetries);
        this.cooldownTries = cooldownTries;
        this.cooldownTime = cooldownTime;
        this.blockCooldownTimes = new long[blocks];
    }

    @Override
    public synchronized int chooseKey() {
        this.now = System.currentTimeMillis();
        if (this.overallCooldownTime > this.now) {
            return -1;
        }
        this.overallCooldownTime = Long.MAX_VALUE;
        int ret = super.chooseKey();
        if (ret != -1) {
            this.overallCooldownTime = 0L;
        }
        return ret;
    }

    @Override
    protected boolean checkValid(int blockNo) {
        if (!super.checkValid(blockNo)) {
            return false;
        }
        long wakeUp = this.blockCooldownTimes[blockNo];
        if (this.now > wakeUp) {
            this.blockCooldownTimes[blockNo] = 0L;
            return true;
        }
        this.overallCooldownTime = Math.min(this.overallCooldownTime, wakeUp);
        return false;
    }

    @Override
    protected synchronized int innerOnNonFatalFailure(int blockNo) {
        int ret = super.innerOnNonFatalFailure(blockNo);
        if (ret > this.maxRetries && this.maxRetries != -1) {
            return ret;
        }
        if (ret % this.cooldownTries == 0) {
            this.blockCooldownTimes[blockNo] = System.currentTimeMillis() + this.cooldownTime;
            this.overallCooldownTime = Math.min(this.blockCooldownTimes[blockNo], this.overallCooldownTime);
        } else {
            this.blockCooldownTimes[blockNo] = 0L;
            this.overallCooldownTime = 0L;
        }
        return ret;
    }

    public final synchronized void clearCooldown() {
        this.overallCooldownTime = 0L;
    }

    @Override
    public synchronized void onUnSuccess(int blockNo) {
        this.blockCooldownTimes[blockNo] = 0L;
        this.clearCooldown();
    }

    public synchronized long overallCooldownTime() {
        return this.overallCooldownTime;
    }

    public synchronized long getCooldownTime(int blockNumber) {
        if (this.hasSucceeded(blockNumber)) {
            return 0L;
        }
        return this.blockCooldownTimes[blockNumber];
    }
}

