/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ClientMetadata;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.StreamGenerator;
import freenet.crypt.HashResult;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.support.compress.Compressor;
import java.io.Serializable;
import java.util.List;

public class USKProxyCompletionCallback
implements GetCompletionCallback,
Serializable {
    private static final long serialVersionUID = 1L;
    final USK usk;
    final GetCompletionCallback cb;
    final boolean persistent;

    public USKProxyCompletionCallback(USK usk, GetCompletionCallback cb, boolean persistent) {
        this.usk = usk;
        this.cb = cb;
        this.persistent = persistent;
    }

    @Override
    public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ClientContext context) {
        context.uskManager.updateKnownGood(this.usk, this.usk.suggestedEdition, context);
        this.cb.onSuccess(streamGenerator, clientMetadata, decompressors, state, context);
    }

    @Override
    public void onFailure(FetchException e, ClientGetState state, ClientContext context) {
        switch (e.mode) {
            case NOT_ENOUGH_PATH_COMPONENTS: 
            case PERMANENT_REDIRECT: {
                context.uskManager.updateKnownGood(this.usk, this.usk.suggestedEdition, context);
            }
        }
        FreenetURI uri = e.newURI;
        if (uri != null) {
            uri = this.usk.turnMySSKIntoUSK(uri);
            e = new FetchException(e, uri);
        }
        this.cb.onFailure(e, state, context);
    }

    @Override
    public void onBlockSetFinished(ClientGetState state, ClientContext context) {
        this.cb.onBlockSetFinished(state, context);
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
    }

    @Override
    public void onExpectedMIME(ClientMetadata metadata, ClientContext context) throws FetchException {
        this.cb.onExpectedMIME(metadata, context);
    }

    @Override
    public void onExpectedSize(long size, ClientContext context) {
        this.cb.onExpectedSize(size, context);
    }

    @Override
    public void onFinalizedMetadata() {
        this.cb.onFinalizedMetadata();
    }

    @Override
    public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ClientContext context) {
        this.cb.onExpectedTopSize(size, compressed, blocksReq, blocksTotal, context);
    }

    @Override
    public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean dontCompress, boolean bottomLayer, boolean definitiveAnyway, ClientContext context) {
        this.cb.onSplitfileCompatibilityMode(min, max, splitfileKey, dontCompress, bottomLayer, definitiveAnyway, context);
    }

    @Override
    public void onHashes(HashResult[] hashes, ClientContext context) {
        this.cb.onHashes(hashes, context);
    }
}

