/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.RIFFFilter;
import freenet.client.filter.VP8PacketFilter;
import freenet.l10n.NodeL10n;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class WebPFilter
extends RIFFFilter {
    private final int ANIMATION_FLAG = 2;
    private final int XMP_FLAG = 4;
    private final int EXIF_FLAG = 8;
    private final int ALPHA_FLAG = 16;
    private final int ICCP_FLAG = 32;
    private final int ALL_VALID_FLAGS = 62;

    @Override
    protected byte[] getChunkMagicNumber() {
        return new byte[]{87, 69, 66, 80};
    }

    @Override
    protected Object createContext() {
        return new WebPFilterContext();
    }

    @Override
    protected void readFilterChunk(byte[] ID, int size, Object context, DataInputStream input, DataOutputStream output, String charset, Map<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        boolean logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, this.getClass());
        WebPFilterContext ctx = (WebPFilterContext)context;
        if (ID[0] == 86 && ID[1] == 80 && ID[2] == 56 && ID[3] == 32) {
            if (ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM) {
                throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected VP8 chunk was encountered");
            }
            ctx.hasVP8 = true;
            this.filterVP8Block(ID, size, input, output, logDEBUG);
        } else {
            if (ID[0] == 86 && ID[1] == 80 && ID[2] == 56 && ID[3] == 76) {
                if (ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM || ctx.hasALPH) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected VP8L chunk was encountered");
                }
                ctx.hasVP8L = true;
                throw new DataFilterException(WebPFilter.l10n("losslessUnsupportedTitle"), WebPFilter.l10n("losslessUnsupportedTitle"), WebPFilter.l10n("losslessUnsupported"));
            }
            if (ID[0] == 65 && ID[1] == 76 && ID[2] == 80 && ID[3] == 72) {
                if (ctx.hasVP8L || ctx.hasANIM || ctx.hasALPH || !ctx.hasVP8X || (ctx.VP8XFlags & 0x10) == 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected ALPH chunk was encountered");
                }
                ctx.hasALPH = true;
                this.filterALPHBlock(ID, size, input, output, logDEBUG);
            } else if (ID[0] == 65 && ID[1] == 78 && ID[2] == 73 && ID[3] == 77) {
                if ((ctx.VP8XFlags & 2) == 0 || ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected ANIM chunk was encountered");
                }
                ctx.hasANIM = true;
                output.write(ID);
                WebPFilter.writeLittleEndianInt(output, size);
                if (size != 6) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "ANIM chunk size is too small or too big");
                }
                this.passthroughBytes(input, output, size);
            } else if (ID[0] == 65 && ID[1] == 78 && ID[2] == 77 && ID[3] == 70) {
                int ANMFRemainingSize;
                int ANMFBlockSize;
                if ((ctx.VP8XFlags & 2) == 0 || ctx.hasVP8 || ctx.hasVP8L || !ctx.hasANIM) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected ANMF chunk was encountered");
                }
                if (size < 24 || size % 2 != 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "ANMF chunk size is invalid (size=" + size + ")");
                }
                ctx.hasANMF = true;
                output.write(ID);
                WebPFilter.writeLittleEndianInt(output, size);
                int[] ANMFContent = new int[16];
                for (int i = 0; i < 16; ++i) {
                    ANMFContent[i] = input.readUnsignedByte();
                }
                int frameX = ANMFContent[0] | ANMFContent[1] << 8 | ANMFContent[2] << 16;
                int frameY = ANMFContent[3] | ANMFContent[4] << 8 | ANMFContent[5] << 16;
                int frameWidth = (ANMFContent[6] | ANMFContent[7] << 8 | ANMFContent[8] << 16) + 1;
                int frameHeight = (ANMFContent[9] | ANMFContent[10] << 8 | ANMFContent[11] << 16) + 1;
                int frameFlags = ANMFContent[15];
                if (frameX + frameWidth > ctx.width || frameY + frameHeight > ctx.height) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "ANMF canvas size extends beyond image size");
                }
                if ((frameFlags & 0xFC) != 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "ANMF block contains reserved flag");
                }
                for (int i = 0; i < 16; ++i) {
                    output.writeByte(ANMFContent[i]);
                }
                boolean ANMFHasVP8 = false;
                boolean ANMFHasALPH = false;
                byte[] ANMFBlockID = new byte[4];
                for (ANMFRemainingSize = size - 16; ANMFRemainingSize >= 8; ANMFRemainingSize -= ANMFBlockSize + ANMFBlockSize % 2 + 8) {
                    input.readFully(ANMFBlockID);
                    ANMFBlockSize = WebPFilter.readLittleEndianInt(input);
                    if (ANMFBlockID[0] == 86 && ANMFBlockID[1] == 80 && ANMFBlockID[2] == 56 && ANMFBlockID[3] == 32) {
                        if (ANMFHasVP8) {
                            throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected VP8 chunk was encountered inside ANMF block");
                        }
                        ANMFHasVP8 = true;
                        this.filterVP8Block(ANMFBlockID, ANMFBlockSize, input, output, logDEBUG);
                        continue;
                    }
                    if (ANMFBlockID[0] == 86 && ANMFBlockID[1] == 80 && ANMFBlockID[2] == 56 && ANMFBlockID[3] == 76) {
                        throw new DataFilterException(WebPFilter.l10n("animUnsupportedTitle"), WebPFilter.l10n("animUnsupportedTitle"), WebPFilter.l10n("animUnsupported"));
                    }
                    if (ANMFBlockID[0] == 65 && ANMFBlockID[1] == 76 && ANMFBlockID[2] == 80 && ANMFBlockID[3] == 72) {
                        if (ANMFHasALPH) {
                            throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected ALPH chunk was encountered inside ANMF block");
                        }
                        ANMFHasALPH = true;
                        this.filterALPHBlock(ANMFBlockID, ANMFBlockSize, input, output, logDEBUG);
                        continue;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "WebP image has Unknown block with " + ANMFBlockSize + " bytes within ANMF chunk converted into JUNK chunk.");
                    }
                    this.writeJunkChunk(input, output, ANMFBlockSize);
                }
                if (ANMFRemainingSize != 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected data remaining at the end of ANMF chunk");
                }
            } else if (ID[0] == 86 && ID[1] == 80 && ID[2] == 56 && ID[3] == 88) {
                int i;
                if (ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM || ctx.hasVP8X) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected VP8X chunk was encountered");
                }
                ctx.VP8XFlags = WebPFilter.readLittleEndianInt(input);
                if ((ctx.VP8XFlags & 0xFFFFFFC1) != 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "VP8X header has reserved flags");
                }
                if (size != 10) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "VP8X header is too small or too big");
                }
                output.write(ID);
                WebPFilter.writeLittleEndianInt(output, size);
                ctx.VP8XFlags &= 0xFFFFFFD3;
                WebPFilter.writeLittleEndianInt(output, ctx.VP8XFlags);
                ctx.hasVP8X = true;
                int[] widthHeight = new int[6];
                for (i = 0; i < 6; ++i) {
                    widthHeight[i] = input.readUnsignedByte();
                }
                ctx.width = widthHeight[0] | widthHeight[1] << 8 | widthHeight[2] << 16;
                ctx.height = widthHeight[3] | widthHeight[4] << 8 | widthHeight[5] << 16;
                ++ctx.width;
                ++ctx.height;
                if (ctx.width > 16384 || ctx.height > 16384) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "WebP image size is too big");
                }
                for (i = 0; i < 6; ++i) {
                    output.writeByte(widthHeight[i]);
                }
            } else if (ID[0] == 73 && ID[1] == 67 && ID[2] == 67 && ID[3] == 80) {
                if (logDEBUG) {
                    Logger.debug(this, "WebP image has ICCP block with " + size + " bytes converted into JUNK chunk.");
                }
                this.writeJunkChunk(input, output, size);
            } else if (ID[0] == 69 && ID[1] == 88 && ID[2] == 73 && ID[3] == 70) {
                if (logDEBUG) {
                    Logger.debug(this, "WebP image has EXIF block with " + size + " bytes converted into JUNK chunk.");
                }
                this.writeJunkChunk(input, output, size);
            } else if (ID[0] == 88 && ID[1] == 77 && ID[2] == 80 && ID[3] == 32) {
                if (logDEBUG) {
                    Logger.debug(this, "WebP image has XMP block with " + size + " bytes converted into JUNK chunk.");
                }
                this.writeJunkChunk(input, output, size);
            } else {
                if (logDEBUG) {
                    Logger.debug(this, "WebP image has Unknown block with " + size + " bytes converted into JUNK chunk.");
                }
                this.writeJunkChunk(input, output, size);
            }
        }
    }

    @Override
    protected void EOFCheck(Object context) throws DataFilterException {
        WebPFilterContext ctx = (WebPFilterContext)context;
        if (!(ctx.hasVP8 || ctx.hasVP8L || ctx.hasANMF)) {
            throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "No image chunk in the WebP file is found");
        }
    }

    private void filterVP8Block(byte[] ID, int size, DataInputStream input, DataOutputStream output, boolean logDEBUG) throws IOException {
        if (size < 10) {
            throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "The VP8 chunk was too small to be valid");
        }
        output.write(ID);
        if (logDEBUG) {
            Logger.debug(this, "Passing through WebP VP8 block with " + size + " bytes.");
        }
        VP8PacketFilter VP8filter = new VP8PacketFilter(true);
        byte[] buf = new byte[6];
        input.readFully(buf);
        VP8filter.parse(buf, size);
        WebPFilter.writeLittleEndianInt(output, size);
        output.write(buf);
        this.passthroughBytes(input, output, size - buf.length);
        if ((size & 1) != 0) {
            output.writeByte(input.readByte());
        }
    }

    private void filterALPHBlock(byte[] ID, int size, DataInputStream input, DataOutputStream output, boolean logDEBUG) throws IOException {
        if (size == 0) {
            throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected empty ALPH chunk");
        }
        int flags = input.readUnsignedByte();
        if ((flags & 2) != 0) {
            throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "WebP alpha channel contains reserved bits");
        }
        if ((flags & 0xC0) != 0) {
            throw new DataFilterException(WebPFilter.l10n("alphUnsupportedTitle"), WebPFilter.l10n("alphUnsupportedTitle"), WebPFilter.l10n("alphUnsupported"));
        }
        output.write(ID);
        if (logDEBUG) {
            Logger.debug(this, "Passing through WebP ALPH block with " + size + " bytes.");
        }
        WebPFilter.writeLittleEndianInt(output, size);
        output.writeByte(flags);
        this.passthroughBytes(input, output, size - 1);
        if ((size & 1) != 0) {
            output.writeByte(input.readByte());
        }
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("WebPFilter." + key);
    }

    private static final class WebPFilterContext {
        int VP8XFlags = 0;
        boolean hasVP8X = false;
        boolean hasANIM = false;
        boolean hasANMF = false;
        boolean hasALPH = false;
        boolean hasVP8 = false;
        boolean hasVP8L = false;
        int width = 0;
        int height = 0;

        private WebPFilterContext() {
        }
    }
}

