/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPPluginConnection;
import freenet.clients.fcp.FCPPluginConnectionTracker;
import freenet.clients.fcp.FCPPluginMessage;
import freenet.clients.fcp.FCPPluginServerMessage;
import freenet.node.PrioRunnable;
import freenet.pluginmanager.FredPluginFCPMessageHandler;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class FCPPluginConnectionImpl
implements FCPPluginConnection {
    private static volatile transient boolean logDEBUG = false;
    private static volatile transient boolean logMINOR = false;
    private final UUID id = UUID.randomUUID();
    private final Executor executor;
    private final String serverPluginName;
    private final WeakReference<FredPluginFCPMessageHandler.ServerSideFCPMessageHandler> server;
    private final FredPluginFCPMessageHandler.ClientSideFCPMessageHandler client;
    private final FCPConnectionHandler clientConnection;
    private final TreeMap<String, SynchronousSend> synchronousSends = new TreeMap();
    private final ReadWriteLock synchronousSendsLock = new ReentrantReadWriteLock();
    private final EnumMap<FCPPluginConnection.SendDirection, DefaultSendDirectionAdapter> defaultSendDirectionAdapters = new EnumMap(FCPPluginConnection.SendDirection.class);

    private FCPPluginConnectionImpl(FCPPluginConnectionTracker tracker, Executor executor, String serverPluginName, FredPluginFCPMessageHandler.ServerSideFCPMessageHandler serverPlugin, FCPConnectionHandler clientConnection) {
        assert (tracker != null);
        assert (executor != null);
        assert (serverPlugin != null);
        assert (serverPluginName != null);
        assert (clientConnection != null);
        this.executor = executor;
        this.serverPluginName = serverPluginName;
        this.server = new WeakReference<FredPluginFCPMessageHandler.ServerSideFCPMessageHandler>(serverPlugin);
        this.client = null;
        this.clientConnection = clientConnection;
        this.defaultSendDirectionAdapters.put(FCPPluginConnection.SendDirection.ToServer, new SendToServerAdapter(this));
        tracker.registerConnection(this);
        this.defaultSendDirectionAdapters.put(FCPPluginConnection.SendDirection.ToClient, new SendToClientAdapter(tracker, this.id));
    }

    static FCPPluginConnectionImpl constructForNetworkedFCP(FCPPluginConnectionTracker tracker, Executor executor, PluginManager serverPluginManager, String serverPluginName, FCPConnectionHandler clientConnection) throws PluginNotFoundException {
        assert (tracker != null);
        assert (executor != null);
        assert (serverPluginManager != null);
        assert (serverPluginName != null);
        assert (clientConnection != null);
        return new FCPPluginConnectionImpl(tracker, executor, serverPluginName, serverPluginManager.getPluginFCPServer(serverPluginName), clientConnection);
    }

    private FCPPluginConnectionImpl(FCPPluginConnectionTracker tracker, Executor executor, String serverPluginName, FredPluginFCPMessageHandler.ServerSideFCPMessageHandler server, FredPluginFCPMessageHandler.ClientSideFCPMessageHandler client) {
        assert (tracker != null);
        assert (executor != null);
        assert (serverPluginName != null);
        assert (server != null);
        assert (client != null);
        this.executor = executor;
        this.serverPluginName = serverPluginName;
        this.server = new WeakReference<FredPluginFCPMessageHandler.ServerSideFCPMessageHandler>(server);
        this.client = client;
        this.clientConnection = null;
        this.defaultSendDirectionAdapters.put(FCPPluginConnection.SendDirection.ToServer, new SendToServerAdapter(this));
        tracker.registerConnection(this);
        this.defaultSendDirectionAdapters.put(FCPPluginConnection.SendDirection.ToClient, new SendToClientAdapter(tracker, this.id));
    }

    static FCPPluginConnectionImpl constructForIntraNodeFCP(FCPPluginConnectionTracker tracker, Executor executor, PluginManager serverPluginManager, String serverPluginName, FredPluginFCPMessageHandler.ClientSideFCPMessageHandler client) throws PluginNotFoundException {
        assert (executor != null);
        assert (serverPluginManager != null);
        assert (serverPluginName != null);
        assert (client != null);
        return new FCPPluginConnectionImpl(tracker, executor, serverPluginName, serverPluginManager.getPluginFCPServer(serverPluginName), client);
    }

    public static FCPPluginConnectionImpl constructForUnitTest(FredPluginFCPMessageHandler.ServerSideFCPMessageHandler server, FredPluginFCPMessageHandler.ClientSideFCPMessageHandler client) {
        assert (server != null);
        assert (client != null);
        FCPPluginConnectionTracker tracker = new FCPPluginConnectionTracker();
        tracker.start();
        return new FCPPluginConnectionImpl(tracker, (Executor)new PooledExecutor(), server.toString(), server, client);
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    boolean isServerDead() {
        return this.server.get() == null;
    }

    private FCPPluginMessage.ClientPermissions getCurrentClientPermissions() {
        if (this.clientConnection != null) {
            return this.clientConnection.hasFullAccess() ? FCPPluginMessage.ClientPermissions.ACCESS_FCP_FULL : FCPPluginMessage.ClientPermissions.ACCESS_FCP_RESTRICTED;
        }
        assert (this.client != null);
        return FCPPluginMessage.ClientPermissions.ACCESS_DIRECT;
    }

    @Override
    public void send(FCPPluginConnection.SendDirection direction, FCPPluginMessage message) throws IOException {
        FredPluginFCPMessageHandler.ClientSideFCPMessageHandler messageHandler;
        boolean messageHandlerExistsLocally;
        FCPPluginMessage.ClientPermissions currentClientPermissions = direction == FCPPluginConnection.SendDirection.ToClient ? null : this.getCurrentClientPermissions();
        message = FCPPluginMessage.constructRawMessage(currentClientPermissions, message.identifier, message.params, message.data, message.success, message.errorCode, message.errorMessage);
        if (logDEBUG) {
            Logger.debug(this, "send(): direction = " + (Object)((Object)direction) + "; message = " + message);
        }
        boolean bl = messageHandlerExistsLocally = direction == FCPPluginConnection.SendDirection.ToServer || direction == FCPPluginConnection.SendDirection.ToClient && this.client != null;
        if (!messageHandlerExistsLocally) {
            this.dispatchMessageByNetwork(direction, message);
            return;
        }
        assert (direction != FCPPluginConnection.SendDirection.ToServer ? this.client != null : this.server != null) : "We already decided that the message handler exists locally. We should have only decided so if the handler is not null.";
        if (this.dispatchMessageLocallyToSendSynchronousThreadIfExisting(direction, message)) {
            return;
        }
        FredPluginFCPMessageHandler fredPluginFCPMessageHandler = messageHandler = direction == FCPPluginConnection.SendDirection.ToServer ? (FredPluginFCPMessageHandler)this.server.get() : this.client;
        if (messageHandler == null) {
            throw new IOException("The server plugin has been unloaded.");
        }
        this.dispatchMessageLocallyToMessageHandler(messageHandler, direction, message);
    }

    private void dispatchMessageByNetwork(FCPPluginConnection.SendDirection direction, FCPPluginMessage message) throws IOException {
        assert (direction == FCPPluginConnection.SendDirection.ToClient) : "By design, this class always shall execute in the same VM as the server plugin. So for networked messages, we should always be sending to the client.";
        assert (this.clientConnection != null) : "Trying to send a message over the network to the client. So the network connection to it should not be null.";
        if (this.clientConnection.isClosed()) {
            throw new IOException("Connection to client closed for " + this);
        }
        this.clientConnection.send(new FCPPluginServerMessage(this.serverPluginName, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchMessageLocallyToSendSynchronousThreadIfExisting(FCPPluginConnection.SendDirection direction, FCPPluginMessage message) {
        if (!message.isReplyMessage()) {
            return false;
        }
        this.synchronousSendsLock.readLock().lock();
        try {
            if (!this.synchronousSends.containsKey(message.identifier)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.synchronousSendsLock.readLock().unlock();
        }
        this.synchronousSendsLock.writeLock().lock();
        try {
            SynchronousSend synchronousSend = this.synchronousSends.get(message.identifier);
            if (synchronousSend == null) {
                boolean bl = false;
                return bl;
            }
            assert (synchronousSend.reply == null) : "One identifier should not be used for multiple messages or replies";
            synchronousSend.reply = message;
            synchronousSend.completionSignal.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.synchronousSendsLock.writeLock().unlock();
        }
    }

    private void dispatchMessageLocallyToMessageHandler(final FredPluginFCPMessageHandler messageHandler, final FCPPluginConnection.SendDirection direction, final FCPPluginMessage message) {
        PrioRunnable messageDispatcher = new PrioRunnable(){

            @Override
            public void run() {
                FCPPluginMessage reply;
                block15: {
                    reply = null;
                    try {
                        try {
                            reply = messageHandler.handlePluginFCPMessage(FCPPluginConnectionImpl.this.getDefaultSendDirectionAdapter(direction.invert()), message);
                        }
                        catch (Error e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (RuntimeException e) {
                        String errorMessage = "FredPluginFCPMessageHandler threw. See JavaDoc of its member interfaces for how signal errors properly. connection = " + FCPPluginConnectionImpl.this + "; SendDirection = " + (Object)((Object)direction) + "; message = " + message;
                        Logger.error(messageHandler, errorMessage, (Throwable)e);
                        if (message.isReplyMessage()) break block15;
                        reply = FCPPluginMessage.constructReplyMessage(message, null, null, false, "InternalError", errorMessage + "; Throwable = " + e.toString());
                    }
                }
                if (reply != null) {
                    if (message.isReplyMessage()) {
                        Logger.error(messageHandler, "FredPluginFCPMessageHandler tried to send a reply to a reply. Discarding it. See JavaDoc of its member interfaces for how to do this properly. connection = " + FCPPluginConnectionImpl.this + "; original message SendDirection = " + (Object)((Object)direction) + "; original message = " + message + "; reply = " + reply);
                        reply = null;
                    } else if (!reply.isReplyMessage()) {
                        Logger.error(messageHandler, "FredPluginFCPMessageHandler tried to send a non-reply message as reply. See JavaDoc of its member interfaces for how to do this properly. connection = " + FCPPluginConnectionImpl.this + "; original message SendDirection = " + (Object)((Object)direction) + "; original message = " + message + "; reply = " + reply);
                        reply = null;
                    } else if (!reply.identifier.equals(message.identifier)) {
                        Logger.error(messageHandler, "FredPluginFCPMessageHandler tried to send a reply with with different identifier than original message. See JavaDoc of its member interfaces for how to do this properly. connection = " + FCPPluginConnectionImpl.this + "; original message SendDirection = " + (Object)((Object)direction) + "; original message = " + message + "; reply = " + reply);
                        reply = null;
                    }
                } else if (reply == null && !message.isReplyMessage()) {
                    Logger.warning(messageHandler, "Fred did not receive a reply from the message handler even though it was allowed to reply. This would cause sendSynchronous() to timeout!  connection = " + FCPPluginConnectionImpl.this + "; SendDirection = " + (Object)((Object)direction) + "; message = " + message);
                }
                if (reply == null) {
                    return;
                }
                try {
                    FCPPluginConnectionImpl.this.send(direction.invert(), reply);
                }
                catch (IOException e) {
                    Logger.warning(messageHandler, "Sending reply from FredPluginFCPMessageHandler failed, the connection was closed already. connection = " + FCPPluginConnectionImpl.this + "; original message SendDirection = " + (Object)((Object)direction) + "; original message = " + message + "; reply = " + reply, (Throwable)e);
                }
            }

            @Override
            public int getPriority() {
                NativeThread.PriorityLevel priority = NativeThread.PriorityLevel.NORM_PRIORITY;
                if (messageHandler instanceof FredPluginFCPMessageHandler.PrioritizedMessageHandler) {
                    try {
                        priority = ((FredPluginFCPMessageHandler.PrioritizedMessageHandler)((Object)messageHandler)).getPriority(message);
                    }
                    catch (Throwable t) {
                        Logger.error(messageHandler, "Message handler's getPriority() threw!", t);
                    }
                }
                return priority.value;
            }

            public String toString() {
                return "FCPPluginConnection for " + FCPPluginConnectionImpl.this.serverPluginName;
            }
        };
        this.executor.execute(messageDispatcher, messageDispatcher.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FCPPluginMessage sendSynchronous(FCPPluginConnection.SendDirection direction, FCPPluginMessage message, long timeoutNanoSeconds) throws IOException, InterruptedException {
        if (message.isReplyMessage()) {
            throw new IllegalArgumentException("sendSynchronous() cannot send reply messages: If it did send a reply message, it would not get another reply back. But a reply is needed for sendSynchronous() to determine when to return.");
        }
        assert (timeoutNanoSeconds > 0L) : "Timeout should not be negative";
        assert (timeoutNanoSeconds <= TimeUnit.MINUTES.toNanos(1L)) : "Please use sane timeouts to prevent thread congestion";
        this.synchronousSendsLock.writeLock().lock();
        try {
            Condition completionSignal = this.synchronousSendsLock.writeLock().newCondition();
            SynchronousSend synchronousSend = new SynchronousSend(completionSignal);
            assert (!this.synchronousSends.containsKey(message.identifier)) : "FCPPluginMessage.identifier should be unique";
            this.synchronousSends.put(message.identifier, synchronousSend);
            if (logMINOR) {
                Logger.minor(this, "sendSynchronous(): Started for identifier " + message.identifier + "; synchronousSends table size: " + this.synchronousSends.size());
            }
            this.send(direction, message);
            do {
                if ((timeoutNanoSeconds = completionSignal.awaitNanos(timeoutNanoSeconds)) > 0L) continue;
                throw new IOException("sendSynchronous() timed out waiting for reply!  connection = " + this + "; SendDirection = " + (Object)((Object)direction) + "; message = " + message);
            } while (synchronousSend.reply == null);
            assert (synchronousSend.reply.identifier.equals(message.identifier));
            FCPPluginMessage fCPPluginMessage = synchronousSend.reply;
            return fCPPluginMessage;
        }
        finally {
            this.synchronousSends.remove(message.identifier);
            if (logMINOR) {
                Logger.minor(this, "sendSynchronous(): Done for identifier " + message.identifier + "; synchronousSends table size: " + this.synchronousSends.size());
            }
            this.synchronousSendsLock.writeLock().unlock();
        }
    }

    public FCPPluginConnection getDefaultSendDirectionAdapter(FCPPluginConnection.SendDirection direction) {
        return this.defaultSendDirectionAdapters.get((Object)direction);
    }

    @Override
    public void send(FCPPluginMessage message) {
        throw new NoSendDirectionSpecifiedException();
    }

    @Override
    public FCPPluginMessage sendSynchronous(FCPPluginMessage message, long timeoutNanoSeconds) {
        throw new NoSendDirectionSpecifiedException();
    }

    @Override
    public String toString() {
        return "FCPPluginConnectionImpl (ID: " + this.id + "; server class: " + this.serverPluginName + "; server: " + (this.server != null ? (FredPluginFCPMessageHandler.ServerSideFCPMessageHandler)this.server.get() : null) + "; client: " + this.client + "; clientConnection: " + this.clientConnection + ")";
    }

    int getSendSynchronousCount() {
        this.synchronousSendsLock.readLock().lock();
        try {
            int n = this.synchronousSends.size();
            return n;
        }
        finally {
            this.synchronousSendsLock.readLock().unlock();
        }
    }

    static {
        Logger.registerClass(FCPPluginConnectionImpl.class);
    }

    private static final class NoSendDirectionSpecifiedException
    extends UnsupportedOperationException {
        public NoSendDirectionSpecifiedException() {
            super("You must obtain a FCPPluginConnectionImpl with a default SendDirection via getDefaultSendDirectionAdapter() before you may use this function!");
        }
    }

    private static final class SendToServerAdapter
    extends DefaultSendDirectionAdapter {
        private final FCPPluginConnection parent;

        SendToServerAdapter(FCPPluginConnectionImpl parent) {
            super(FCPPluginConnection.SendDirection.ToServer);
            this.parent = parent;
        }

        @Override
        protected FCPPluginConnection getConnection() {
            return this.parent;
        }

        @Override
        public UUID getID() {
            return this.parent.getID();
        }

        @Override
        public String toString() {
            return "SendToServerAdapter for " + this.parent;
        }
    }

    private static final class SendToClientAdapter
    extends DefaultSendDirectionAdapter {
        private final FCPPluginConnectionTracker.ConnectionWeakReference connectionRef;

        SendToClientAdapter(FCPPluginConnectionTracker tracker, UUID connectionID) {
            super(FCPPluginConnection.SendDirection.ToClient);
            try {
                this.connectionRef = tracker.getConnectionWeakReference(connectionID);
            }
            catch (IOException e) {
                throw new RuntimeException("SHOULD NOT HAPPEN: ", e);
            }
        }

        @Override
        protected FCPPluginConnection getConnection() throws IOException {
            FCPPluginConnection connection = (FCPPluginConnection)this.connectionRef.get();
            if (connection == null) {
                throw new IOException("Client has closed the connection. Connection ID = " + this.connectionRef.connectionID);
            }
            return connection;
        }

        @Override
        public UUID getID() {
            return this.connectionRef.connectionID;
        }

        @Override
        public String toString() {
            String prefix = "SendToClientAdapter for ";
            try {
                return prefix + this.getConnection();
            }
            catch (IOException e) {
                return prefix + " FCPPluginConnectionImpl (" + e.getMessage() + ")";
            }
        }
    }

    private static abstract class DefaultSendDirectionAdapter
    implements FCPPluginConnection {
        private final FCPPluginConnection.SendDirection defaultDirection;

        DefaultSendDirectionAdapter(FCPPluginConnection.SendDirection defaultDirection) {
            this.defaultDirection = defaultDirection;
        }

        protected abstract FCPPluginConnection getConnection() throws IOException;

        @Override
        public void send(FCPPluginMessage message) throws IOException {
            this.send(this.defaultDirection, message);
        }

        @Override
        public FCPPluginMessage sendSynchronous(FCPPluginMessage message, long timeoutNanoSeconds) throws IOException, InterruptedException {
            return this.sendSynchronous(this.defaultDirection, message, timeoutNanoSeconds);
        }

        @Override
        public void send(FCPPluginConnection.SendDirection direction, FCPPluginMessage message) throws IOException {
            this.getConnection().send(direction, message);
        }

        @Override
        public FCPPluginMessage sendSynchronous(FCPPluginConnection.SendDirection direction, FCPPluginMessage message, long timeoutNanoSeconds) throws IOException, InterruptedException {
            return this.getConnection().sendSynchronous(direction, message, timeoutNanoSeconds);
        }
    }

    private static final class SynchronousSend {
        private final Condition completionSignal;
        public FCPPluginMessage reply = null;

        public SynchronousSend(Condition completionSignal) {
            this.completionSignal = completionSignal;
        }
    }
}

