/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.SendPeerMessage;
import freenet.keys.FreenetURI;
import freenet.node.DarknetPeerNode;
import freenet.support.SimpleFieldSet;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;

public class SendBookmarkMessage
extends SendPeerMessage {
    public static final String NAME = "SendBookmark";
    private final FreenetURI uri;
    private final String name;
    private final boolean hasAnAnActiveLink;

    public SendBookmarkMessage(SimpleFieldSet fs) throws MessageInvalidException {
        super(fs);
        try {
            this.name = fs.get("Name");
            if (this.name == null) {
                throw new MessageInvalidException(5, "No name", this.identifier, false);
            }
            this.uri = new FreenetURI(fs.get("URI"));
            this.hasAnAnActiveLink = fs.getBoolean("HasAnActivelink", false);
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, false);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        fs.putSingle("Name", this.name);
        fs.putSingle("URI", this.uri.toString());
        fs.put("HasAnActivelink", this.hasAnAnActiveLink);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected int handleFeed(DarknetPeerNode pn) throws MessageInvalidException {
        try {
            if (this.dataLength() > 0L) {
                byte[] description = BucketTools.toByteArray(this.bucket);
                return pn.sendBookmarkFeed(this.uri, this.name, new String(description, StandardCharsets.UTF_8), this.hasAnAnActiveLink);
            }
            return pn.sendBookmarkFeed(this.uri, this.name, null, this.hasAnAnActiveLink);
        }
        catch (IOException e) {
            throw new MessageInvalidException(7, "", null, false);
        }
    }
}

