/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.support.Fields;
import freenet.support.api.HTTPRequest;

public class PersistFields {
    public final FirstTimeWizardToadlet.WIZARD_PRESET preset;
    public final boolean opennet;
    public final boolean singleStep;

    public PersistFields(HTTPRequest request) {
        this.preset = this.parsePreset(request);
        this.opennet = this.parseOpennet(request);
        this.singleStep = this.parseSingleStep(request);
    }

    public PersistFields(boolean opennet, HTTPRequest request) {
        this.preset = this.parsePreset(request);
        this.opennet = opennet;
        this.singleStep = this.parseSingleStep(request);
    }

    public PersistFields(FirstTimeWizardToadlet.WIZARD_PRESET preset, HTTPRequest request) {
        this.preset = preset;
        this.opennet = this.parseOpennet(request);
        this.singleStep = this.parseSingleStep(request);
    }

    private FirstTimeWizardToadlet.WIZARD_PRESET parsePreset(HTTPRequest request) {
        FirstTimeWizardToadlet.WIZARD_PRESET preset;
        String presetRaw = request.hasParameters() ? request.getParam("preset") : request.getPartAsStringFailsafe("preset", 4);
        try {
            preset = FirstTimeWizardToadlet.WIZARD_PRESET.valueOf(presetRaw);
        }
        catch (IllegalArgumentException e) {
            preset = null;
        }
        return preset;
    }

    private boolean parseOpennet(HTTPRequest request) {
        String opennetRaw = request.hasParameters() ? request.getParam("opennet", "false") : request.getPartAsStringFailsafe("opennet", 5);
        return Fields.stringToBool(opennetRaw, false);
    }

    private boolean parseSingleStep(HTTPRequest request) {
        String singleStepRaw = request.hasParameters() ? request.getParam("singlestep", "false") : request.getPartAsStringFailsafe("singlestep", 5);
        return Fields.stringToBool(singleStepRaw, false);
    }

    public boolean isUsingPreset() {
        return this.preset != null;
    }

    public boolean isSingleStep() {
        return this.singleStep;
    }

    public String appendTo(String baseURL) {
        StringBuilder url = new StringBuilder(baseURL).append("&opennet=").append(this.opennet);
        if (this.isUsingPreset()) {
            url.append("&preset=").append((Object)this.preset);
        }
        if (this.isSingleStep()) {
            url.append("&singlestep=").append(this.singleStep);
        }
        return url.toString();
    }
}

