/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.LineReadingInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FilePersistentConfig
extends PersistentConfig {
    final File filename;
    final File tempFilename;
    protected final String header;
    protected final Object storeSync = new Object();
    protected boolean writeOnFinished;
    private static volatile boolean logMINOR;

    public static FilePersistentConfig constructFilePersistentConfig(File f) throws IOException {
        return FilePersistentConfig.constructFilePersistentConfig(f, null);
    }

    public static FilePersistentConfig constructFilePersistentConfig(File f, String header) throws IOException {
        File filename = f;
        File tempFilename = new File(f.getPath() + ".tmp");
        return new FilePersistentConfig(FilePersistentConfig.load(filename, tempFilename), filename, tempFilename, header);
    }

    static SimpleFieldSet load(File filename, File tempFilename) throws IOException {
        block12: {
            boolean filenameExists = filename.exists();
            boolean tempFilenameExists = tempFilename.exists();
            if (filenameExists && !filename.canWrite()) {
                Logger.error(FilePersistentConfig.class, "Warning: Cannot write to config file: " + filename);
                System.err.println("Warning: Cannot write to config file: " + filename);
            }
            if (tempFilenameExists && !tempFilename.canWrite()) {
                Logger.error(FilePersistentConfig.class, "Warning: Cannot write to config tempfile: " + tempFilename);
                System.err.println("Warning: Cannot write to config tempfile: " + tempFilename);
            }
            if (filenameExists) {
                if (filename.canRead() && filename.length() > 0L) {
                    try {
                        return FilePersistentConfig.initialLoad(filename);
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Cannot open config file " + filename + " : " + e + " - checking for temp file " + tempFilename);
                        break block12;
                    }
                    catch (EOFException e) {
                        System.err.println("Empty config file " + filename + " (end of file)");
                        break block12;
                    }
                }
                System.err.println("Cannot read config file " + filename);
            }
        }
        if (tempFilename.exists()) {
            if (tempFilename.canRead() && tempFilename.length() > 0L) {
                try {
                    return FilePersistentConfig.initialLoad(tempFilename);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot open temp config file either: " + tempFilename + " : " + e);
                }
            } else {
                System.err.println("Cannot read (temp) config file " + tempFilename);
                throw new IOException("Cannot read (temp) config file " + tempFilename);
            }
        }
        System.err.println("No config file found, creating new: " + filename);
        return null;
    }

    protected FilePersistentConfig(SimpleFieldSet origFS, File fnam, File temp) throws IOException {
        this(origFS, fnam, temp, null);
    }

    protected FilePersistentConfig(SimpleFieldSet origFS, File fnam, File temp, String header) throws IOException {
        super(origFS);
        this.filename = fnam;
        this.tempFilename = temp;
        this.header = header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleFieldSet initialLoad(File toRead) throws IOException {
        SimpleFieldSet simpleFieldSet;
        if (toRead == null) {
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        LineReadingInputStream lis = null;
        try {
            fis = new FileInputStream(toRead);
            bis = new BufferedInputStream(fis);
            lis = new LineReadingInputStream(bis);
            simpleFieldSet = new SimpleFieldSet(lis, 0x100000, 128, true, true, true);
        }
        catch (Throwable throwable) {
            Closer.close(lis);
            Closer.close(bis);
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(lis);
        Closer.close(bis);
        Closer.close(fis);
        return simpleFieldSet;
    }

    @Override
    public void register(SubConfig sc) {
        super.register(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() {
        if (!this.finishedInit) {
            this.writeOnFinished = true;
            return;
        }
        try {
            Object object = this.storeSync;
            synchronized (object) {
                this.innerStore();
            }
        }
        catch (IOException e) {
            String err = "Cannot store config: " + e;
            Logger.error(this, err, (Throwable)e);
            System.err.println(err);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void innerStore() throws IOException {
        if (!this.finishedInit) {
            throw new IllegalStateException("SHOULD NOT HAPPEN!!");
        }
        SimpleFieldSet fs = this.exportFieldSet();
        if (logMINOR) {
            Logger.minor(this, "fs = " + fs);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.tempFilename);
            FilePersistentConfig filePersistentConfig = this;
            synchronized (filePersistentConfig) {
                fs.setHeader(this.header);
                fs.writeToBigBuffer(fos);
            }
            fos.close();
            fos = null;
            FileUtil.moveTo(this.tempFilename, this.filename);
        }
        catch (Throwable throwable) {
            Closer.close(fos);
            throw throwable;
        }
        Closer.close(fos);
    }

    @Override
    public void finishedInit() {
        super.finishedInit();
        if (this.writeOnFinished) {
            this.writeOnFinished = false;
            this.store();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

