/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.HashResult;
import freenet.crypt.MultiHashDigester;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiHashOutputStream
extends FilterOutputStream {
    private final MultiHashDigester digester;

    public MultiHashOutputStream(OutputStream proxy, long generateHashes) {
        super(proxy);
        this.digester = MultiHashDigester.fromBitmask(generateHashes);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.digester.update(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
        this.digester.update(buf, off, len);
    }

    public HashResult[] getResults() {
        return this.digester.getResults().toArray(new HashResult[0]);
    }
}

