/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.keys.Key;
import freenet.node.PeerNode;
import freenet.node.PeerNodeUnlocked;
import freenet.node.TimedOutNodesList;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

class FailureTableEntry
implements TimedOutNodesList {
    final Key key;
    long creationTime;
    long receivedTime;
    long sentTime;
    WeakReference<? extends PeerNodeUnlocked>[] requestorNodes;
    long[] requestorTimes;
    long[] requestorBootIDs;
    short[] requestorHTLs;
    WeakReference<? extends PeerNodeUnlocked>[] requestedNodes;
    double[] requestedLocs;
    long[] requestedBootIDs;
    long[] requestedTimes;
    long[] requestedTimeoutsRF;
    long[] requestedTimeoutsFT;
    short[] requestedTimeoutHTLs;
    private static volatile boolean logMINOR;
    static final long MAX_TIME_BETWEEN_REQUEST_AND_OFFER;
    public static final long[] EMPTY_LONG_ARRAY;
    public static final short[] EMPTY_SHORT_ARRAY;
    public static final double[] EMPTY_DOUBLE_ARRAY;
    public static final WeakReference<? extends PeerNodeUnlocked>[] EMPTY_WEAK_REFERENCE;

    FailureTableEntry(Key key) {
        long now;
        this.key = key.archivalCopy();
        this.creationTime = now = System.currentTimeMillis();
        this.receivedTime = -1L;
        this.sentTime = -1L;
        this.requestorNodes = EMPTY_WEAK_REFERENCE;
        this.requestorTimes = EMPTY_LONG_ARRAY;
        this.requestorBootIDs = EMPTY_LONG_ARRAY;
        this.requestorHTLs = EMPTY_SHORT_ARRAY;
        this.requestedNodes = EMPTY_WEAK_REFERENCE;
        this.requestedLocs = EMPTY_DOUBLE_ARRAY;
        this.requestedBootIDs = EMPTY_LONG_ARRAY;
        this.requestedTimes = EMPTY_LONG_ARRAY;
        this.requestedTimeoutsRF = EMPTY_LONG_ARRAY;
        this.requestedTimeoutsFT = EMPTY_LONG_ARRAY;
        this.requestedTimeoutHTLs = EMPTY_SHORT_ARRAY;
    }

    public synchronized void failedTo(PeerNodeUnlocked routedTo, long rfTimeout, long ftTimeout, long now, short htl) {
        long curTimeoutTime;
        long newTimeoutTime;
        if (logMINOR) {
            Logger.minor(this, "Failed sending request to " + routedTo.shortToString() + " : timeout " + rfTimeout + " / " + ftTimeout);
        }
        int idx = this.addRequestedFrom(routedTo, htl, now);
        if (rfTimeout > 0L && (newTimeoutTime = now + rfTimeout) > (curTimeoutTime = this.requestedTimeoutsRF[idx])) {
            this.requestedTimeoutsRF[idx] = newTimeoutTime;
            this.requestedTimeoutHTLs[idx] = htl;
        }
        if (ftTimeout > 0L && (newTimeoutTime = now + ftTimeout) > (curTimeoutTime = this.requestedTimeoutsFT[idx])) {
            this.requestedTimeoutsFT[idx] = newTimeoutTime;
            this.requestedTimeoutHTLs[idx] = htl;
        }
    }

    synchronized int addRequestor(PeerNodeUnlocked requestor, long now, short origHTL) {
        int i;
        int notIncluded;
        if (logMINOR) {
            Logger.minor(this, "Adding requestors: " + requestor + " at " + now);
        }
        this.receivedTime = now;
        boolean includedAlready = false;
        int nulls = 0;
        int ret = -1;
        for (int i2 = 0; i2 < this.requestorNodes.length; ++i2) {
            PeerNodeUnlocked got;
            PeerNodeUnlocked peerNodeUnlocked = got = this.requestorNodes[i2] == null ? null : (PeerNodeUnlocked)this.requestorNodes[i2].get();
            if (got == requestor) {
                includedAlready = true;
                this.requestorTimes[i2] = now;
                this.requestorBootIDs[i2] = requestor.getBootID();
                this.requestorHTLs[i2] = origHTL;
                ret = i2;
                break;
            }
            if (got != null && (got.getBootID() != this.requestorBootIDs[i2] || now - this.requestorTimes[i2] > MAX_TIME_BETWEEN_REQUEST_AND_OFFER)) {
                this.requestorNodes[i2] = null;
                got = null;
            }
            if (got != null) continue;
            ++nulls;
        }
        if (nulls == 0 && includedAlready) {
            return ret;
        }
        int n = notIncluded = includedAlready ? 0 : 1;
        if (nulls == 1 && !includedAlready) {
            for (int i3 = 0; i3 < this.requestorNodes.length; ++i3) {
                if (this.requestorNodes[i3] != null && this.requestorNodes[i3].get() != null) continue;
                this.requestorNodes[i3] = requestor.getWeakRef();
                this.requestorTimes[i3] = now;
                this.requestorBootIDs[i3] = requestor.getBootID();
                this.requestorHTLs[i3] = origHTL;
                return i3;
            }
        }
        WeakReference[] newRequestorNodes = new WeakReference[this.requestorNodes.length + notIncluded - nulls];
        long[] newRequestorTimes = new long[this.requestorNodes.length + notIncluded - nulls];
        long[] newRequestorBootIDs = new long[this.requestorNodes.length + notIncluded - nulls];
        short[] newRequestorHTLs = new short[this.requestorNodes.length + notIncluded - nulls];
        int toIndex = 0;
        for (i = 0; i < this.requestorNodes.length; ++i) {
            PeerNodeUnlocked pn;
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestorNodes[i];
            PeerNodeUnlocked peerNodeUnlocked = pn = ref == null ? null : (PeerNodeUnlocked)ref.get();
            if (pn == null) continue;
            if (pn == requestor) {
                ret = toIndex;
            }
            newRequestorNodes[toIndex] = this.requestorNodes[i];
            newRequestorTimes[toIndex] = this.requestorTimes[i];
            newRequestorBootIDs[toIndex] = this.requestorBootIDs[i];
            newRequestorHTLs[toIndex] = this.requestorHTLs[i];
            ++toIndex;
        }
        if (!includedAlready) {
            newRequestorNodes[toIndex] = requestor.getWeakRef();
            newRequestorTimes[toIndex] = now;
            newRequestorBootIDs[toIndex] = requestor.getBootID();
            newRequestorHTLs[toIndex] = origHTL;
            ret = toIndex++;
        }
        for (i = toIndex; i < newRequestorNodes.length; ++i) {
            newRequestorNodes[i] = null;
        }
        if (toIndex > newRequestorNodes.length + 2) {
            newRequestorNodes = Arrays.copyOf(newRequestorNodes, toIndex);
            newRequestorTimes = Arrays.copyOf(newRequestorTimes, toIndex);
            newRequestorBootIDs = Arrays.copyOf(newRequestorBootIDs, toIndex);
            newRequestorHTLs = Arrays.copyOf(newRequestorHTLs, toIndex);
        }
        this.requestorNodes = newRequestorNodes;
        this.requestorTimes = newRequestorTimes;
        this.requestorBootIDs = newRequestorBootIDs;
        this.requestorHTLs = newRequestorHTLs;
        return ret;
    }

    private synchronized int addRequestedFrom(PeerNodeUnlocked requestedFrom, short htl, long now) {
        int i;
        int notIncluded;
        if (logMINOR) {
            Logger.minor(this, "Adding requested from: " + requestedFrom + " at " + now);
        }
        this.sentTime = now;
        boolean includedAlready = false;
        int nulls = 0;
        int ret = -1;
        for (int i2 = 0; i2 < this.requestedNodes.length; ++i2) {
            PeerNodeUnlocked got;
            PeerNodeUnlocked peerNodeUnlocked = got = this.requestedNodes[i2] == null ? null : (PeerNodeUnlocked)this.requestedNodes[i2].get();
            if (got == requestedFrom && (this.requestedTimeoutsRF[i2] == -1L || this.requestedTimeoutsFT[i2] == -1L || this.requestedTimeoutHTLs[i2] == htl)) {
                includedAlready = true;
                this.requestedLocs[i2] = requestedFrom.getLocation();
                this.requestedBootIDs[i2] = requestedFrom.getBootID();
                this.requestedTimes[i2] = now;
                ret = i2;
            } else if (got != null && (got.getBootID() != this.requestedBootIDs[i2] || now - this.requestedTimes[i2] > MAX_TIME_BETWEEN_REQUEST_AND_OFFER)) {
                this.requestedNodes[i2] = null;
                got = null;
            }
            if (got != null) continue;
            ++nulls;
        }
        if (includedAlready && nulls == 0) {
            return ret;
        }
        int n = notIncluded = includedAlready ? 0 : 1;
        if (nulls == 1 && !includedAlready) {
            for (int i3 = 0; i3 < this.requestedNodes.length; ++i3) {
                if (this.requestedNodes[i3] != null && this.requestedNodes[i3].get() != null) continue;
                this.requestedNodes[i3] = requestedFrom.getWeakRef();
                this.requestedLocs[i3] = requestedFrom.getLocation();
                this.requestedBootIDs[i3] = requestedFrom.getBootID();
                this.requestedTimes[i3] = now;
                this.requestedTimeoutsRF[i3] = -1L;
                this.requestedTimeoutsFT[i3] = -1L;
                this.requestedTimeoutHTLs[i3] = -1;
                return i3;
            }
        }
        WeakReference[] newRequestedNodes = new WeakReference[this.requestedNodes.length + notIncluded - nulls];
        double[] newRequestedLocs = new double[this.requestedNodes.length + notIncluded - nulls];
        long[] newRequestedBootIDs = new long[this.requestedNodes.length + notIncluded - nulls];
        long[] newRequestedTimes = new long[this.requestedNodes.length + notIncluded - nulls];
        long[] newRequestedTimeoutsFT = new long[this.requestedNodes.length + notIncluded - nulls];
        long[] newRequestedTimeoutsRF = new long[this.requestedNodes.length + notIncluded - nulls];
        short[] newRequestedTimeoutHTLs = new short[this.requestedNodes.length + notIncluded - nulls];
        int toIndex = 0;
        for (i = 0; i < this.requestedNodes.length; ++i) {
            PeerNodeUnlocked pn;
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestedNodes[i];
            PeerNodeUnlocked peerNodeUnlocked = pn = ref == null ? null : (PeerNodeUnlocked)ref.get();
            if (pn == null) continue;
            if (pn == requestedFrom) {
                ret = toIndex;
            }
            newRequestedNodes[toIndex] = this.requestedNodes[i];
            newRequestedTimes[toIndex] = this.requestedTimes[i];
            newRequestedBootIDs[toIndex] = this.requestedBootIDs[i];
            newRequestedLocs[toIndex] = this.requestedLocs[i];
            newRequestedTimeoutsFT[toIndex] = this.requestedTimeoutsFT[i];
            newRequestedTimeoutsRF[toIndex] = this.requestedTimeoutsRF[i];
            newRequestedTimeoutHTLs[toIndex] = this.requestedTimeoutHTLs[i];
            ++toIndex;
        }
        if (!includedAlready) {
            ret = toIndex;
            newRequestedNodes[toIndex] = requestedFrom.getWeakRef();
            newRequestedTimes[toIndex] = now;
            newRequestedBootIDs[toIndex] = requestedFrom.getBootID();
            newRequestedLocs[toIndex] = requestedFrom.getLocation();
            newRequestedTimeoutsFT[toIndex] = -1L;
            newRequestedTimeoutsRF[toIndex] = -1L;
            newRequestedTimeoutHTLs[toIndex] = -1;
            ret = toIndex++;
        }
        for (i = toIndex; i < newRequestedNodes.length; ++i) {
            newRequestedNodes[i] = null;
        }
        if (toIndex > newRequestedNodes.length + 2) {
            newRequestedNodes = Arrays.copyOf(newRequestedNodes, toIndex);
            newRequestedLocs = Arrays.copyOf(newRequestedLocs, toIndex);
            newRequestedBootIDs = Arrays.copyOf(newRequestedBootIDs, toIndex);
            newRequestedTimes = Arrays.copyOf(newRequestedTimes, toIndex);
            newRequestedTimeoutsRF = Arrays.copyOf(newRequestedTimeoutsRF, toIndex);
            newRequestedTimeoutsFT = Arrays.copyOf(newRequestedTimeoutsFT, toIndex);
            newRequestedTimeoutHTLs = Arrays.copyOf(newRequestedTimeoutHTLs, toIndex);
        }
        this.requestedNodes = newRequestedNodes;
        this.requestedLocs = newRequestedLocs;
        this.requestedBootIDs = newRequestedBootIDs;
        this.requestedTimes = newRequestedTimes;
        this.requestedTimeoutsRF = newRequestedTimeoutsRF;
        this.requestedTimeoutsFT = newRequestedTimeoutsFT;
        this.requestedTimeoutHTLs = newRequestedTimeoutHTLs;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer() {
        HashSet<PeerNodeUnlocked> set = new HashSet<PeerNodeUnlocked>();
        boolean logMINOR = FailureTableEntry.logMINOR;
        if (logMINOR) {
            Logger.minor(this, "Sending offers to nodes which requested the key from us: (" + this.requestorNodes.length + ") for " + this.key);
        }
        FailureTableEntry failureTableEntry = this;
        synchronized (failureTableEntry) {
            PeerNodeUnlocked pn;
            WeakReference<? extends PeerNodeUnlocked> ref;
            int i;
            for (i = 0; i < this.requestorNodes.length; ++i) {
                ref = this.requestorNodes[i];
                if (ref == null || (pn = (PeerNodeUnlocked)ref.get()) == null || pn.getBootID() != this.requestorBootIDs[i] || set.add(pn)) continue;
                Logger.error(this, "Node is in requestorNodes twice: " + pn);
            }
            if (logMINOR) {
                Logger.minor(this, "Sending offers to nodes which we sent the key to: (" + this.requestedNodes.length + ") for " + this.key);
            }
            for (i = 0; i < this.requestedNodes.length; ++i) {
                ref = this.requestedNodes[i];
                if (ref != null && (pn = (PeerNodeUnlocked)ref.get()) != null && pn.getBootID() == this.requestedBootIDs[i] && set.add(pn)) continue;
            }
        }
        for (PeerNodeUnlocked pn : set) {
            if (logMINOR) {
                Logger.minor(this, "Offering to " + pn);
            }
            pn.offer(this.key);
        }
    }

    public synchronized boolean othersWant(PeerNodeUnlocked peer) {
        boolean anyValid = false;
        for (int i = 0; i < this.requestorNodes.length; ++i) {
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestorNodes[i];
            if (ref == null) continue;
            PeerNodeUnlocked pn = (PeerNodeUnlocked)ref.get();
            if (pn == null) {
                this.requestorNodes[i] = null;
                continue;
            }
            long bootID = pn.getBootID();
            if (bootID != this.requestorBootIDs[i]) {
                this.requestorNodes[i] = null;
                continue;
            }
            anyValid = true;
        }
        if (!anyValid) {
            this.requestorNodes = EMPTY_WEAK_REFERENCE;
            this.requestorBootIDs = EMPTY_LONG_ARRAY;
            this.requestorTimes = EMPTY_LONG_ARRAY;
            this.requestorHTLs = EMPTY_SHORT_ARRAY;
        }
        return anyValid;
    }

    public synchronized boolean askedByPeer(PeerNodeUnlocked peer, long now) {
        boolean anyValid = false;
        boolean ret = false;
        for (int i = 0; i < this.requestorNodes.length; ++i) {
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestorNodes[i];
            if (ref == null) continue;
            PeerNodeUnlocked pn = (PeerNodeUnlocked)ref.get();
            if (pn == null) {
                this.requestorNodes[i] = null;
                continue;
            }
            long bootID = pn.getBootID();
            if (bootID != this.requestorBootIDs[i]) {
                this.requestorNodes[i] = null;
                continue;
            }
            if (now - this.requestorTimes[i] >= MAX_TIME_BETWEEN_REQUEST_AND_OFFER) continue;
            if (pn == peer) {
                ret = true;
            }
            anyValid = true;
        }
        if (!anyValid) {
            this.requestorNodes = EMPTY_WEAK_REFERENCE;
            this.requestorBootIDs = EMPTY_LONG_ARRAY;
            this.requestorTimes = EMPTY_LONG_ARRAY;
            this.requestorHTLs = EMPTY_SHORT_ARRAY;
        }
        return ret;
    }

    public synchronized boolean askedFromPeer(PeerNodeUnlocked peer, long now) {
        boolean anyValid = false;
        boolean ret = false;
        for (int i = 0; i < this.requestedNodes.length; ++i) {
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestedNodes[i];
            if (ref == null) continue;
            PeerNodeUnlocked pn = (PeerNodeUnlocked)ref.get();
            if (pn == null) {
                this.requestedNodes[i] = null;
                continue;
            }
            long bootID = pn.getBootID();
            if (bootID != this.requestedBootIDs[i]) {
                this.requestedNodes[i] = null;
                continue;
            }
            anyValid = true;
            if (now - this.requestedTimes[i] >= MAX_TIME_BETWEEN_REQUEST_AND_OFFER) continue;
            if (pn == peer) {
                ret = true;
            }
            anyValid = true;
        }
        if (!anyValid) {
            this.requestedNodes = EMPTY_WEAK_REFERENCE;
            this.requestedTimeoutsFT = EMPTY_LONG_ARRAY;
            this.requestedTimeoutsRF = EMPTY_LONG_ARRAY;
            this.requestedBootIDs = this.requestedTimeoutsRF;
            this.requestedTimes = this.requestedTimeoutsRF;
            this.requestedTimeoutHTLs = EMPTY_SHORT_ARRAY;
        }
        return ret;
    }

    public synchronized boolean isEmpty(long now) {
        if (this.requestedNodes.length > 0) {
            return false;
        }
        return this.requestorNodes.length <= 0;
    }

    @Override
    public synchronized long getTimeoutTime(PeerNode peer, short htl, long now, boolean forPerNodeFailureTables) {
        long timeout = -1L;
        for (int i = 0; i < this.requestedNodes.length; ++i) {
            long thisTimeout;
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestedNodes[i];
            if (ref == null || ref.get() != peer || this.requestedTimeoutHTLs[i] < htl) continue;
            long l = thisTimeout = forPerNodeFailureTables ? this.requestedTimeoutsFT[i] : this.requestedTimeoutsRF[i];
            if (thisTimeout <= timeout || thisTimeout <= now) continue;
            timeout = thisTimeout;
        }
        return timeout;
    }

    public synchronized boolean cleanup() {
        long now = System.currentTimeMillis();
        boolean empty = this.cleanupRequestor(now);
        return empty &= this.cleanupRequested(now);
    }

    private boolean cleanupRequestor(long now) {
        boolean empty = true;
        int x = 0;
        for (int i = 0; i < this.requestorNodes.length; ++i) {
            long bootID;
            PeerNodeUnlocked pn;
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestorNodes[i];
            if (ref == null || (pn = (PeerNodeUnlocked)ref.get()) == null || (bootID = pn.getBootID()) != this.requestorBootIDs[i] || !pn.isConnected() || now - this.requestorTimes[i] > MAX_TIME_BETWEEN_REQUEST_AND_OFFER) continue;
            empty = false;
            this.requestorNodes[x] = this.requestorNodes[i];
            this.requestorTimes[x] = this.requestorTimes[i];
            this.requestorBootIDs[x] = this.requestorBootIDs[i];
            this.requestorHTLs[x] = this.requestorHTLs[i];
            ++x;
        }
        if (x < this.requestorNodes.length) {
            this.requestorNodes = Arrays.copyOf(this.requestorNodes, x);
            this.requestorTimes = Arrays.copyOf(this.requestorTimes, x);
            this.requestorBootIDs = Arrays.copyOf(this.requestorBootIDs, x);
            this.requestorHTLs = Arrays.copyOf(this.requestorHTLs, x);
        }
        return empty;
    }

    private boolean cleanupRequested(long now) {
        boolean empty = true;
        int x = 0;
        for (int i = 0; i < this.requestedNodes.length; ++i) {
            long bootID;
            PeerNodeUnlocked pn;
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestedNodes[i];
            if (ref == null || (pn = (PeerNodeUnlocked)ref.get()) == null || (bootID = pn.getBootID()) != this.requestedBootIDs[i] || !pn.isConnected() || now - this.requestedTimes[i] > MAX_TIME_BETWEEN_REQUEST_AND_OFFER) continue;
            empty = false;
            this.requestedNodes[x] = this.requestedNodes[i];
            this.requestedTimes[x] = this.requestedTimes[i];
            this.requestedBootIDs[x] = this.requestedBootIDs[i];
            this.requestedLocs[x] = this.requestedLocs[i];
            if (now < this.requestedTimeoutsRF[x] || now < this.requestedTimeoutsFT[x]) {
                this.requestedTimeoutsRF[x] = this.requestedTimeoutsRF[i];
                this.requestedTimeoutsFT[x] = this.requestedTimeoutsFT[i];
                this.requestedTimeoutHTLs[x] = this.requestedTimeoutHTLs[i];
            } else {
                this.requestedTimeoutsRF[x] = -1L;
                this.requestedTimeoutsFT[x] = -1L;
                this.requestedTimeoutHTLs[x] = -1;
            }
            ++x;
        }
        if (x < this.requestedNodes.length) {
            this.requestedNodes = Arrays.copyOf(this.requestedNodes, x);
            this.requestedTimes = Arrays.copyOf(this.requestedTimes, x);
            this.requestedBootIDs = Arrays.copyOf(this.requestedBootIDs, x);
            this.requestedLocs = Arrays.copyOf(this.requestedLocs, x);
            this.requestedTimeoutsRF = Arrays.copyOf(this.requestedTimeoutsRF, x);
            this.requestedTimeoutsFT = Arrays.copyOf(this.requestedTimeoutsFT, x);
            this.requestedTimeoutHTLs = Arrays.copyOf(this.requestedTimeoutHTLs, x);
        }
        return empty;
    }

    public boolean isEmpty() {
        return this.isEmpty(System.currentTimeMillis());
    }

    public synchronized short minRequestorHTL(short htl) {
        long now = System.currentTimeMillis();
        boolean anyValid = false;
        for (int i = 0; i < this.requestorNodes.length; ++i) {
            WeakReference<? extends PeerNodeUnlocked> ref = this.requestorNodes[i];
            if (ref == null) continue;
            PeerNodeUnlocked pn = (PeerNodeUnlocked)ref.get();
            if (pn == null) {
                this.requestorNodes[i] = null;
                continue;
            }
            long bootID = pn.getBootID();
            if (bootID != this.requestorBootIDs[i]) {
                this.requestorNodes[i] = null;
                continue;
            }
            if (now - this.requestorTimes[i] < MAX_TIME_BETWEEN_REQUEST_AND_OFFER && this.requestorHTLs[i] < htl) {
                htl = this.requestorHTLs[i];
            }
            anyValid = true;
        }
        if (!anyValid) {
            this.requestorNodes = EMPTY_WEAK_REFERENCE;
            this.requestorBootIDs = EMPTY_LONG_ARRAY;
            this.requestorTimes = EMPTY_LONG_ARRAY;
            this.requestorHTLs = EMPTY_SHORT_ARRAY;
        }
        return htl;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        MAX_TIME_BETWEEN_REQUEST_AND_OFFER = TimeUnit.HOURS.toMillis(1L);
        EMPTY_LONG_ARRAY = new long[0];
        EMPTY_SHORT_ARRAY = new short[0];
        EMPTY_DOUBLE_ARRAY = new double[0];
        EMPTY_WEAK_REFERENCE = new WeakReference[0];
    }
}

