/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.client.ClientMetadata;
import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.simulator.TestUtil;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.TimeUtil;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BootstrapPushPullTest {
    public static int TEST_SIZE = 0x100000;
    public static int EXIT_NO_SEEDNODES = 257;
    public static int EXIT_FAILED_TARGET = 258;
    public static int EXIT_INSERT_FAILED = 259;
    public static int EXIT_FETCH_FAILED = 260;
    public static int EXIT_THREW_SOMETHING = 261;
    public static int DARKNET_PORT1 = 5002;
    public static int OPENNET_PORT1 = 5003;
    public static int DARKNET_PORT2 = 5004;
    public static int OPENNET_PORT2 = 5005;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws LoggerHook.InvalidThresholdException, IOException, NodeInitException, InterruptedException {
        Node node = null;
        Node secondNode = null;
        try {
            FreenetURI uri;
            String ipOverride = null;
            if (args.length > 0) {
                ipOverride = args[0];
            }
            File dir = new File("bootstrap-push-pull-test");
            FileUtil.removeAll(dir);
            RandomSource random = NodeStarter.globalTestInit(dir.getPath(), false, Logger.LogLevel.NORMAL, "", false);
            File seednodes = new File("seednodes.fref");
            if (!seednodes.exists() || seednodes.length() == 0L || !seednodes.canRead()) {
                System.err.println("Unable to read seednodes.fref, it doesn't exist, or is empty");
                System.exit(EXIT_NO_SEEDNODES);
            }
            File innerDir = new File(dir, Integer.toString(DARKNET_PORT1));
            innerDir.mkdir();
            FileInputStream fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(innerDir, "seednodes.fref"));
            fis.close();
            PooledExecutor executor = new PooledExecutor();
            node = NodeStarter.createTestNode(DARKNET_PORT1, OPENNET_PORT1, dir.getPath(), false, (short)18, 0, random, executor, 1000, 0x500000L, true, true, true, true, true, true, true, 12288, false, true, false, false, ipOverride);
            Logger.getChain().setThreshold(Logger.LogLevel.ERROR);
            node.start(true);
            if (!TestUtil.waitForNodes(node)) {
                node.park();
                System.exit(EXIT_FAILED_TARGET);
            }
            System.err.println("Creating test data: " + TEST_SIZE + " bytes.");
            RandomAccessBucket data = node.getClientCore().getTempBucketFactory().makeBucket(TEST_SIZE);
            try (OutputStream os = data.getOutputStream();){
                int toWrite;
                byte[] buf = new byte[4096];
                for (long written = 0L; written < (long)TEST_SIZE; written += (long)toWrite) {
                    node.getFastWeakRandom().nextBytes(buf);
                    toWrite = (int)Math.min((long)TEST_SIZE - written, (long)buf.length);
                    os.write(buf, 0, toWrite);
                }
            }
            System.err.println("Inserting test data.");
            HighLevelSimpleClient client = node.getClientCore().makeClient((short)0, false, false);
            InsertBlock block = new InsertBlock(data, new ClientMetadata(), FreenetURI.EMPTY_CHK_URI);
            long startInsertTime = System.currentTimeMillis();
            try {
                uri = client.insert(block, false, null);
            }
            catch (InsertException e) {
                System.err.println("INSERT FAILED: " + e);
                e.printStackTrace();
                System.exit(EXIT_INSERT_FAILED);
                return;
            }
            long endInsertTime = System.currentTimeMillis();
            System.err.println("RESULT: Insert took " + (endInsertTime - startInsertTime) + "ms (" + TimeUtil.formatTime(endInsertTime - startInsertTime) + ") to " + uri + " .");
            node.park();
            File secondInnerDir = new File(dir, Integer.toString(DARKNET_PORT2));
            secondInnerDir.mkdir();
            fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(secondInnerDir, "seednodes.fref"));
            fis.close();
            executor = new PooledExecutor();
            secondNode = NodeStarter.createTestNode(DARKNET_PORT2, OPENNET_PORT2, dir.getPath(), false, (short)18, 0, random, executor, 1000, 0x500000L, true, true, true, true, true, true, true, 12288, false, true, false, false, ipOverride);
            secondNode.start(true);
            if (!TestUtil.waitForNodes(secondNode)) {
                secondNode.park();
                System.exit(EXIT_FAILED_TARGET);
            }
            long startFetchTime = System.currentTimeMillis();
            client = secondNode.getClientCore().makeClient((short)0, false, false);
            try {
                client.fetch(uri);
            }
            catch (FetchException e) {
                System.err.println("FETCH FAILED: " + e);
                e.printStackTrace();
                System.exit(EXIT_FETCH_FAILED);
                return;
            }
            long endFetchTime = System.currentTimeMillis();
            System.err.println("RESULT: Fetch took " + (endFetchTime - startFetchTime) + "ms (" + TimeUtil.formatTime(endFetchTime - startFetchTime) + ") of " + uri + " .");
            secondNode.park();
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("CAUGHT: " + t);
            t.printStackTrace();
            try {
                if (node != null) {
                    node.park();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (secondNode != null) {
                    secondNode.park();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(EXIT_THREW_SOMETHING);
        }
    }
}

