/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    public static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");
    private static final Pattern TIME_INTERVAL_PATTERN = Pattern.compile("-?(?:(\\d+)w)?(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)([.]\\d+)?s)?");

    public static String formatTime(long timeInterval, int maxTerms, boolean withSecondFractions) {
        if (maxTerms > 6) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(64);
        long l = timeInterval;
        int termCount = 0;
        if (l < 0L) {
            sb.append('-');
            l *= -1L;
        }
        if (!withSecondFractions && l < 1000L) {
            return "0s";
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long weeks = TimeUnit.DAYS.convert(l, TimeUnit.MILLISECONDS) / 7L;
        if (weeks > 0L) {
            sb.append(weeks).append('w');
            ++termCount;
            l -= TimeUnit.DAYS.toMillis(7L * weeks);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long days = TimeUnit.DAYS.convert(l, TimeUnit.MILLISECONDS);
        if (days > 0L) {
            sb.append(days).append('d');
            ++termCount;
            l -= TimeUnit.DAYS.toMillis(days);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long hours = TimeUnit.HOURS.convert(l, TimeUnit.MILLISECONDS);
        if (hours > 0L) {
            sb.append(hours).append('h');
            ++termCount;
            l -= TimeUnit.HOURS.toMillis(hours);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long minutes = TimeUnit.MINUTES.convert(l, TimeUnit.MILLISECONDS);
        if (minutes > 0L) {
            sb.append(minutes).append('m');
            ++termCount;
            l -= TimeUnit.MINUTES.toMillis(minutes);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        if (withSecondFractions && maxTerms - termCount >= 2) {
            if (l > 0L) {
                double fractionalSeconds = (double)l / 1000.0;
                sb.append(String.format(Locale.ROOT, "%.3f", fractionalSeconds)).append('s');
            }
        } else {
            long seconds = TimeUnit.SECONDS.convert(l, TimeUnit.MILLISECONDS);
            if (seconds > 0L) {
                sb.append(seconds).append('s');
            }
        }
        return sb.toString();
    }

    public static String formatTime(long timeInterval) {
        return TimeUtil.formatTime(timeInterval, 2, false);
    }

    public static String formatTime(long timeInterval, int maxTerms) {
        return TimeUtil.formatTime(timeInterval, maxTerms, false);
    }

    public static long toMillis(String timeInterval) {
        Matcher matcher = TIME_INTERVAL_PATTERN.matcher(timeInterval);
        if (!matcher.matches()) {
            throw new NumberFormatException("Unknown format: " + timeInterval);
        }
        long millis = 0L;
        String group = matcher.group(1);
        if (group != null) {
            millis += TimeUnit.DAYS.toMillis(7L * Long.parseLong(group));
        }
        if ((group = matcher.group(2)) != null) {
            millis += TimeUnit.DAYS.toMillis(Long.parseLong(group));
        }
        if ((group = matcher.group(3)) != null) {
            millis += TimeUnit.HOURS.toMillis(Long.parseLong(group));
        }
        if ((group = matcher.group(4)) != null) {
            millis += TimeUnit.MINUTES.toMillis(Long.parseLong(group));
        }
        if ((group = matcher.group(5)) != null) {
            millis += TimeUnit.SECONDS.toMillis(Long.parseLong(group));
        }
        if ((group = matcher.group(6)) != null) {
            millis += (long)(Double.parseDouble(group) * 1000.0);
        }
        return timeInterval.startsWith("-") ? -millis : millis;
    }

    public static String makeHTTPDate(long time) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(time).atOffset(ZoneOffset.UTC));
    }

    public static Date setTimeToZero(Date date) {
        return Date.from(date.toInstant().truncatedTo(ChronoUnit.DAYS));
    }
}

