/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.api.RandomAccessBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class RAFInputStream
extends InputStream {
    private final RandomAccessBuffer underlying;
    private final long rafLength;
    private long rafOffset;

    public RAFInputStream(RandomAccessBuffer data, long offset, long size) {
        this.underlying = data;
        this.rafOffset = offset;
        this.rafLength = size;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int length = this.read(buf, 0, 1);
        if (length > 0) {
            return Byte.toUnsignedInt(buf[0]);
        }
        return -1;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this.rafOffset >= this.rafLength) {
            throw new EOFException();
        }
        length = (int)Math.min((long)length, this.rafLength - this.rafOffset);
        this.underlying.pread(this.rafOffset, buf, offset, length);
        this.rafOffset += (long)length;
        return length;
    }
}

