/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SkipShieldingInputStream
extends FilterInputStream {
    private static final int SKIP_BUFFER_MAX_BYTES = 16384;

    public SkipShieldingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public long skip(long n) throws IOException {
        int nr;
        long remaining = n;
        if (remaining <= 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)Math.min(16384L, n)];
        while (remaining > 0L && (nr = this.read(buffer, 0, (int)Math.min((long)buffer.length, remaining))) >= 0) {
            remaining -= (long)nr;
        }
        return n - remaining;
    }
}

