/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.RecoveryUtilizationTracker;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NodeLogEntry;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.FileMapper;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INFileReader
extends FileReader {
    private boolean lastEntryWasDelete;
    private boolean lastEntryWasDupDelete;
    private LogEntryType fromLogType;
    private boolean isProvisional;
    private Map<LogEntryType, LogEntry> targetEntryMap;
    private LogEntry targetLogEntry;
    private Map<LogEntryType, LogEntry> dbIdTrackingMap;
    private LNLogEntry dbIdTrackingEntry;
    private Map<LogEntryType, LogEntry> txnIdTrackingMap;
    private LNLogEntry txnIdTrackingEntry;
    private Map<LogEntryType, NodeLogEntry> otherNodeTrackingMap;
    private NodeLogEntry nodeTrackingEntry;
    private INLogEntry inTrackingEntry;
    private LNLogEntry fsTrackingEntry;
    private boolean trackIds;
    private long minReplicatedNodeId;
    private long maxNodeId;
    private int minReplicatedDbId;
    private int maxDbId;
    private long minReplicatedTxnId;
    private long maxTxnId;
    private boolean mapDbOnly;
    private long ckptEnd;
    private long partialCkptStart;
    private RecoveryUtilizationTracker tracker;
    private Map<Long, FileMapper> fileMappers;

    public INFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, boolean trackIds, boolean mapDbOnly, long partialCkptStart, long ckptEnd, RecoveryUtilizationTracker tracker) throws IOException, DatabaseException {
        super(env, readBufferSize, true, startLsn, null, -1L, finishLsn);
        this.trackIds = trackIds;
        this.mapDbOnly = mapDbOnly;
        this.ckptEnd = ckptEnd;
        this.targetEntryMap = new HashMap<LogEntryType, LogEntry>();
        if (trackIds) {
            this.maxNodeId = 0L;
            this.maxDbId = 0;
            this.maxTxnId = 0L;
            this.minReplicatedNodeId = 0L;
            this.minReplicatedDbId = -256;
            this.minReplicatedTxnId = 0L;
            this.tracker = tracker;
            this.partialCkptStart = partialCkptStart;
            this.dbIdTrackingMap = new HashMap<LogEntryType, LogEntry>();
            this.txnIdTrackingMap = new HashMap<LogEntryType, LogEntry>();
            this.otherNodeTrackingMap = new HashMap<LogEntryType, NodeLogEntry>();
            this.dbIdTrackingMap.put(LogEntryType.LOG_MAPLN_TRANSACTIONAL, LogEntryType.LOG_MAPLN_TRANSACTIONAL.getNewLogEntry());
            this.dbIdTrackingMap.put(LogEntryType.LOG_MAPLN, LogEntryType.LOG_MAPLN.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_LN_TRANSACTIONAL, LogEntryType.LOG_LN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_MAPLN_TRANSACTIONAL, LogEntryType.LOG_MAPLN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_NAMELN_TRANSACTIONAL, LogEntryType.LOG_NAMELN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL, LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL, LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL.getNewLogEntry());
            this.fileMappers = new HashMap<Long, FileMapper>();
        }
    }

    public void addTargetType(LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, entryType.getNewLogEntry());
    }

    @Override
    protected boolean isTargetEntry() throws DatabaseException {
        this.lastEntryWasDelete = false;
        this.lastEntryWasDupDelete = false;
        this.targetLogEntry = null;
        this.dbIdTrackingEntry = null;
        this.txnIdTrackingEntry = null;
        this.nodeTrackingEntry = null;
        this.inTrackingEntry = null;
        this.fsTrackingEntry = null;
        this.isProvisional = this.currentEntryHeader.getProvisional().isProvisional(this.getLastLsn(), this.ckptEnd);
        this.fromLogType = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry possibleTarget = this.targetEntryMap.get(this.fromLogType);
        if (!this.isProvisional) {
            this.targetLogEntry = possibleTarget;
        }
        if (LogEntryType.LOG_IN_DELETE_INFO.equals(this.fromLogType)) {
            this.lastEntryWasDelete = true;
        }
        if (LogEntryType.LOG_IN_DUPDELETE_INFO.equals(this.fromLogType)) {
            this.lastEntryWasDupDelete = true;
        }
        if (this.trackIds) {
            if (!this.isProvisional) {
                this.dbIdTrackingEntry = (LNLogEntry)this.dbIdTrackingMap.get(this.fromLogType);
                this.txnIdTrackingEntry = (LNLogEntry)this.txnIdTrackingMap.get(this.fromLogType);
            }
            if (this.fromLogType.isNodeType()) {
                if (possibleTarget != null) {
                    this.nodeTrackingEntry = (NodeLogEntry)possibleTarget;
                } else if (this.dbIdTrackingEntry != null) {
                    this.nodeTrackingEntry = this.dbIdTrackingEntry;
                } else if (this.txnIdTrackingEntry != null) {
                    this.nodeTrackingEntry = this.txnIdTrackingEntry;
                } else {
                    this.nodeTrackingEntry = this.otherNodeTrackingMap.get(this.fromLogType);
                    if (this.nodeTrackingEntry == null) {
                        this.nodeTrackingEntry = (NodeLogEntry)this.fromLogType.getNewLogEntry();
                        this.otherNodeTrackingMap.put(this.fromLogType, this.nodeTrackingEntry);
                    }
                }
                if (this.nodeTrackingEntry instanceof INLogEntry) {
                    this.inTrackingEntry = (INLogEntry)this.nodeTrackingEntry;
                }
                if (LogEntryType.LOG_FILESUMMARYLN.equals(this.fromLogType)) {
                    this.fsTrackingEntry = (LNLogEntry)this.nodeTrackingEntry;
                }
            } else {
                if (!LogEntryType.LOG_FILE_HEADER.equals(this.fromLogType)) {
                    this.tracker.countNewLogEntry(this.getLastLsn(), this.fromLogType, this.currentEntryHeader.getSize() + this.currentEntryHeader.getItemSize(), null);
                }
                if (LogEntryType.LOG_ROOT.equals(this.fromLogType)) {
                    this.tracker.saveLastLoggedMapLN(DbTree.ID_DB_ID, this.getLastLsn());
                    this.tracker.saveLastLoggedMapLN(DbTree.NAME_DB_ID, this.getLastLsn());
                    this.tracker.resetDbInfo(DbTree.ID_DB_ID);
                    this.tracker.resetDbInfo(DbTree.NAME_DB_ID);
                }
            }
            return this.targetLogEntry != null || this.dbIdTrackingEntry != null || this.txnIdTrackingEntry != null || this.nodeTrackingEntry != null || this.currentEntryHeader.getReplicated();
        }
        return this.targetLogEntry != null;
    }

    private void trackVLSNMappings() {
        if (this.currentEntryHeader.getReplicated()) {
            VLSN vlsn = this.currentEntryHeader.getVLSN();
            long lsn = this.getLastLsn();
            long fileNumber = DbLsn.getFileNumber(lsn);
            FileMapper mapper = this.fileMappers.get(fileNumber);
            if (mapper == null) {
                mapper = new FileMapper(fileNumber);
                this.fileMappers.put(fileNumber, mapper);
            }
            mapper.putLSN(vlsn.getSequence(), lsn, LogEntryType.findType(this.currentEntryHeader.getType()));
        }
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        boolean useEntry = false;
        boolean entryLoaded = false;
        if (this.targetLogEntry != null) {
            this.targetLogEntry.readEntry(this.currentEntryHeader, entryBuffer, true);
            entryLoaded = true;
            DatabaseId dbId = this.getDatabaseId();
            boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
            boolean bl = useEntry = !this.mapDbOnly || isMapDb;
        }
        if (this.trackIds) {
            DatabaseId dbIdToReset = null;
            long fileNumToReset = -1L;
            LNLogEntry lnEntry = null;
            if (this.dbIdTrackingEntry != null) {
                lnEntry = this.dbIdTrackingEntry;
                lnEntry.readEntry(this.currentEntryHeader, entryBuffer, true);
                entryLoaded = true;
                MapLN mapLN = (MapLN)lnEntry.getMainItem();
                DatabaseId dbId = mapLN.getDatabase().getId();
                int dbIdVal = dbId.getId();
                this.maxDbId = dbIdVal > this.maxDbId ? dbIdVal : this.maxDbId;
                this.minReplicatedDbId = dbIdVal < this.minReplicatedDbId ? dbIdVal : this.minReplicatedDbId;
                dbIdToReset = dbId;
                this.tracker.saveLastLoggedMapLN(dbId, this.getLastLsn());
            }
            if (this.txnIdTrackingEntry != null) {
                long txnId;
                if (lnEntry == null) {
                    lnEntry = this.txnIdTrackingEntry;
                    lnEntry.readEntry(this.currentEntryHeader, entryBuffer, false);
                    entryLoaded = true;
                }
                this.maxTxnId = (txnId = lnEntry.getTxnId().longValue()) > this.maxTxnId ? txnId : this.maxTxnId;
                long l = this.minReplicatedTxnId = txnId < this.minReplicatedTxnId ? txnId : this.minReplicatedTxnId;
            }
            if (this.fsTrackingEntry != null) {
                long fileNum;
                if (!entryLoaded) {
                    this.nodeTrackingEntry.readEntry(this.currentEntryHeader, entryBuffer, true);
                    entryLoaded = true;
                }
                byte[] keyBytes = this.fsTrackingEntry.getKey();
                FileSummaryLN fsln = (FileSummaryLN)this.fsTrackingEntry.getMainItem();
                fileNumToReset = fileNum = fsln.getFileNumber(keyBytes);
                this.tracker.saveLastLoggedFileSummaryLN(fileNum, this.getLastLsn());
            }
            if (this.nodeTrackingEntry != null) {
                long nodeId;
                if (!entryLoaded) {
                    this.nodeTrackingEntry.readEntry(this.currentEntryHeader, entryBuffer, false);
                    entryLoaded = true;
                }
                this.maxNodeId = (nodeId = this.nodeTrackingEntry.getNodeId()) > this.maxNodeId ? nodeId : this.maxNodeId;
                this.minReplicatedNodeId = nodeId < this.minReplicatedNodeId ? nodeId : this.minReplicatedNodeId;
                this.tracker.countNewLogEntry(this.getLastLsn(), this.fromLogType, this.currentEntryHeader.getSize() + this.currentEntryHeader.getItemSize(), this.nodeTrackingEntry.getDbId());
            }
            if (this.inTrackingEntry != null) {
                assert (entryLoaded) : "All nodes should have been loaded";
                long oldLsn = this.inTrackingEntry.getObsoleteLsn();
                if (oldLsn != -1L) {
                    long newLsn = this.getLastLsn();
                    this.tracker.countObsoleteIfUncounted(oldLsn, newLsn, this.fromLogType, 0, this.inTrackingEntry.getDbId(), false);
                }
                if (this.isProvisional && this.partialCkptStart != -1L && DbLsn.compareTo(this.partialCkptStart, oldLsn = this.getLastLsn()) < 0) {
                    this.tracker.countObsoleteUnconditional(oldLsn, this.fromLogType, 0, this.inTrackingEntry.getDbId(), false);
                }
            }
            if (fileNumToReset != -1L) {
                this.tracker.resetFileInfo(fileNumToReset);
            }
            if (dbIdToReset != null) {
                this.tracker.resetDbInfo(dbIdToReset);
            }
            this.trackVLSNMappings();
            if (!entryLoaded) {
                int endPosition = this.threadSafeBufferPosition(entryBuffer) + this.currentEntryHeader.getItemSize();
                this.threadSafeBufferPosition(entryBuffer, endPosition);
            }
        }
        return useEntry;
    }

    public IN getIN() throws DatabaseException {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getIN(this.envImpl);
    }

    public DatabaseId getDatabaseId() {
        if (this.lastEntryWasDelete) {
            return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDatabaseId();
        }
        if (this.lastEntryWasDupDelete) {
            return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDatabaseId();
        }
        return ((INContainingEntry)((Object)this.targetLogEntry)).getDbId();
    }

    public long getMaxNodeId() {
        return this.maxNodeId;
    }

    public long getMinReplicatedNodeId() {
        return this.minReplicatedNodeId;
    }

    public int getMaxDbId() {
        return this.maxDbId;
    }

    public int getMinReplicatedDbId() {
        return this.minReplicatedDbId;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public long getMinReplicatedTxnId() {
        return this.minReplicatedTxnId;
    }

    public boolean isDeleteInfo() {
        return this.lastEntryWasDelete;
    }

    public boolean isDupDeleteInfo() {
        return this.lastEntryWasDupDelete;
    }

    public long getDeletedNodeId() {
        return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedNodeId();
    }

    public byte[] getDeletedIdKey() {
        return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedIdKey();
    }

    public long getDupDeletedNodeId() {
        return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedNodeId();
    }

    public byte[] getDupDeletedMainKey() {
        return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedMainKey();
    }

    public byte[] getDupDeletedDupKey() {
        return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedDupKey();
    }

    public long getLsnOfIN() {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getLsnOfIN(this.getLastLsn());
    }

    public Collection<FileMapper> getFileMappers() {
        return this.fileMappers.values();
    }
}

