/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.ForeignMultiKeyNullifier;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawObject;
import java.util.Collection;
import java.util.Set;

public class PersistKeyCreator
implements SecondaryKeyCreator,
SecondaryMultiKeyCreator,
ForeignMultiKeyNullifier {
    private Catalog catalog;
    private int priKeyFormatId;
    private String keyName;
    private Format keyFormat;
    private boolean toMany;

    static boolean isManyType(Class cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls);
    }

    public PersistKeyCreator(Catalog catalog, EntityMetadata entityMeta, String keyClassName, SecondaryKeyMetadata secKeyMeta) {
        this.catalog = catalog;
        Format priKeyFormat = catalog.getFormat(entityMeta.getPrimaryKey().getClassName());
        this.priKeyFormatId = priKeyFormat.getId();
        this.keyName = secKeyMeta.getKeyName();
        this.keyFormat = catalog.getFormat(keyClassName);
        if (this.keyFormat == null) {
            throw new IllegalArgumentException("Not a key class: " + keyClassName);
        }
        if (this.keyFormat.isPrimitive()) {
            throw new IllegalArgumentException("Use a primitive wrapper class instead of class: " + this.keyFormat.getClassName());
        }
        Relationship rel = secKeyMeta.getRelationship();
        this.toMany = rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY;
    }

    public boolean createSecondaryKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, DatabaseEntry result) throws DatabaseException {
        if (this.toMany) {
            throw new IllegalStateException();
        }
        KeyLocation loc = this.moveToKey(key, data);
        if (loc != null) {
            RecordOutput output = new RecordOutput(this.catalog, true);
            loc.format.copySecKey(loc.input, output);
            TupleBase.outputToEntry(output, result);
            return true;
        }
        return false;
    }

    public void createSecondaryKeys(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, Set results) throws DatabaseException {
        if (!this.toMany) {
            throw new IllegalStateException();
        }
        KeyLocation loc = this.moveToKey(key, data);
        if (loc != null) {
            loc.format.copySecMultiKey(loc.input, this.keyFormat, results);
        }
    }

    public boolean nullifyForeignKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, DatabaseEntry secKey) throws DatabaseException {
        RawObject entity = (RawObject)PersistEntityBinding.readEntity(this.catalog, key, data, true);
        Format entityFormat = (Format)entity.getType();
        Object secKeyObject = null;
        if (this.toMany) {
            secKeyObject = PersistKeyBinding.readKey(this.keyFormat, this.catalog, secKey.getData(), secKey.getOffset(), secKey.getSize(), true);
        }
        if (entityFormat.nullifySecKey(this.catalog, entity, this.keyName, secKeyObject)) {
            PersistEntityBinding.writeEntity(entityFormat, this.catalog, entity, data, true);
            return true;
        }
        return false;
    }

    private KeyLocation moveToKey(DatabaseEntry priKey, DatabaseEntry data) {
        RecordInput input = new RecordInput(this.catalog, true, priKey, this.priKeyFormatId, data.getData(), data.getOffset(), data.getSize());
        int formatId = input.readPackedInt();
        Format entityFormat = this.catalog.getFormat(formatId);
        Format fieldFormat = entityFormat.skipToSecKey(input, this.keyName);
        if (fieldFormat != null) {
            return input.getKeyLocation(fieldFormat);
        }
        return null;
    }
}

