/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import net.contrapunctus.lzma.ConcurrentBufferInputStream;
import net.contrapunctus.lzma.DecoderThread;

public class LzmaInputStream
extends FilterInputStream {
    protected DecoderThread dth;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    public LzmaInputStream(InputStream _in) {
        super(null);
        this.dth = new DecoderThread(_in);
        this.in = ConcurrentBufferInputStream.create(this.dth.q);
        if (DEBUG) {
            dbg.printf("%s << %s (%s)%n", this, this.in, this.dth.q);
        }
        this.dth.start();
    }

    @Override
    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        super.close();
    }

    public String toString() {
        return String.format("lzmaIn@%x", this.hashCode());
    }

    public static void main(String[] args) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.print("I will try decoding this text.");
        ps.close();
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        baos = new ByteArrayOutputStream();
        Encoder enc = new Encoder();
        enc.SetEndMarkerMode(true);
        enc.WriteCoderProperties(baos);
        enc.Code(bis, baos, -1L, -1L, null);
        buf = baos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        Decoder dec = new Decoder();
        byte[] props = new byte[5];
        bis.read(props, 0, 5);
        dec.SetDecoderProperties(props);
        dec.Code(bis, System.out, -1L);
        System.out.println();
        bis = new ByteArrayInputStream(buf);
        LzmaInputStream is = new LzmaInputStream(bis);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        System.out.println(br.readLine());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaStreams");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

