/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import SevenZip.Compression.LZMA.Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;
import net.contrapunctus.lzma.EncoderThread;

public class LzmaOutputStream
extends FilterOutputStream {
    protected EncoderThread eth;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    public LzmaOutputStream(OutputStream _out) {
        super(null);
        this.eth = new EncoderThread(_out);
        this.out = ConcurrentBufferOutputStream.create(this.eth.q);
        if (DEBUG) {
            dbg.printf("%s >> %s (%s)%n", this, this.out, this.eth.q);
        }
        this.eth.start();
    }

    @Override
    public void write(int i) throws IOException {
        if (this.eth.exn != null) {
            throw this.eth.exn;
        }
        this.out.write(i);
    }

    @Override
    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        this.out.close();
        try {
            this.eth.join();
            if (DEBUG) {
                dbg.printf("%s joined %s%n", this, this.eth);
            }
        }
        catch (InterruptedException exn) {
            throw new InterruptedIOException(exn.getMessage());
        }
        if (this.eth.exn != null) {
            throw this.eth.exn;
        }
    }

    public String toString() {
        return String.format("lzmaOut@%x", this.hashCode());
    }

    public static void main(String[] args) throws IOException {
        String s1 = "Hello hello hello, world!";
        String s2 = "This is the best test.";
        OutputStream os = new OutputStream(){

            @Override
            public void write(int i) {
                System.out.printf("%02x ", i);
            }
        };
        LzmaOutputStream zo = new LzmaOutputStream(os);
        PrintStream ps = new PrintStream(zo);
        ps.print(s1);
        ps.print(s2);
        ps.close();
        System.out.println();
        System.out.println("TRADITIONAL WAY:");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ps = new PrintStream(baos);
        ps.print(s1);
        ps.print(s2);
        ps.close();
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        baos = new ByteArrayOutputStream();
        Encoder enc = new Encoder();
        enc.SetEndMarkerMode(true);
        enc.SetDictionarySize(0x100000);
        enc.WriteCoderProperties(baos);
        enc.Code(bis, baos, -1L, -1L, null);
        buf = baos.toByteArray();
        for (int i = 0; i < buf.length; ++i) {
            System.out.printf("%02x ", buf[i]);
        }
        System.out.println();
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaStreams");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

