/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Id3Handler {
    private static final int SUPPORTED_VERSION_2_2 = 2;
    private static final int SUPPORTED_VERSION_2_3 = 3;
    private static final String[] genres = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "Acapella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary C", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "SynthPop"};

    private static void handleFramev23(String string, byte[] byArray, int n, int n2, Id3Info id3Info) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        if ("TIT2".equals(string)) {
            id3Info.title = new String(byArray, n, n2);
        } else if ("TALB".equals(string)) {
            id3Info.album = new String(byArray, n, n2);
        } else if ("TPE1".equals(string)) {
            id3Info.artist = new String(byArray, n, n2);
        } else if ("TYER".equals(string)) {
            id3Info.year = new String(byArray, n, n2);
        } else if ("TCON".equals(string)) {
            String string2 = new String(byArray, n, n2);
            for (int i = 0; i < genres.length; ++i) {
                if (!genres[i].equals(string2)) continue;
                id3Info.genre = Integer.toString(i);
            }
        } else if ("TRCK".equals(string)) {
            id3Info.trackNumber = new String(byArray, n, n2);
        } else if ("TSSE".equals(string)) {
            id3Info.encoder = new String(byArray, n, n2);
        }
    }

    private static void handleFramev22(String string, byte[] byArray, int n, int n2, Id3Info id3Info) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        if ("TT2".equals(string)) {
            id3Info.title = new String(byArray, n, n2);
        } else if ("TAL".equals(string)) {
            id3Info.album = new String(byArray, n, n2);
        } else if ("TP1".equals(string)) {
            id3Info.artist = new String(byArray, n, n2);
        } else if ("TYE".equals(string)) {
            id3Info.year = new String(byArray, n, n2);
        } else if ("TSI".equals(string)) {
            id3Info.genre = new String(byArray, n, n2);
        } else if ("TRK".equals(string)) {
            id3Info.trackNumber = new String(byArray, n, n2);
        } else if ("TSS".equals(string)) {
            id3Info.encoder = new String(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Id3Info readId3v2Tags(String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            Object object;
            randomAccessFile = new RandomAccessFile(string, "r");
            long l = randomAccessFile.length();
            Id3Header id3Header = Id3Header.readFromFile(randomAccessFile);
            if (null == id3Header) {
                Id3Info id3Info = null;
                return id3Info;
            }
            if (!"ID3".equals(id3Header.tag)) {
                Id3Info id3Info = null;
                return id3Info;
            }
            if (2 != id3Header.versionMajor && 3 != id3Header.versionMajor) {
                Id3Info id3Info = null;
                return id3Info;
            }
            long l2 = id3Header.size[3] & 0x7F | (id3Header.size[2] & 0x7F) << 7 | (id3Header.size[1] & 0x7F) << 14 | (id3Header.size[0] & 0x7F) << 21;
            if (l < l2) {
                Id3Info id3Info = null;
                return id3Info;
            }
            if (0 != (id3Header.flags & 0x40)) {
                int n = randomAccessFile.readInt();
                randomAccessFile.skipBytes(n);
            }
            Id3Info id3Info = new Id3Info();
            int n = 0;
            while (l2 > 0L) {
                byte[] byArray;
                object = null;
                FrameHeaderv23 frameHeaderv23 = null;
                if (2 == id3Header.versionMajor) {
                    object = FrameHeaderv22.readFromFile(randomAccessFile);
                    if (null == object) {
                        byArray = null;
                        return byArray;
                    }
                    n = ((FrameHeaderv22)object).getFrameSize();
                }
                if (3 == id3Header.versionMajor) {
                    frameHeaderv23 = FrameHeaderv23.readFromFile(randomAccessFile);
                    if (null == frameHeaderv23) {
                        byArray = null;
                        return byArray;
                    }
                    n = frameHeaderv23.getFrameSize();
                }
                if (false == n || l < (long)n) break;
                byArray = new byte[n];
                int n2 = randomAccessFile.read(byArray);
                if (n2 != n) {
                    Id3Info id3Info2 = null;
                    return id3Info2;
                }
                if (2 == id3Header.versionMajor) {
                    Id3Handler.handleFramev22(((FrameHeaderv22)object).tag, byArray, 1, n - 1, id3Info);
                } else {
                    Id3Handler.handleFramev23(frameHeaderv23.tag, byArray, 1, n - 1, id3Info);
                }
                l2 -= (long)((3 == id3Header.versionMajor ? FrameHeaderv23.getHeaderSize() : FrameHeaderv22.getHeaderSize()) + n);
            }
            object = id3Info;
            return object;
        }
        catch (Exception exception) {
            Id3Info id3Info = null;
            return id3Info;
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Id3Info readId3v1Tags(String string, Id3Info id3Info) {
        Id3Info id3Info2;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            Id3v1 id3v1 = Id3v1.readFromFile(randomAccessFile);
            if (null == id3v1 || !"TAG".equals(id3v1.id)) {
                Id3Info id3Info3 = id3Info;
                return id3Info3;
            }
            if (null == id3Info) {
                id3Info = new Id3Info();
            }
            id3v1.trimFields();
            if (null != id3v1.artist && 0 < id3v1.artist.length()) {
                id3Info.artist = id3v1.artist;
            }
            if (null != id3v1.album && 0 < id3v1.album.length()) {
                id3Info.album = id3v1.album;
            }
            if (null != id3v1.title && 0 < id3v1.title.length()) {
                id3Info.title = id3v1.title;
            }
            if (null != id3v1.year && 0 < id3v1.year.length()) {
                try {
                    int n = Integer.parseInt(id3v1.year);
                    if (1000 <= n && n < 3000) {
                        id3Info.year = id3v1.year;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (0 != id3v1.track) {
                id3Info.trackNumber = Integer.toString(id3v1.track);
            }
            if (255 != id3v1.genre) {
                id3Info.genre = Integer.toString(id3v1.genre);
            }
            id3Info2 = id3Info;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Id3Info id3Info4 = id3Info;
            return id3Info4;
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {}
        }
        return id3Info2;
    }

    public static Id3Info readId3Tags(String string) {
        return Id3Handler.readId3v1Tags(string, Id3Handler.readId3v2Tags(string));
    }

    public static class Id3Info {
        String artist;
        String album;
        String title;
        String genre;
        String year;
        String encoder;
        String trackNumber;
    }

    public static class FrameHeaderv22 {
        String tag;
        byte[] size = new byte[3];

        static FrameHeaderv22 readFromFile(RandomAccessFile randomAccessFile) {
            try {
                FrameHeaderv22 frameHeaderv22 = new FrameHeaderv22();
                byte[] byArray = new byte[3];
                randomAccessFile.read(byArray);
                frameHeaderv22.tag = new String(byArray, 0, 3);
                randomAccessFile.read(frameHeaderv22.size);
                return frameHeaderv22;
            }
            catch (Exception exception) {
                return null;
            }
        }

        static int getHeaderSize() {
            return 6;
        }

        int getFrameSize() {
            int n = this.size[0] >= 0 ? this.size[0] : this.size[0] + 256;
            int n2 = this.size[1] >= 0 ? this.size[1] : this.size[1] + 256;
            int n3 = this.size[2] >= 0 ? this.size[2] : this.size[2] + 256;
            return (n << 16) + (n2 << 8) + n3;
        }
    }

    public static class FrameHeaderv23 {
        String tag;
        int size;
        int flags;

        static FrameHeaderv23 readFromFile(RandomAccessFile randomAccessFile) {
            try {
                FrameHeaderv23 frameHeaderv23 = new FrameHeaderv23();
                byte[] byArray = new byte[4];
                randomAccessFile.read(byArray);
                frameHeaderv23.tag = new String(byArray);
                frameHeaderv23.size = randomAccessFile.readInt();
                frameHeaderv23.flags = randomAccessFile.readUnsignedShort();
                return frameHeaderv23;
            }
            catch (Exception exception) {
                return null;
            }
        }

        static int getHeaderSize() {
            return 10;
        }

        int getFrameSize() {
            return this.size;
        }
    }

    public static class Id3Header {
        String tag;
        int versionMajor;
        int versionRevision;
        int flags;
        int[] size = new int[4];

        static Id3Header readFromFile(RandomAccessFile randomAccessFile) {
            byte[] byArray = new byte[10];
            try {
                randomAccessFile.read(byArray);
                Id3Header id3Header = new Id3Header();
                id3Header.tag = new String(byArray, 0, 3);
                id3Header.versionMajor = byArray[3] >= 0 ? byArray[3] : byArray[3] + 256;
                id3Header.versionRevision = byArray[4] >= 0 ? byArray[4] : byArray[4] + 256;
                id3Header.flags = byArray[5] >= 0 ? byArray[5] : byArray[5] + 256;
                id3Header.size[0] = byArray[6] >= 0 ? byArray[6] : byArray[6] + 256;
                id3Header.size[1] = byArray[7] >= 0 ? byArray[7] : byArray[7] + 256;
                id3Header.size[2] = byArray[8] >= 0 ? byArray[8] : byArray[8] + 256;
                id3Header.size[3] = byArray[9] >= 0 ? byArray[9] : byArray[9] + 256;
                return id3Header;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    public static class Id3v1 {
        String id;
        String title;
        String artist;
        String album;
        String year;
        String comment;
        int track;
        int genre;

        static Id3v1 readFromFile(RandomAccessFile randomAccessFile) {
            byte[] byArray = new byte[128];
            try {
                randomAccessFile.seek(randomAccessFile.length() - 128L);
                randomAccessFile.read(byArray);
                Id3v1 id3v1 = new Id3v1();
                id3v1.id = new String(byArray, 0, 3);
                id3v1.title = new String(byArray, 3, 30);
                id3v1.artist = new String(byArray, 33, 30);
                id3v1.album = new String(byArray, 63, 30);
                id3v1.year = new String(byArray, 93, 4);
                if (0 == byArray[125]) {
                    id3v1.comment = new String(byArray, 97, 28);
                    id3v1.track = byArray[126] >= 0 ? byArray[126] : byArray[126] + 256;
                } else {
                    id3v1.comment = new String(byArray, 97, 30);
                }
                id3v1.genre = byArray[127] >= 0 ? byArray[127] : byArray[127] + 256;
                return id3v1;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public void trimFields() {
            if (null != this.title) {
                this.title = this.title.trim();
            }
            if (null != this.artist) {
                this.artist = this.artist.trim();
            }
            if (null != this.album) {
                this.album = this.album.trim();
            }
            if (null != this.year) {
                this.year = this.year.trim();
            }
        }
    }
}

