/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ClientMetadata;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;

public class FetchResult {
    final ClientMetadata metadata;
    final Bucket data;

    public FetchResult(ClientMetadata dm, Bucket fetched) {
        if (dm == null) {
            throw new IllegalArgumentException();
        }
        assert (fetched != null);
        this.metadata = dm;
        this.data = fetched;
    }

    public FetchResult(FetchResult fr, Bucket output) {
        this.data = output;
        this.metadata = fr.metadata;
    }

    public String getMimeType() {
        return this.metadata.getMIMEType();
    }

    public ClientMetadata getMetadata() {
        return this.metadata;
    }

    public long size() {
        return this.data.size();
    }

    public byte[] asByteArray() throws IOException {
        return BucketTools.toByteArray(this.data);
    }

    public Bucket asBucket() {
        return this.data;
    }
}

