/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.SimpleFieldSet;

public class PluginInfoMessage
extends FCPMessage {
    static final String NAME = "PluginInfo";
    private final String identifier;
    private final boolean detailed;
    private final String classname;
    private final String originuri;
    private final long started;
    private final boolean isTalkable;
    private final long longVersion;
    private final String version;

    PluginInfoMessage(PluginInfoWrapper pi, String identifier, boolean detail) {
        this.identifier = identifier;
        this.detailed = detail;
        this.classname = pi.getPluginClassName();
        this.originuri = pi.getFilename();
        this.started = pi.getStarted();
        this.isTalkable = pi.isFCPPlugin();
        this.longVersion = pi.getPluginLongVersion();
        this.version = pi.getPluginVersion();
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        if (this.identifier != null) {
            sfs.putSingle("Identifier", this.identifier);
        }
        sfs.putSingle("PluginName", this.classname);
        sfs.put("IsTalkable", this.isTalkable);
        sfs.put("LongVersion", this.longVersion);
        sfs.putSingle("Version", this.version);
        if (this.detailed) {
            sfs.putSingle("OriginUri", this.originuri);
            sfs.put("Started", this.started);
        }
        return sfs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PluginInfo goes from server to client not the other way around", null, false);
    }
}

