/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.wizardsteps.BANDWIDTH;
import freenet.clients.http.wizardsteps.BANDWIDTH_MONTHLY;
import freenet.clients.http.wizardsteps.BANDWIDTH_RATE;
import freenet.clients.http.wizardsteps.BROWSER_WARNING;
import freenet.clients.http.wizardsteps.DATASTORE_SIZE;
import freenet.clients.http.wizardsteps.MISC;
import freenet.clients.http.wizardsteps.NAME_SELECTION;
import freenet.clients.http.wizardsteps.OPENNET;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.PersistFields;
import freenet.clients.http.wizardsteps.SECURITY_NETWORK;
import freenet.clients.http.wizardsteps.SECURITY_PHYSICAL;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WELCOME;
import freenet.config.PersistentConfig;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;

public class FirstTimeWizardToadlet
extends Toadlet {
    private final NodeClientCore core;
    private final EnumMap<WIZARD_STEP, Step> steps;
    private final MISC stepMISC;
    private final SECURITY_NETWORK stepSECURITY_NETWORK;
    private final SECURITY_PHYSICAL stepSECURITY_PHYSICAL;
    private static volatile boolean logMINOR;
    public static final String TOADLET_URL = "/wizard/";

    FirstTimeWizardToadlet(HighLevelSimpleClient client, Node node, NodeClientCore core) {
        super(client);
        this.core = core;
        PersistentConfig config = node.config;
        this.steps = new EnumMap(WIZARD_STEP.class);
        this.steps.put(WIZARD_STEP.WELCOME, new WELCOME(config));
        this.steps.put(WIZARD_STEP.BROWSER_WARNING, new BROWSER_WARNING());
        this.steps.put(WIZARD_STEP.NAME_SELECTION, new NAME_SELECTION(config));
        this.steps.put(WIZARD_STEP.DATASTORE_SIZE, new DATASTORE_SIZE(core, config));
        this.steps.put(WIZARD_STEP.OPENNET, new OPENNET());
        this.steps.put(WIZARD_STEP.BANDWIDTH, new BANDWIDTH());
        this.steps.put(WIZARD_STEP.BANDWIDTH_MONTHLY, new BANDWIDTH_MONTHLY(core, config));
        this.steps.put(WIZARD_STEP.BANDWIDTH_RATE, new BANDWIDTH_RATE(core, config));
        this.stepMISC = new MISC(core, config);
        this.steps.put(WIZARD_STEP.MISC, this.stepMISC);
        this.stepSECURITY_NETWORK = new SECURITY_NETWORK(core);
        this.steps.put(WIZARD_STEP.SECURITY_NETWORK, this.stepSECURITY_NETWORK);
        this.stepSECURITY_PHYSICAL = new SECURITY_PHYSICAL(core);
        this.steps.put(WIZARD_STEP.SECURITY_PHYSICAL, this.stepSECURITY_PHYSICAL);
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        WIZARD_STEP currentStep;
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        try {
            currentStep = WIZARD_STEP.valueOf(request.getParam("step", WIZARD_STEP.WELCOME.toString()));
        }
        catch (IllegalArgumentException e) {
            currentStep = WIZARD_STEP.WELCOME;
        }
        PersistFields persistFields = new PersistFields(request);
        if (currentStep == WIZARD_STEP.BROWSER_WARNING && request.isChrome() && request.isIncognito()) {
            super.writeTemporaryRedirect(ctx, "Skipping unneeded warning", persistFields.appendTo("/wizard/?step=MISC"));
            return;
        }
        if (currentStep == WIZARD_STEP.MISC && persistFields.isUsingPreset()) {
            StringBuilder redirectBase = new StringBuilder("/wizard/?step=");
            if (persistFields.preset == WIZARD_PRESET.HIGH) {
                redirectBase.append("SECURITY_NETWORK&preset=HIGH&confirm=true&opennet=false&security-levels.networkThreatLevel=HIGH");
            } else {
                redirectBase.append("DATASTORE_SIZE&preset=LOW&opennet=true");
            }
            super.writeTemporaryRedirect(ctx, "Skipping to next necessary step", redirectBase.toString());
            return;
        }
        if (currentStep == WIZARD_STEP.SECURITY_NETWORK && !request.isParameterSet("opennet")) {
            super.writeTemporaryRedirect(ctx, "Need opennet choice", persistFields.appendTo("/wizard/?step=OPENNET"));
            return;
        }
        if (currentStep == WIZARD_STEP.NAME_SELECTION && this.core.node.isOpennetEnabled()) {
            super.writeTemporaryRedirect(ctx, "Skip name selection", persistFields.appendTo(this.stepURL(WIZARD_STEP.DATASTORE_SIZE.name())));
            return;
        }
        if (currentStep == WIZARD_STEP.COMPLETE) {
            super.writeTemporaryRedirect(ctx, "Wizard complete", "/");
            return;
        }
        Step getStep = this.steps.get((Object)currentStep);
        PageHelper helper = new PageHelper(ctx, persistFields, currentStep);
        getStep.getStep(request, helper);
        this.writeHTMLReply(ctx, 200, "OK", helper.getPageOuter().generate());
    }

    public static boolean shouldLogMinor() {
        return logMINOR;
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String redirectTarget;
        PersistFields persistFields;
        block15: {
            WIZARD_STEP currentStep;
            if (!ctx.checkFullAccess(this)) {
                return;
            }
            try {
                String currentValue = request.getPartAsStringFailsafe("step", 20);
                currentStep = currentValue.isEmpty() ? WIZARD_STEP.WELCOME : WIZARD_STEP.valueOf(currentValue);
            }
            catch (IllegalArgumentException e) {
                currentStep = WIZARD_STEP.WELCOME;
            }
            persistFields = new PersistFields(request);
            if (currentStep.equals((Object)WIZARD_STEP.WELCOME) && (request.isPartSet("presetLow") || request.isPartSet("presetHigh") || request.isPartSet("presetNone"))) {
                StringBuilder redirectTo = new StringBuilder("/wizard/?step=BROWSER_WARNING&incognito=");
                redirectTo.append(request.getPartAsStringFailsafe("incognito", 5));
                if (request.isPartSet("presetLow")) {
                    this.stepMISC.setUPnP(true);
                    this.stepMISC.setAutoUpdate(true);
                    redirectTo.append("&preset=LOW&opennet=true");
                    this.stepSECURITY_NETWORK.setThreatLevel(SecurityLevels.NETWORK_THREAT_LEVEL.LOW);
                    this.stepSECURITY_PHYSICAL.setThreatLevel(SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL, this.stepSECURITY_PHYSICAL.getCurrentLevel());
                } else if (request.isPartSet("presetHigh")) {
                    this.stepMISC.setUPnP(true);
                    this.stepMISC.setAutoUpdate(true);
                    redirectTo.append("&preset=HIGH&opennet=false");
                }
                super.writeTemporaryRedirect(ctx, "Wizard set preset", redirectTo.toString());
                return;
            }
            if (request.isPartSet("back")) {
                redirectTarget = FirstTimeWizardToadlet.getPreviousStep(currentStep, persistFields.preset).name();
            } else {
                try {
                    redirectTarget = this.steps.get((Object)currentStep).postStep(request);
                    if (currentStep != WIZARD_STEP.OPENNET) break block15;
                    try {
                        HTTPRequestImpl newRequest = new HTTPRequestImpl(new URI(this.stepURL(redirectTarget)), "GET");
                        if (newRequest.isPartSet("opennet")) {
                            redirectTarget = WIZARD_STEP.SECURITY_NETWORK.name();
                            persistFields = new PersistFields(persistFields.preset, (HTTPRequest)newRequest);
                        }
                    }
                    catch (URISyntaxException e) {
                        Logger.error(this, "Unexpected invalid query string from OPENNET step! " + e, (Throwable)e);
                        redirectTarget = WIZARD_STEP.WELCOME.name();
                    }
                }
                catch (IOException e) {
                    String title = e.getMessage().equals("cantWriteNewMasterKeysFile") ? NodeL10n.getBase().getString("SecurityLevels.cantWriteNewMasterKeysFileTitle") : NodeL10n.getBase().getString("Toadlet.internalErrorPleaseReport");
                    StringBuilder msg = new StringBuilder("<html><head><title>").append(title).append("</title></head><body><h1>").append(title).append("</h1><pre>");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    msg.append(sw.toString()).append("</pre>");
                    Throwable internal = e.getCause();
                    if (internal != null) {
                        msg.append("<h1>").append(NodeL10n.getBase().getString("Toadlet.internalErrorPleaseReport")).append("</h1>").append("<pre>");
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        internal.printStackTrace(pw);
                        pw.flush();
                        msg.append(sw.toString()).append("</pre>");
                    }
                    msg.append("</body></html>");
                    this.writeHTMLReply(ctx, 500, "Internal Error", msg.toString());
                    return;
                }
            }
        }
        super.writeTemporaryRedirect(ctx, "Wizard redirect", this.stepURL(persistFields.appendTo(redirectTarget)));
    }

    private String stepURL(String step) {
        return "/wizard/?step=" + step;
    }

    public static WIZARD_STEP getPreviousStep(WIZARD_STEP currentStep, WIZARD_PRESET preset) {
        if (preset == WIZARD_PRESET.HIGH) {
            switch (currentStep) {
                case SECURITY_NETWORK: 
                case SECURITY_PHYSICAL: {
                    return WIZARD_STEP.WELCOME;
                }
            }
        } else if (preset == WIZARD_PRESET.LOW) {
            switch (currentStep) {
                case DATASTORE_SIZE: {
                    return WIZARD_STEP.WELCOME;
                }
            }
        }
        switch (currentStep) {
            case MISC: 
            case BROWSER_WARNING: {
                return WIZARD_STEP.WELCOME;
            }
            case OPENNET: {
                return WIZARD_STEP.MISC;
            }
            case SECURITY_NETWORK: {
                return WIZARD_STEP.OPENNET;
            }
            case SECURITY_PHYSICAL: {
                return WIZARD_STEP.SECURITY_NETWORK;
            }
            case NAME_SELECTION: {
                return WIZARD_STEP.SECURITY_PHYSICAL;
            }
            case DATASTORE_SIZE: {
                return WIZARD_STEP.NAME_SELECTION;
            }
            case BANDWIDTH: {
                return WIZARD_STEP.DATASTORE_SIZE;
            }
            case BANDWIDTH_MONTHLY: 
            case BANDWIDTH_RATE: {
                return WIZARD_STEP.BANDWIDTH;
            }
        }
        return WIZARD_STEP.WELCOME;
    }

    @Override
    public String path() {
        return TOADLET_URL;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static enum WIZARD_PRESET {
        LOW,
        HIGH;

    }

    public static enum WIZARD_STEP {
        WELCOME,
        BROWSER_WARNING,
        MISC,
        OPENNET,
        SECURITY_NETWORK,
        SECURITY_PHYSICAL,
        NAME_SELECTION,
        DATASTORE_SIZE,
        BANDWIDTH,
        BANDWIDTH_MONTHLY,
        BANDWIDTH_RATE,
        COMPLETE;

    }
}

