/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptFormatException;
import freenet.crypt.CryptoKey;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.Global;
import freenet.crypt.SHA256;
import freenet.crypt.Util;
import freenet.node.FSParseException;
import freenet.store.StorableBlock;
import freenet.support.Base64;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.SimpleFieldSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import net.i2p.util.NativeBigInteger;

public class DSAPublicKey
extends CryptoKey
implements StorableBlock {
    private static final long serialVersionUID = -1L;
    private final BigInteger y;
    public static final int PADDED_SIZE = 1024;
    public static final int HASH_LENGTH = 32;
    private final DSAGroup group;
    private byte[] fingerprint = null;

    private static final DSAGroup group(DSAGroup g) {
        if (g == null) {
            return Global.DSAgroupBigA;
        }
        return g;
    }

    public DSAPublicKey(DSAGroup g, BigInteger y) {
        if (y.signum() != 1) {
            throw new IllegalArgumentException();
        }
        this.y = y;
        if (g == Global.DSAgroupBigA) {
            g = null;
        }
        this.group = g;
        if (y.compareTo(this.getGroup().getP()) > 0) {
            throw new IllegalArgumentException("y must be < p but y=" + y + " p=" + g.getP());
        }
    }

    public DSAPublicKey(DSAGroup g, String yAsHexString) throws NumberFormatException {
        this.y = new NativeBigInteger(yAsHexString, 16);
        if (this.y.signum() != 1) {
            throw new IllegalArgumentException();
        }
        if (g == Global.DSAgroupBigA) {
            g = null;
        }
        this.group = g;
    }

    public DSAPublicKey(DSAGroup g, DSAPrivateKey p) {
        this(g, g.getG().modPow(p.getX(), g.getP()));
    }

    public DSAPublicKey(InputStream is) throws IOException, CryptFormatException {
        DSAGroup g = (DSAGroup)DSAGroup.read(is);
        if (g == Global.DSAgroupBigA) {
            g = null;
        }
        this.group = g;
        this.y = Util.readMPI(is);
        if (this.y.compareTo(this.getGroup().getP()) > 0) {
            throw new IllegalArgumentException("y must be < p but y=" + this.y + " p=" + this.getGroup().getP());
        }
    }

    public DSAPublicKey(byte[] pubkeyBytes) throws IOException, CryptFormatException {
        this(new ByteArrayInputStream(pubkeyBytes));
    }

    private DSAPublicKey(DSAPublicKey key) {
        this.fingerprint = null;
        this.y = new NativeBigInteger(1, key.y.toByteArray());
        DSAGroup g = key.group;
        if (g != null) {
            g = g.cloneKey();
        }
        this.group = g;
    }

    public static DSAPublicKey create(byte[] pubkeyAsBytes) throws CryptFormatException {
        try {
            return new DSAPublicKey(new ByteArrayInputStream(pubkeyAsBytes));
        }
        catch (IOException e) {
            throw new CryptFormatException(e);
        }
    }

    protected DSAPublicKey() {
        this.y = null;
        this.group = null;
    }

    public BigInteger getY() {
        return this.y;
    }

    public BigInteger getP() {
        return this.getGroup().getP();
    }

    public BigInteger getQ() {
        return this.getGroup().getQ();
    }

    public BigInteger getG() {
        return this.getGroup().getG();
    }

    @Override
    public String keyType() {
        return "DSA.p";
    }

    public final DSAGroup getGroup() {
        if (this.group == null) {
            return Global.DSAgroupBigA;
        }
        return this.group;
    }

    public static CryptoKey read(InputStream i) throws IOException, CryptFormatException {
        return new DSAPublicKey(i);
    }

    public int keyId() {
        return this.y.intValue();
    }

    @Override
    public String toLongString() {
        return "y=" + HexUtil.biToHex(this.y);
    }

    @Override
    public byte[] asBytes() {
        byte[] groupBytes = this.getGroup().asBytes();
        byte[] ybytes = Util.MPIbytes(this.y);
        byte[] bytes = new byte[groupBytes.length + ybytes.length];
        System.arraycopy(groupBytes, 0, bytes, 0, groupBytes.length);
        System.arraycopy(ybytes, 0, bytes, groupBytes.length, ybytes.length);
        return bytes;
    }

    public byte[] asBytesHash() {
        byte[] hash = SHA256.digest(this.asBytes());
        return hash;
    }

    public byte[] asPaddedBytes() {
        byte[] asBytes = this.asBytes();
        if (asBytes.length == 1024) {
            return asBytes;
        }
        if (asBytes.length > 1024) {
            throw new Error("Cannot fit key in 1024 - real size is " + asBytes.length);
        }
        return Arrays.copyOf(asBytes, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] fingerprint() {
        DSAPublicKey dSAPublicKey = this;
        synchronized (dSAPublicKey) {
            if (this.fingerprint == null) {
                this.fingerprint = this.fingerprint(new BigInteger[]{this.y});
            }
            return this.fingerprint;
        }
    }

    public boolean equals(DSAPublicKey o) {
        if (this == o) {
            return true;
        }
        return this.y.equals(o.y) && this.getGroup().equals(o.getGroup());
    }

    public int hashCode() {
        return this.y.hashCode() ^ this.getGroup().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.y.equals(((DSAPublicKey)o).y) && this.getGroup().equals(((DSAPublicKey)o).getGroup());
    }

    public int compareTo(Object other) {
        if (other instanceof DSAPublicKey) {
            return this.getY().compareTo(((DSAPublicKey)other).getY());
        }
        return -1;
    }

    public SimpleFieldSet asFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("y", Base64.encode(this.y.toByteArray()));
        return fs;
    }

    public static DSAPublicKey create(SimpleFieldSet set, DSAGroup group) throws FSParseException {
        NativeBigInteger x;
        try {
            x = new NativeBigInteger(1, Base64.decode(set.get("y")));
        }
        catch (IllegalBase64Exception e) {
            throw new FSParseException(e);
        }
        try {
            return new DSAPublicKey(group, x);
        }
        catch (IllegalArgumentException e) {
            throw new FSParseException(e);
        }
    }

    @Override
    public byte[] getFullKey() {
        return this.asBytesHash();
    }

    @Override
    public byte[] getRoutingKey() {
        return this.asBytesHash();
    }

    public DSAPublicKey cloneKey() {
        return new DSAPublicKey(this);
    }
}

