/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.MasterSecret;
import freenet.crypt.PCFBMode;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.node.DatabaseKey;
import freenet.node.MasterKeysFileSizeException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.support.Fields;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;

public class MasterKeys {
    final byte[] clientCacheMasterKey;
    private final byte[] databaseKey;
    private final byte[] tempfilesMasterSecret;
    final long flags;
    static final long FLAG_ENCRYPT_DATABASE = 2L;
    static final int OLD_HASH_LENGTH = 4;
    static final int HASH_LENGTH = 12;
    static final int VERSION = 1;
    static final long MAX_ITERATIONS = 0x10000000000L;
    static int ITERATE_TIME = 1000;

    public MasterKeys(byte[] clientCacheKey, byte[] databaseKey, byte[] tempfilesMasterSecret, long flags) {
        this.clientCacheMasterKey = clientCacheKey;
        this.databaseKey = databaseKey;
        this.flags = flags;
        this.tempfilesMasterSecret = tempfilesMasterSecret;
    }

    public static MasterKeys createRandom(Random random) {
        byte[] clientCacheKey = new byte[32];
        random.nextBytes(clientCacheKey);
        byte[] databaseKey = new byte[32];
        random.nextBytes(databaseKey);
        byte[] tempfilesMasterSecret = new byte[64];
        random.nextBytes(tempfilesMasterSecret);
        return new MasterKeys(clientCacheKey, databaseKey, tempfilesMasterSecret, 0L);
    }

    void clearClientCacheKeys() {
        MasterKeys.clear(this.clientCacheMasterKey);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MasterKeys read(File masterKeysFile, Random hardRandom, String password) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        block22: {
            System.err.println("Trying to read master keys file...");
            if (masterKeysFile != null && masterKeysFile.exists()) {
                MasterKeys masterKeys;
                DataInputStream dis;
                int length;
                FileInputStream fis;
                block21: {
                    fis = null;
                    long len = masterKeysFile.length();
                    if (len > 1024L) {
                        throw new MasterKeysFileSizeException(true);
                    }
                    if (len < 104L) {
                        throw new MasterKeysFileSizeException(false);
                    }
                    length = (int)len;
                    fis = new FileInputStream(masterKeysFile);
                    dis = new DataInputStream(fis);
                    if (len != 140L) break block21;
                    MasterKeys ret = MasterKeys.readOldFormat(dis, length, hardRandom, password);
                    System.out.println("Read old-format master keys file. Writing new format master.keys ...");
                    ret.changePassword(masterKeysFile, password, hardRandom);
                    MasterKeys masterKeys2 = ret;
                    Closer.close(fis);
                    return masterKeys2;
                }
                try {
                    Rijndael cipher;
                    if (dis.readInt() != 1) {
                        throw new IOException("Bad version for master.keys");
                    }
                    long iterations = dis.readLong();
                    if (iterations < 0L || iterations > 0x10000000000L) {
                        throw new IOException("Bad iterations " + iterations + " for master.keys");
                    }
                    byte[] salt = new byte[32];
                    dis.readFully(salt);
                    byte[] iv = new byte[32];
                    dis.readFully(iv);
                    byte[] dataAndHash = new byte[length - salt.length - iv.length - 4 - 8];
                    dis.readFully(dataAndHash);
                    byte[] pwd = password.getBytes("UTF-8");
                    MessageDigest md = SHA256.getMessageDigest();
                    md.update(pwd);
                    md.update(salt);
                    byte[] outerKey = md.digest();
                    if (iterations > 0L) {
                        System.out.println("Decrypting master keys using password with " + iterations + " iterations...");
                        for (long i = 0L; i < iterations; ++i) {
                            md.update(salt);
                            md.update(outerKey);
                            outerKey = md.digest();
                        }
                    }
                    try {
                        cipher = new Rijndael(256, 256);
                    }
                    catch (UnsupportedCipherException e) {
                        throw new Error(e);
                    }
                    cipher.initialize(outerKey);
                    PCFBMode pcfb = PCFBMode.create(cipher, iv);
                    pcfb.blockDecipher(dataAndHash, 0, dataAndHash.length);
                    byte[] data = Arrays.copyOf(dataAndHash, dataAndHash.length - 12);
                    byte[] hash = Arrays.copyOfRange(dataAndHash, data.length, dataAndHash.length);
                    MasterKeys.clear(dataAndHash);
                    byte[] checkHash = md.digest(data);
                    if (!Fields.byteArrayEqual(checkHash, hash, 0, 0, 12)) {
                        MasterKeys.clear(data);
                        MasterKeys.clear(hash);
                        throw new MasterKeysWrongPasswordException();
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    dis = new DataInputStream(bais);
                    long flags = dis.readLong();
                    byte[] clientCacheKey = new byte[32];
                    dis.readFully(clientCacheKey);
                    byte[] databaseKey = null;
                    databaseKey = new byte[32];
                    dis.readFully(databaseKey);
                    byte[] tempfilesMasterSecret = new byte[64];
                    boolean mustWrite = false;
                    if (data.length >= 136) {
                        dis.readFully(tempfilesMasterSecret);
                    } else {
                        System.err.println("Created new master secret for encrypted tempfiles");
                        hardRandom.nextBytes(tempfilesMasterSecret);
                        mustWrite = true;
                    }
                    MasterKeys ret = new MasterKeys(clientCacheKey, databaseKey, tempfilesMasterSecret, flags);
                    MasterKeys.clear(data);
                    MasterKeys.clear(hash);
                    SHA256.returnMessageDigest(md);
                    System.err.println("Read old master keys file");
                    if (mustWrite) {
                        ret.changePassword(masterKeysFile, password, hardRandom);
                    }
                    masterKeys = ret;
                }
                catch (FileNotFoundException e) {
                    Closer.close(fis);
                    break block22;
                    catch (UnsupportedEncodingException e2) {
                        try {
                            System.err.println("JVM doesn't support UTF-8, this should be impossible!");
                            throw new Error(e2);
                            catch (EOFException e3) {
                                throw new MasterKeysFileSizeException(false);
                            }
                        }
                        catch (Throwable throwable) {
                            Closer.close(fis);
                            throw throwable;
                        }
                    }
                }
                Closer.close(fis);
                return masterKeys;
            }
        }
        System.err.println("Creating new master keys file");
        MasterKeys ret = MasterKeys.createRandom(hardRandom);
        ret.write(masterKeysFile, password, hardRandom);
        return ret;
    }

    private static MasterKeys readOldFormat(DataInputStream dis, int length, Random hardRandom, String password) throws IOException, MasterKeysWrongPasswordException {
        Rijndael cipher;
        byte[] salt = new byte[32];
        dis.readFully(salt);
        byte[] iv = new byte[32];
        dis.readFully(iv);
        byte[] dataAndHash = new byte[length - salt.length - iv.length];
        dis.readFully(dataAndHash);
        byte[] pwd = password.getBytes("UTF-8");
        MessageDigest md = SHA256.getMessageDigest();
        md.update(pwd);
        md.update(salt);
        byte[] outerKey = md.digest();
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        cipher.initialize(outerKey);
        PCFBMode pcfb = PCFBMode.create(cipher, iv);
        pcfb.blockDecipher(dataAndHash, 0, dataAndHash.length);
        byte[] data = Arrays.copyOf(dataAndHash, dataAndHash.length - 4);
        byte[] hash = Arrays.copyOfRange(dataAndHash, data.length, dataAndHash.length);
        MasterKeys.clear(dataAndHash);
        byte[] checkHash = md.digest(data);
        if (!Fields.byteArrayEqual(checkHash, hash, 0, 0, 4)) {
            MasterKeys.clear(data);
            MasterKeys.clear(hash);
            throw new MasterKeysWrongPasswordException();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        dis = new DataInputStream(bais);
        byte[] flagsBytes = new byte[8];
        dis.readFully(flagsBytes);
        long flags = Fields.bytesToLong(flagsBytes);
        byte[] clientCacheKey = new byte[32];
        dis.readFully(clientCacheKey);
        byte[] databaseKey = null;
        databaseKey = new byte[32];
        dis.readFully(databaseKey);
        byte[] tempfilesMasterSecret = new byte[64];
        System.err.println("Created new master secret for encrypted tempfiles");
        hardRandom.nextBytes(tempfilesMasterSecret);
        MasterKeys ret = new MasterKeys(clientCacheKey, databaseKey, tempfilesMasterSecret, flags);
        MasterKeys.clear(data);
        MasterKeys.clear(hash);
        SHA256.returnMessageDigest(md);
        return ret;
    }

    public static void clear(byte[] buf) {
        if (buf == null) {
            return;
        }
        Arrays.fill(buf, (byte)0);
    }

    public void changePassword(File masterKeysFile, String newPassword, Random hardRandom) throws IOException {
        System.err.println("Writing new master.keys file");
        this.write(masterKeysFile, newPassword, hardRandom);
    }

    private void write(File masterKeysFile, String newPassword, Random hardRandom) throws IOException {
        Rijndael cipher;
        byte[] pwd;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] iv = new byte[32];
        hardRandom.nextBytes(iv);
        byte[] salt = new byte[32];
        hardRandom.nextBytes(salt);
        try {
            pwd = newPassword.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        MessageDigest md = SHA256.getMessageDigest();
        md.update(pwd);
        md.update(salt);
        byte[] outerKey = md.digest();
        long iterations = 0L;
        if (!newPassword.equals("")) {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() < startTime + (long)ITERATE_TIME && iterations < 0xFFFFFFFFECL) {
                for (int i = 0; i < 10; ++i) {
                    ++iterations;
                    md.update(salt);
                    md.update(outerKey);
                    outerKey = md.digest();
                }
            }
            System.out.println("Encrypted password with " + iterations + " iterations.");
        }
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(1);
        dos.writeLong(iterations);
        baos.write(salt);
        baos.write(iv);
        int hashedStart = salt.length + iv.length + 4 + 8;
        dos.writeLong(this.flags);
        baos.write(this.clientCacheMasterKey);
        baos.write(this.databaseKey);
        baos.write(this.tempfilesMasterSecret);
        byte[] data = baos.toByteArray();
        md.update(data, hashedStart, data.length - hashedStart);
        byte[] hash = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        baos.write(hash, 0, 12);
        data = baos.toByteArray();
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        cipher.initialize(outerKey);
        PCFBMode pcfb = PCFBMode.create(cipher, iv);
        pcfb.blockEncipher(data, hashedStart, data.length - hashedStart);
        RandomAccessFile raf = new RandomAccessFile(masterKeysFile, "rw");
        raf.seek(0L);
        raf.write(data);
        long len = raf.length();
        if (len > (long)data.length) {
            byte[] diff = new byte[(int)(len - (long)data.length)];
            raf.write(diff);
            raf.setLength(data.length);
        }
        raf.getFD().sync();
        raf.close();
    }

    public static void killMasterKeys(File masterKeysFile) throws IOException {
        FileUtil.secureDelete(masterKeysFile);
    }

    public DatabaseKey createDatabaseKey(Random random) {
        return new DatabaseKey(this.databaseKey, random);
    }

    public MasterSecret getPersistentMasterSecret() {
        return new MasterSecret((byte[])this.tempfilesMasterSecret.clone());
    }
}

