/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.l10n.NodeL10n;
import freenet.node.BlockedTooLongException;
import freenet.node.Node;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import freenet.support.io.NativeThread;
import freenet.support.math.MersenneTwister;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class PacketSender
implements Runnable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    static final long MAX_COALESCING_DELAY;
    static final long MAX_COALESCING_DELAY_BULK;
    static final int MIN_CONNECTIONS_TRY_OLD_OPENNET_PEERS = 5;
    static final long MIN_OLD_OPENNET_CONNECT_DELAY_NO_CONNS;
    static final long MIN_OLD_OPENNET_CONNECT_DELAY;
    final NativeThread myThread;
    final Node node;
    NodeStats stats;
    long lastReportedNoPackets;
    long lastReceivedPacketFromAnyNode;
    private MersenneTwister localRandom;

    PacketSender(Node node) {
        this.node = node;
        this.myThread = new NativeThread(this, "PacketSender thread for " + node.getDarknetPortNumber(), NativeThread.MAX_PRIORITY, false);
        this.myThread.setDaemon(true);
        this.localRandom = node.createRandom();
    }

    void start(NodeStats stats) {
        this.stats = stats;
        Logger.normal(this, "Starting PacketSender");
        System.out.println("Starting PacketSender");
        this.myThread.start();
    }

    private void schedulePeriodicJob() {
        this.node.ticker.queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long now = System.currentTimeMillis();
                    if (logMINOR) {
                        Logger.minor(PacketSender.class, "Starting shedulePeriodicJob() at " + now);
                    }
                    PeerManager pm = PacketSender.this.node.peers;
                    pm.maybeLogPeerNodeStatusSummary(now);
                    pm.maybeUpdateOldestNeverConnectedDarknetPeerAge(now);
                    PacketSender.this.stats.maybeUpdatePeerManagerUserAlertStats(now);
                    PacketSender.this.stats.maybeUpdateNodeIOStats(now);
                    pm.maybeUpdatePeerNodeRoutableConnectionStats(now);
                    if (logMINOR) {
                        Logger.minor(PacketSender.class, "Finished running shedulePeriodicJob() at " + System.currentTimeMillis());
                    }
                }
                finally {
                    PacketSender.this.node.ticker.queueTimedJob(this, 1000L);
                }
            }
        }, 1000L);
    }

    @Override
    public void run() {
        if (logMINOR) {
            Logger.minor(this, "In PacketSender.run()");
        }
        Logger.OSThread.logPID(this);
        this.schedulePeriodicJob();
        while (true) {
            this.lastReceivedPacketFromAnyNode = this.lastReportedNoPackets;
            try {
                this.realRun();
                continue;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught in PacketSender: " + t, t);
                System.err.println("Caught in PacketSender: " + t);
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        boolean canSendThrottled;
        long now = System.currentTimeMillis();
        PeerManager pm = this.node.peers;
        PeerNode[] nodes = pm.myPeers();
        long nextActionTime = Long.MAX_VALUE;
        long oldTempNow = now;
        int MAX_PACKET_SIZE = this.node.darknetCrypto.socket.getMaxPacketSize();
        long count = this.node.outputThrottle.getCount();
        if (count > (long)MAX_PACKET_SIZE) {
            canSendThrottled = true;
        } else {
            long canSendAt = this.node.outputThrottle.getNanosPerTick() * ((long)MAX_PACKET_SIZE - count);
            canSendAt = TimeUnit.MILLISECONDS.convert(canSendAt + TimeUnit.MILLISECONDS.toNanos(1L) - 1L, TimeUnit.NANOSECONDS);
            if (logMINOR) {
                Logger.minor(this, "Can send throttled packets in " + canSendAt + "ms");
            }
            nextActionTime = Math.min(nextActionTime, now + canSendAt);
            canSendThrottled = false;
        }
        long lowestUrgentSendTime = Long.MAX_VALUE;
        ArrayList<PeerNode> urgentSendPeers = null;
        long lowestFullPacketSendTime = Long.MAX_VALUE;
        ArrayList<PeerNode> urgentFullPacketPeers = null;
        long lowestAckTime = Long.MAX_VALUE;
        ArrayList<PeerNode> ackPeers = null;
        long lowestHandshakeTime = Long.MAX_VALUE;
        ArrayList<PeerNode> handshakePeers = null;
        for (PeerNode pn : nodes) {
            long tempNow;
            now = System.currentTimeMillis();
            this.lastReceivedPacketFromAnyNode = Math.max(pn.lastReceivedPacketTime(), this.lastReceivedPacketFromAnyNode);
            pn.maybeOnConnect();
            if (pn.shouldDisconnectAndRemoveNow() && !pn.isDisconnecting()) {
                this.node.peers.disconnectAndRemove(pn, true, true, false);
            }
            if (pn.isConnected()) {
                long ackTime;
                boolean shouldThrottle = pn.shouldThrottle();
                pn.checkForLostPackets();
                if (now - pn.lastReceivedDataPacketTime() > pn.maxTimeBetweenReceivedPackets()) {
                    Logger.normal(this, "Disconnecting from " + pn + " - haven't received packets recently");
                    pn.disconnected(true, false);
                    continue;
                }
                if (now - pn.lastReceivedAckTime() > pn.maxTimeBetweenReceivedAcks() && !pn.isDisconnecting()) {
                    Logger.normal(this, "Disconnecting from " + pn + " - haven't received acks recently");
                    this.node.peers.disconnect(pn, true, true, false, true, false, TimeUnit.SECONDS.toMillis(5L));
                    continue;
                }
                if (pn.isRoutable() && pn.noLongerRoutable()) {
                    pn.invalidate(now);
                    Logger.normal(this, "shouldDisconnectNow has returned true : marking the peer as incompatible: " + pn);
                    continue;
                }
                if (canSendThrottled || !shouldThrottle) {
                    long sendTime = pn.getNextUrgentTime(now);
                    if (sendTime != Long.MAX_VALUE) {
                        if (sendTime <= now) {
                            if (sendTime < lowestUrgentSendTime) {
                                lowestUrgentSendTime = sendTime;
                                if (urgentSendPeers != null) {
                                    urgentSendPeers.clear();
                                } else {
                                    urgentSendPeers = new ArrayList<PeerNode>();
                                }
                            }
                            if (sendTime <= lowestUrgentSendTime) {
                                urgentSendPeers.add(pn);
                            }
                        } else if (pn.fullPacketQueued()) {
                            if (sendTime < lowestFullPacketSendTime) {
                                lowestFullPacketSendTime = sendTime;
                                if (urgentFullPacketPeers != null) {
                                    urgentFullPacketPeers.clear();
                                } else {
                                    urgentFullPacketPeers = new ArrayList<PeerNode>();
                                }
                            }
                            if (sendTime <= lowestFullPacketSendTime) {
                                urgentFullPacketPeers.add(pn);
                            }
                        }
                    }
                } else if (shouldThrottle && !canSendThrottled && (ackTime = pn.timeSendAcks()) != Long.MAX_VALUE && ackTime <= now) {
                    if (ackTime < lowestAckTime) {
                        lowestAckTime = ackTime;
                        if (ackPeers != null) {
                            ackPeers.clear();
                        } else {
                            ackPeers = new ArrayList<PeerNode>();
                        }
                    }
                    if (ackTime <= lowestAckTime) {
                        ackPeers.add(pn);
                    }
                }
                if (canSendThrottled || !shouldThrottle) {
                    long urgentTime = pn.getNextUrgentTime(now);
                    if (urgentTime < Long.MAX_VALUE && logMINOR) {
                        Logger.minor(this, "Next urgent time: " + urgentTime + "(in " + (urgentTime - now) + ") for " + pn);
                    }
                    nextActionTime = Math.min(nextActionTime, urgentTime);
                } else {
                    nextActionTime = Math.min(nextActionTime, pn.timeCheckForLostPackets());
                }
            } else if (pn.noContactDetails()) {
                pn.startARKFetcher();
            }
            long handshakeTime = pn.timeSendHandshake(now);
            if (handshakeTime != Long.MAX_VALUE) {
                if (handshakeTime < lowestHandshakeTime) {
                    lowestHandshakeTime = handshakeTime;
                    if (handshakePeers != null) {
                        handshakePeers.clear();
                    } else {
                        handshakePeers = new ArrayList<PeerNode>();
                    }
                }
                if (handshakeTime <= lowestHandshakeTime) {
                    handshakePeers.add(pn);
                }
            }
            if ((tempNow = System.currentTimeMillis()) - oldTempNow > TimeUnit.SECONDS.toMillis(5L)) {
                Logger.error(this, "tempNow is more than 5 seconds past oldTempNow (" + (tempNow - oldTempNow) + ") in PacketSender working with " + pn.userToString());
            }
            oldTempNow = tempNow;
        }
        PeerNode toSendPacket = null;
        PeerNode toSendAckOnly = null;
        PeerNode toSendHandshake = null;
        long t = Long.MAX_VALUE;
        if (lowestUrgentSendTime <= now) {
            toSendPacket = (PeerNode)urgentSendPeers.get(this.localRandom.nextInt(urgentSendPeers.size()));
            t = lowestUrgentSendTime;
        } else if (lowestFullPacketSendTime < Long.MAX_VALUE) {
            toSendPacket = (PeerNode)urgentFullPacketPeers.get(this.localRandom.nextInt(urgentFullPacketPeers.size()));
            t = lowestFullPacketSendTime;
        } else if (lowestAckTime <= now) {
            toSendAckOnly = (PeerNode)ackPeers.get(this.localRandom.nextInt(ackPeers.size()));
            t = lowestAckTime;
        }
        if (lowestHandshakeTime <= now && t > lowestHandshakeTime) {
            toSendHandshake = (PeerNode)handshakePeers.get(this.localRandom.nextInt(handshakePeers.size()));
            toSendPacket = null;
            toSendAckOnly = null;
        }
        if (toSendPacket != null) {
            try {
                if (toSendPacket.maybeSendPacket(now, false)) {
                    nextActionTime = now;
                }
            }
            catch (BlockedTooLongException e) {
                Logger.error(this, "Waited too long: " + TimeUtil.formatTime(e.delta) + " to allocate a packet number to send to " + toSendPacket + " : " + "(new packet format)" + " (version " + toSendPacket.getVersionNumber() + ") - DISCONNECTING!");
                toSendPacket.forceDisconnect();
            }
        } else if (toSendAckOnly != null) {
            try {
                if (toSendAckOnly.maybeSendPacket(now, true)) {
                    nextActionTime = now;
                }
            }
            catch (BlockedTooLongException e) {
                Logger.error(this, "Waited too long: " + TimeUtil.formatTime(e.delta) + " to allocate a packet number to send to " + toSendAckOnly + " : " + "(new packet format)" + " (version " + toSendAckOnly.getVersionNumber() + ") - DISCONNECTING!");
                toSendAckOnly.forceDisconnect();
            }
        }
        if (toSendHandshake != null) {
            long beforeHandshakeTime = System.currentTimeMillis();
            toSendHandshake.getOutgoingMangler().sendHandshake(toSendHandshake, false);
            long afterHandshakeTime = System.currentTimeMillis();
            if (afterHandshakeTime - beforeHandshakeTime > TimeUnit.SECONDS.toMillis(2L)) {
                Logger.error(this, "afterHandshakeTime is more than 2 seconds past beforeHandshakeTime (" + (afterHandshakeTime - beforeHandshakeTime) + ") in PacketSender working with " + toSendHandshake.userToString());
            }
        }
        nextActionTime = Math.min(nextActionTime, lowestUrgentSendTime);
        nextActionTime = Math.min(nextActionTime, lowestFullPacketSendTime);
        nextActionTime = Math.min(nextActionTime, lowestAckTime);
        nextActionTime = Math.min(nextActionTime, lowestHandshakeTime);
        OpennetManager om = this.node.getOpennet();
        if (om != null && this.node.getUptime() > TimeUnit.SECONDS.toMillis(30L)) {
            OpennetPeerNode[] peers;
            for (OpennetPeerNode opennetPeerNode : peers = om.getOldPeers()) {
                long lastConnected = opennetPeerNode.timeLastConnected(now);
                if (lastConnected <= 0L) {
                    Logger.error(this, "Last connected is zero or negative for old-opennet-peer " + opennetPeerNode);
                }
                if (now - lastConnected > OpennetManager.MAX_TIME_ON_OLD_OPENNET_PEERS) {
                    om.purgeOldOpennetPeer(opennetPeerNode);
                    if (!logMINOR) continue;
                    Logger.minor(this, "Removing old opennet peer (too old): " + opennetPeerNode + " age is " + TimeUtil.formatTime(now - lastConnected));
                    continue;
                }
                if (opennetPeerNode.isConnected()) continue;
                if (opennetPeerNode.noContactDetails()) {
                    opennetPeerNode.startARKFetcher();
                    continue;
                }
                if (!opennetPeerNode.shouldSendHandshake()) continue;
                long beforeHandshakeTime = System.currentTimeMillis();
                opennetPeerNode.getOutgoingMangler().sendHandshake(opennetPeerNode, true);
                long afterHandshakeTime = System.currentTimeMillis();
                if (afterHandshakeTime - beforeHandshakeTime <= TimeUnit.SECONDS.toMillis(2L)) continue;
                Logger.error(this, "afterHandshakeTime is more than 2 seconds past beforeHandshakeTime (" + (afterHandshakeTime - beforeHandshakeTime) + ") in PacketSender working with " + opennetPeerNode.userToString());
            }
        }
        long oldNow = now;
        now = System.currentTimeMillis();
        if (now - oldNow > TimeUnit.SECONDS.toMillis(10L)) {
            Logger.error(this, "now is more than 10 seconds past oldNow (" + (now - oldNow) + ") in PacketSender");
        }
        long sleepTime = nextActionTime - now;
        sleepTime = Math.min(sleepTime, MAX_COALESCING_DELAY);
        if (now - this.node.startupTime > TimeUnit.MINUTES.toMillis(5L) && now - this.lastReceivedPacketFromAnyNode > Node.ALARM_TIME) {
            Logger.error(this, "Have not received any packets from any node in last " + TimeUnit.SECONDS.convert(Node.ALARM_TIME, TimeUnit.MILLISECONDS) + " seconds");
            this.lastReportedNoPackets = now;
        }
        if (sleepTime > 0L) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Sleeping for " + sleepTime);
                }
                PacketSender packetSender = this;
                synchronized (packetSender) {
                    this.wait(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (logDEBUG) {
            Logger.debug(this, "Next urgent time is " + (now - nextActionTime) + "ms in the past");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp() {
        PacketSender packetSender = this;
        synchronized (packetSender) {
            this.notifyAll();
        }
    }

    protected String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("PacketSender." + key, patterns, values);
    }

    protected String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("PacketSender." + key, pattern, value);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        MAX_COALESCING_DELAY = TimeUnit.MILLISECONDS.toMillis(100L);
        MAX_COALESCING_DELAY_BULK = TimeUnit.SECONDS.toMillis(5L);
        MIN_OLD_OPENNET_CONNECT_DELAY_NO_CONNS = TimeUnit.SECONDS.toMillis(10L);
        MIN_OLD_OPENNET_CONNECT_DELAY = TimeUnit.SECONDS.toMillis(60L);
    }
}

