/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.ProgramDirectory;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.io.Closer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public class UptimeEstimator
implements Runnable {
    static final long PERIOD = TimeUnit.MINUTES.toMillis(5L);
    Ticker ticker;
    private boolean[] wasOnline = new boolean[576];
    private boolean[] wasOnlineWeek = new boolean[2016];
    private int slot;
    private File logFile;
    private File prevFile;
    private long timeOffset;

    public UptimeEstimator(ProgramDirectory runDir, Ticker ticker, byte[] bs) {
        this.ticker = ticker;
        this.logFile = runDir.file("uptime.dat");
        this.prevFile = runDir.file("uptime.old.dat");
        this.timeOffset = (int)((double)Math.abs(Fields.hashCode(bs, bs.length / 2, bs.length - bs.length / 2)) / 2.147483647E9 * (double)PERIOD);
    }

    public void start() {
        long now = System.currentTimeMillis();
        int fiveMinutesSinceEpoch = (int)(now / PERIOD);
        int base = fiveMinutesSinceEpoch - this.wasOnlineWeek.length;
        this.readData(this.prevFile, base);
        this.readData(this.logFile, base);
        this.schedule(System.currentTimeMillis());
        System.out.println("Created uptime estimator, time offset is " + this.timeOffset + " uptime at startup is " + new DecimalFormat("0.00").format(this.getUptime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData(File file, int base) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(fis);
            try {
                while (true) {
                    int offset;
                    if ((offset = dis.readInt()) < base) {
                        continue;
                    }
                    int slotNo = offset - base;
                    if (slotNo == this.wasOnlineWeek.length) {
                        break;
                    }
                    if (slotNo > this.wasOnlineWeek.length || slotNo < 0) {
                        Logger.error(this, "Corrupt data read from uptime file " + file + ": 5-minutes-from-epoch is now " + (base + this.wasOnlineWeek.length) + " but read " + slotNo);
                        break;
                    }
                    this.wasOnlineWeek[slotNo] = true;
                    this.wasOnline[slotNo % this.wasOnline.length] = true;
                }
            }
            catch (EOFException e) {
            }
            finally {
                Closer.close(dis);
            }
        }
        catch (IOException e) {
            try {
                Logger.error(this, "Unable to read old uptime file: " + file + " - we will assume we weren't online during that period");
            }
            catch (Throwable throwable) {
                Closer.close(fis);
                throw throwable;
            }
            Closer.close(fis);
        }
        Closer.close(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        UptimeEstimator uptimeEstimator = this;
        synchronized (uptimeEstimator) {
            this.wasOnlineWeek[this.slot] = true;
            this.wasOnline[this.slot % this.wasOnline.length] = true;
            this.slot = (this.slot + 1) % this.wasOnlineWeek.length;
        }
        long now = System.currentTimeMillis();
        if (this.logFile.length() > (long)this.wasOnlineWeek.length * 4L) {
            this.prevFile.delete();
            this.logFile.renameTo(this.prevFile);
        }
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        int fiveMinutesSinceEpoch = (int)(now / PERIOD);
        try {
            fos = new FileOutputStream(this.logFile, true);
            dos = new DataOutputStream(fos);
            dos.writeInt(fiveMinutesSinceEpoch);
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Unable to create or access " + this.logFile + " : " + e, (Throwable)e);
            Closer.close(dos);
            Closer.close(fos);
            this.schedule(now);
        }
        catch (IOException e2) {
            Logger.error(this, "Unable to write to uptime estimator log file: " + this.logFile);
            {
                catch (Throwable throwable) {
                    Closer.close(dos);
                    Closer.close(fos);
                    this.schedule(now);
                    throw throwable;
                }
            }
            Closer.close(dos);
            Closer.close(fos);
            this.schedule(now);
        }
        Closer.close(dos);
        Closer.close(fos);
        this.schedule(now);
    }

    private void schedule(long now) {
        long nextTime = now / PERIOD * PERIOD + this.timeOffset;
        if (nextTime < now) {
            nextTime += PERIOD;
        }
        this.ticker.queueTimedJob(this, nextTime - System.currentTimeMillis());
    }

    private synchronized double getUptime(boolean[] uptime) {
        int upCount = 0;
        for (boolean sample : uptime) {
            if (!sample) continue;
            ++upCount;
        }
        return (double)upCount / (double)uptime.length;
    }

    public synchronized double getUptime() {
        return this.getUptime(this.wasOnline);
    }

    public synchronized double getUptimeWeek() {
        return this.getUptime(this.wasOnlineWeek);
    }
}

