/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.PersistentRequestRoot;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPPersistentRoot;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.List;

public class FCPClient {
    final FCPPersistentRoot root;
    final String name;
    private final List<ClientRequest> runningPersistentRequests;
    private final List<ClientRequest> completedUnackedRequests;
    public final boolean isGlobalQueue;
    boolean watchGlobal;
    int watchGlobalVerbosityMask;
    private RequestClient lowLevelClient;
    private RequestClient lowLevelClientRT;
    final short persistenceType;
    private static volatile boolean logMINOR;

    private FCPClient() {
        throw new UnsupportedOperationException();
    }

    public boolean migrate(PersistentRequestRoot newRoot, ObjectContainer container, NodeClientCore core, ClientContext context) {
        int migrated = 0;
        int failed = 0;
        try {
            freenet.clients.fcp.ClientRequest request;
            PersistentRequestClient newClient;
            if (this.isGlobalQueue) {
                newClient = newRoot.getGlobalForeverClient();
                Logger.error(this, "Migrating global queue");
            } else {
                newClient = newRoot.registerForeverClient(this.name, null);
                Logger.error(this, "Migrating client \"" + this.name + "\"");
            }
            container.activate(this.runningPersistentRequests, 2);
            for (ClientRequest req : this.runningPersistentRequests) {
                if (req == null) continue;
                try {
                    request = req.migrate(newClient, container, core);
                    if (request == null) {
                        ++failed;
                        continue;
                    }
                    newClient.register(request);
                    request.start(context);
                    ++migrated;
                }
                catch (Throwable t) {
                    Logger.error(this, "Unable to migrate request: " + t, t);
                    ++failed;
                }
            }
            container.activate(this.completedUnackedRequests, 2);
            for (ClientRequest req : this.completedUnackedRequests) {
                if (req == null) continue;
                try {
                    request = req.migrate(newClient, container, core);
                    if (request == null) {
                        ++failed;
                        continue;
                    }
                    newClient.register(request);
                    request.start(context);
                    ++migrated;
                }
                catch (Throwable t) {
                    Logger.error(this, "Unable to migrate request: " + t, t);
                    ++failed;
                }
            }
            if (failed == 0) {
                if (migrated > 0) {
                    System.out.println("Migrated " + migrated + " requests successfully");
                    Logger.normal(this, "Migrated " + migrated + " requests successfully");
                }
                return true;
            }
            if (migrated > 0) {
                Logger.error(this, "Migrated " + migrated + " requests");
                System.out.println("Migrated " + migrated + " requests");
            }
            if (failed > 0) {
                Logger.error(this, "Failed to migrate " + failed + " requests");
                System.out.println("Failed to migrate " + failed + " requests");
            }
            return false;
        }
        catch (Throwable t) {
            Logger.error(this, "Unable to migrate client: " + t, t);
            return false;
        }
    }

    public String toString() {
        return super.toString() + ':' + this.name;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

