/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.RandomSource;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.Announcer;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.OpennetDisabledException;
import freenet.node.SeedServerPeerNode;
import freenet.node.SeedServerTestPeerNode;
import freenet.node.simulator.RealNodeTest;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SeednodePingTest
extends RealNodeTest {
    static File STATUS_DIR = new File("/var/www/freenet/tests/seednodes/status/");
    static final long COUNT_SUCCESSES_PERIOD = TimeUnit.DAYS.toMillis(7L);
    static final int DARKNET_PORT = 5045;
    static final int OPENNET_PORT = 5046;

    public static void main(String[] args) throws FSParseException, IOException, OpennetDisabledException, PeerParseException, InterruptedException, ReferenceSignatureVerificationException, NodeInitException, LoggerHook.InvalidThresholdException {
        Node node = null;
        try {
            if (args.length == 1) {
                STATUS_DIR = new File(args[0]);
            }
            RandomSource random = NodeStarter.globalTestInit("seednode-pingtest", false, Logger.LogLevel.ERROR, "", false);
            PooledExecutor executor = new PooledExecutor();
            node = NodeStarter.createTestNode(5045, 5046, "seednode-pingtest", false, (short)18, 0, random, executor, 1000, 0x500000L, true, false, false, false, false, false, false, 0, false, false, false, false, null);
            ArrayList<SeedServerTestPeerNode> seedNodes = new ArrayList<SeedServerTestPeerNode>();
            List<SimpleFieldSet> seedNodesAsSFS = Announcer.readSeednodes(new File("/tmp/", "seednodes.fref"));
            int numberOfNodesInTheFile = 0;
            for (SimpleFieldSet sfs : seedNodesAsSFS) {
                ++numberOfNodesInTheFile;
                SeedServerTestPeerNode seednode = node.createNewSeedServerTestPeerNode(sfs);
                try {
                    node.connectToSeednode(seednode);
                    seedNodes.add(seednode);
                }
                catch (Exception fse) {
                    System.err.println("ERROR adding " + seednode.toString() + " " + fse.getMessage());
                }
            }
            node.start(true);
            Logger.getChain().setThreshold(Logger.LogLevel.ERROR);
            Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
            if (seedNodes.size() != numberOfNodesInTheFile) {
                System.out.println("ERROR ADDING SOME OF THE SEEDNODES!!");
            }
            System.out.println("Let some time for the " + seedNodes.size() + " nodes to connect...");
            Thread.sleep(TimeUnit.SECONDS.toMillis(8L));
            int pingID = 0;
            long deadline = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(2L);
            while (System.currentTimeMillis() < deadline) {
                int countConnectedSeednodes = 0;
                for (SeedServerPeerNode seedServerPeerNode : node.peers.getConnectedSeedServerPeersVector(null)) {
                    try {
                        boolean ping;
                        double d = seedServerPeerNode.averagePingTime();
                        short uptime = seedServerPeerNode.getUptime();
                        long timeDelta = seedServerPeerNode.getClockDelta();
                        if (seedServerPeerNode.isRealConnection()) continue;
                        ++countConnectedSeednodes;
                        if (ping = seedServerPeerNode.ping(pingID++)) {
                            System.out.println(seedServerPeerNode.getIdentityString() + " uptime=" + uptime + " ping=" + ping + " pingTime=" + d + " uptime=" + seedServerPeerNode.getUptime() + " timeDelta=" + TimeUtil.formatTime(timeDelta));
                        }
                        if (!seedServerPeerNode.isRoutable()) continue;
                        System.out.println(seedServerPeerNode + " is routable!");
                    }
                    catch (NotConnectedException notConnectedException) {
                        System.out.println(seedServerPeerNode.getIdentityString() + " is not connected " + seedServerPeerNode.getHandshakeCount());
                    }
                }
                EnumMap<SeedServerTestPeerNode.FATE, Integer> totals = new EnumMap<SeedServerTestPeerNode.FATE, Integer>(SeedServerTestPeerNode.FATE.class);
                for (SeedServerTestPeerNode seedServerTestPeerNode : seedNodes) {
                    SeedServerTestPeerNode.FATE fate = seedServerTestPeerNode.getFate();
                    Integer x = (Integer)totals.get((Object)fate);
                    if (x == null) {
                        totals.put(fate, 1);
                    } else {
                        totals.put(fate, x + 1);
                    }
                    System.out.println(seedServerTestPeerNode.getIdentityString() + " : " + (Object)((Object)fate) + " : " + seedServerTestPeerNode.getPeerNodeStatusString());
                }
                System.out.println("TOTALS:");
                for (Map.Entry entry : totals.entrySet()) {
                    System.out.println(entry.getKey() + " : " + entry.getValue());
                }
                System.out.println("################## (" + node.peers.countConnectedPeers() + ") " + countConnectedSeednodes + '/' + node.peers.countSeednodes());
                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            }
            EnumMap<SeedServerTestPeerNode.FATE, Integer> totals = new EnumMap<SeedServerTestPeerNode.FATE, Integer>(SeedServerTestPeerNode.FATE.class);
            for (SeedServerTestPeerNode seedServerTestPeerNode : seedNodes) {
                SeedServerTestPeerNode.FATE fATE = seedServerTestPeerNode.getFate();
                Integer x = (Integer)totals.get((Object)fATE);
                if (x == null) {
                    totals.put(fATE, 1);
                } else {
                    totals.put(fATE, x + 1);
                }
                System.out.println(seedServerTestPeerNode.getIdentityString() + " : " + (Object)((Object)fATE) + " : " + seedServerTestPeerNode.getPeerNodeStatusString());
            }
            System.out.println("RESULT:TOTALS:");
            for (SeedServerTestPeerNode.FATE fATE : totals.keySet()) {
                System.out.println("RESULT:" + (Object)((Object)fATE) + " : " + totals.get((Object)fATE));
            }
            System.out.println("Completed seednodes scan.");
            System.out.println("FINAL STATUS:");
            long writeTime = System.currentTimeMillis();
            for (SeedServerTestPeerNode peer : seedNodes) {
                String line;
                String status = writeTime + " : " + peer.getIdentityString() + " : " + (Object)((Object)peer.getFate());
                System.out.println(status);
                File logFile = new File(STATUS_DIR, peer.getIdentityString());
                FileOutputStream fos = new FileOutputStream(logFile, true);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.write(status + "\n");
                osw.close();
                FileInputStream fis = new FileInputStream(logFile);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                int successes = 0;
                int failures = 0;
                long lastSuccess = 0L;
                long firstSample = 0L;
                long countSince = writeTime - COUNT_SUCCESSES_PERIOD;
                while ((line = br.readLine()) != null) {
                    String[] results = line.split(" : ");
                    if (results.length != 3) {
                        System.err.println("Unable to parse line in " + logFile + " : wrong number of fields : " + results.length + " : " + line);
                    } else {
                        long time = Long.parseLong(results[0]);
                        SeedServerTestPeerNode.FATE fate = SeedServerTestPeerNode.FATE.valueOf(results[2]);
                        if (firstSample == 0L) {
                            firstSample = time;
                        }
                        if (fate == SeedServerTestPeerNode.FATE.CONNECTED_SUCCESS) {
                            if (time >= countSince) {
                                ++successes;
                            }
                            lastSuccess = time;
                        } else if (time >= countSince) {
                            ++failures;
                        }
                    }
                    if (line != null) continue;
                }
                br.close();
                if (firstSample < countSince && successes == 0) {
                    System.err.println("RESULT:" + peer.getIdentityString() + " NOT CONNECTED IN LAST WEEK! LAST CONNECTED: " + (lastSuccess > 0L ? TimeUtil.formatTime(writeTime - lastSuccess) : "NEVER"));
                }
                System.out.println(peer.getIdentityString() + " : last success " + (lastSuccess > 0L ? TimeUtil.formatTime(writeTime - lastSuccess) : "NEVER") + " failures in last week: " + failures + " successes in last week: " + successes);
            }
            node.park();
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("CAUGHT: " + t);
            t.printStackTrace();
            try {
                if (node != null) {
                    node.park();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(1);
        }
    }
}

