/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.stats;

import freenet.node.stats.StatsNotAvailableException;

public abstract class StoreAccessStats {
    public abstract long hits();

    public abstract long misses();

    public abstract long falsePos();

    public abstract long writes();

    public long readRequests() {
        return this.hits() + this.misses();
    }

    public long successfulReads() {
        if (this.readRequests() > 0L) {
            return this.hits();
        }
        return 0L;
    }

    public double successRate() throws StatsNotAvailableException {
        if (this.readRequests() > 0L) {
            return 100.0 * (double)this.hits() / (double)this.readRequests();
        }
        throw new StatsNotAvailableException();
    }

    public double accessRate(long nodeUptimeSeconds) {
        return 1.0 * (double)this.readRequests() / (double)nodeUptimeSeconds;
    }

    public double writeRate(long nodeUptimeSeconds) {
        return 1.0 * (double)this.writes() / (double)nodeUptimeSeconds;
    }
}

