/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.io.WritableToDataOutputStream;
import freenet.support.Fields;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class BitArray
implements WritableToDataOutputStream {
    public static final String VERSION = "$Id: BitArray.java,v 1.2 2005/08/25 17:28:19 amphibian Exp $";
    private int _size;
    private byte[] _bits;

    public BitArray(byte[] data) {
        this._bits = data;
        this._size = data.length * 8;
    }

    public BitArray copy() {
        return new BitArray(this);
    }

    public BitArray(DataInput dis) throws IOException {
        this._size = dis.readInt();
        this._bits = new byte[(this._size + 7) / 8];
        dis.readFully(this._bits);
    }

    public BitArray(DataInput dis, int maxSize) throws IOException {
        this._size = dis.readInt();
        if (this._size <= 0 || this._size > maxSize) {
            throw new IOException("Unacceptable bitarray size: " + this._size);
        }
        this._bits = new byte[(this._size + 7) / 8];
        dis.readFully(this._bits);
    }

    public BitArray(int size) {
        this._size = size;
        this._bits = new byte[(size + 7) / 8];
    }

    public BitArray(BitArray src) {
        this._size = src._size;
        this._bits = (byte[])src._bits.clone();
    }

    public void setBit(int pos, boolean f) {
        if (pos > this._size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int b = BitArray.unsignedByteToInt(this._bits[pos / 8]);
        int mask = 1 << pos % 8;
        this._bits[pos / 8] = f ? (byte)(b | mask) : (byte)(b & ~mask);
    }

    public boolean bitAt(int pos) {
        int mask;
        if (pos > this._size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int b = BitArray.unsignedByteToInt(this._bits[pos / 8]);
        return (b & (mask = 1 << pos % 8)) != 0;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._size);
        for (int x = 0; x < this._size; ++x) {
            if (this.bitAt(x)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }

    @Override
    public void writeToDataOutputStream(DataOutputStream dos) throws IOException {
        dos.writeInt(this._size);
        dos.write(this._bits);
    }

    public static int serializedLength(int size) {
        return (size + 7) / 8 + 4;
    }

    public int getSize() {
        return this._size;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitArray)) {
            return false;
        }
        BitArray ba = (BitArray)o;
        if (ba.getSize() != this.getSize()) {
            return false;
        }
        for (int x = 0; x < this.getSize(); ++x) {
            if (ba.bitAt(x) == this.bitAt(x)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Fields.hashCode(this._bits);
    }

    public void setAllOnes() {
        for (int i = 0; i < this._bits.length; ++i) {
            this._bits[i] = -1;
        }
    }

    public int firstOne(int start) {
        int startByte = start / 8;
        int startBit = start % 8;
        for (int i = startByte; i < this._bits.length; ++i) {
            byte b = this._bits[i];
            if (b == 0) continue;
            for (int j = startBit; j < 8; ++j) {
                int mask = 1 << j;
                if ((b & mask) == 0) continue;
                int x = i * 8 + j;
                if (x >= this._size) {
                    return -1;
                }
                return x;
            }
            startBit = 0;
        }
        return -1;
    }

    public int firstOne() {
        return this.firstOne(0);
    }

    public int firstZero(int start) {
        int startByte = start / 8;
        int startBit = start % 8;
        for (int i = startByte; i < this._bits.length; ++i) {
            byte b = this._bits[i];
            if (b == -1) continue;
            for (int j = startBit; j < 8; ++j) {
                int mask = 1 << j;
                if ((b & mask) != 0) continue;
                int x = i * 8 + j;
                if (x >= this._size) {
                    return -1;
                }
                return x;
            }
            startBit = 0;
        }
        return -1;
    }

    public void setSize(int size) {
        if (this._size == size) {
            return;
        }
        int oldSize = this._size;
        this._size = size;
        int bytes = (size + 7) / 8;
        if (this._bits.length != bytes) {
            this._bits = Arrays.copyOf(this._bits, bytes);
        }
        if (oldSize < this._size && oldSize % 8 != 0) {
            for (int i = oldSize; i < Math.min(this._size, oldSize - oldSize % 8 + 8); ++i) {
                this.setBit(i, false);
            }
        }
    }

    public int lastOne(int start) {
        if (start >= this._size) {
            start = this._size - 1;
        }
        int startByte = start / 8;
        int startBit = start % 8;
        if (startByte >= this._bits.length) {
            System.err.println("Start byte is " + startByte + " _bits.length is " + this._bits.length);
            assert (false);
        }
        for (int i = startByte; i >= 0; --i) {
            byte b = this._bits[i];
            if (b != 0) {
                for (int j = startBit; j >= 0; --j) {
                    int mask = 1 << j;
                    if ((b & mask) == 0) continue;
                    int x = i * 8 + j;
                    return x;
                }
            }
            startBit = 7;
        }
        return -1;
    }
}

