/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class SparseBitmap
implements Iterable<int[]> {
    private final TreeSet<Range> ranges = new TreeSet<Range>(new RangeComparator());

    public SparseBitmap() {
    }

    public SparseBitmap(SparseBitmap original) {
        for (int[] range : original) {
            this.add(range[0], range[1]);
        }
    }

    public void add(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Tried adding bad range. Start: " + start + ", end: " + end);
        }
        Iterator<Range> it = this.ranges.iterator();
        while (it.hasNext()) {
            Range range = it.next();
            if (range.start <= start && range.end >= end) {
                return;
            }
            if ((range.start > start || range.end < start - 1) && (range.start > end + 1 || range.end < end)) continue;
            it.remove();
            start = Math.min(start, range.start);
            end = Math.max(end, range.end);
        }
        this.ranges.add(new Range(start, end));
    }

    public void clear() {
        this.ranges.clear();
    }

    public boolean contains(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Tried checking bad range. Start: " + start + ", end: " + end);
        }
        for (Range r : this.ranges) {
            if (r.start > r.end) {
                Logger.error(this, "Bad Range: " + r);
            }
            if (r.start > start || r.end < end) continue;
            return true;
        }
        return false;
    }

    public void remove(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Removing bad range. Start: " + start + ", end: " + end);
        }
        ArrayList<Range> toAdd = new ArrayList<Range>();
        Iterator<Range> it = this.ranges.iterator();
        while (it.hasNext()) {
            Range range = it.next();
            if (range.start < start) {
                if (range.end < start) continue;
                if (range.end <= end) {
                    toAdd.add(new Range(range.start, start - 1));
                } else {
                    toAdd.add(new Range(range.start, start - 1));
                    toAdd.add(new Range(end + 1, range.end));
                }
            } else {
                if (range.start < start || range.start > end) continue;
                if (range.end > end) {
                    toAdd.add(new Range(end + 1, range.end));
                }
            }
            it.remove();
        }
        this.ranges.addAll(toAdd);
    }

    @Override
    public Iterator<int[]> iterator() {
        return new SparseBitmapIterator(this);
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int[] range : this) {
            if (s.length() != 0) {
                s.append(", ");
            }
            s.append(range[0] + "->" + range[1]);
        }
        return s.toString();
    }

    public int notOverlapping(int start, int end) {
        int total = 0;
        for (int i = start; i <= end; ++i) {
            if (this.contains(i, i)) continue;
            ++total;
        }
        return total;
    }

    private static class RangeComparator
    implements Comparator<Range> {
        private RangeComparator() {
        }

        @Override
        public int compare(Range r1, Range r2) {
            return r1.start - r2.start;
        }
    }

    private static class Range {
        int start;
        int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "Range:" + this.start + "->" + this.end;
        }
    }

    private static class SparseBitmapIterator
    implements Iterator<int[]> {
        Iterator<Range> it;

        public SparseBitmapIterator(SparseBitmap map) {
            this.it = map.ranges.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public int[] next() {
            Range r = this.it.next();
            return new int[]{r.start, r.end};
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

