/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.MasterSecret;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class PaddedRandomAccessBuffer
implements LockableRandomAccessBuffer,
Serializable {
    private static final long serialVersionUID = 1L;
    final LockableRandomAccessBuffer raf;
    final long realSize;
    static final int MAGIC = 514519856;

    public PaddedRandomAccessBuffer(LockableRandomAccessBuffer raf, long realSize) {
        this.raf = raf;
        this.realSize = realSize;
    }

    @Override
    public long size() {
        return this.realSize;
    }

    @Override
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.realSize) {
            throw new IOException("Length limit exceeded");
        }
        this.raf.pread(fileOffset, buf, bufOffset, length);
    }

    @Override
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.realSize) {
            throw new IOException("Length limit exceeded");
        }
        this.raf.pwrite(fileOffset, buf, bufOffset, length);
    }

    @Override
    public void close() {
        this.raf.close();
    }

    @Override
    public void free() {
        this.raf.free();
    }

    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() throws IOException {
        return this.raf.lockOpen();
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.raf.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(514519856);
        dos.writeLong(this.realSize);
        this.raf.storeTo(dos);
    }

    public PaddedRandomAccessBuffer(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterSecret) throws ResumeFailedException, IOException, StorageFormatException {
        this.realSize = dis.readLong();
        if (this.realSize < 0L) {
            throw new StorageFormatException("Negative length");
        }
        this.raf = BucketTools.restoreRAFFrom(dis, fg, persistentFileTracker, masterSecret);
        if (this.realSize > this.raf.size()) {
            throw new ResumeFailedException("Padded file is smaller than expected length");
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.raf).hashCode();
        result = 31 * result + (int)(this.realSize ^ this.realSize >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaddedRandomAccessBuffer other = (PaddedRandomAccessBuffer)obj;
        if (!((Object)this.raf).equals(other.raf)) {
            return false;
        }
        return this.realSize == other.realSize;
    }
}

