/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.CPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.Random;

public class NativeBigInteger
extends BigInteger {
    private static boolean _nativeOk = false;
    private static final boolean _doLog = true;
    private static final String JBIGI_OPTIMIZATION_ARM = "arm";
    private static final String JBIGI_OPTIMIZATION_K6 = "k6";
    private static final String JBIGI_OPTIMIZATION_K6_2 = "k62";
    private static final String JBIGI_OPTIMIZATION_K6_3 = "k63";
    private static final String JBIGI_OPTIMIZATION_ATHLON = "athlon";
    private static final String JBIGI_OPTIMIZATION_X86_64 = "x86_64";
    private static final String JBIGI_OPTIMIZATION_X86_64_32 = "x86_64_32";
    private static final String JBIGI_OPTIMIZATION_PENTIUM = "pentium";
    private static final String JBIGI_OPTIMIZATION_PENTIUMMMX = "pentiummmx";
    private static final String JBIGI_OPTIMIZATION_PENTIUM2 = "pentium2";
    private static final String JBIGI_OPTIMIZATION_PENTIUM3 = "pentium3";
    private static final String JBIGI_OPTIMIZATION_PENTIUM4 = "pentium4";
    private static final String JBIGI_OPTIMIZATION_PPC = "ppc";
    private static final String sCPUType = NativeBigInteger.resolveCPUType();
    private static final long serialVersionUID = -4235307143396835886L;
    private byte[] cachedBa = null;

    private static String resolveCPUType() {
        try {
            String _os_arch = System.getProperty("os.arch").toLowerCase();
            if (System.getProperty("os.arch").toLowerCase().matches("(i?[x0-9]86_64|amd64)") && System.getProperty("sun.arch.data.model").equals("64")) {
                return JBIGI_OPTIMIZATION_X86_64;
            }
            if (_os_arch.matches("(arm)")) {
                System.out.println("Detected ARM!");
                return JBIGI_OPTIMIZATION_ARM;
            }
            if (_os_arch.matches("(ppc)")) {
                System.out.println("Detected PowerPC!");
                return JBIGI_OPTIMIZATION_PPC;
            }
            CPUInfo c = CPUID.getInfo();
            if (c instanceof AMDCPUInfo) {
                AMDCPUInfo amdcpu = (AMDCPUInfo)c;
                if (amdcpu.IsAthlon64Compatible()) {
                    return JBIGI_OPTIMIZATION_X86_64_32;
                }
                if (amdcpu.IsAthlonCompatible()) {
                    return JBIGI_OPTIMIZATION_ATHLON;
                }
                if (amdcpu.IsK6_3_Compatible()) {
                    return JBIGI_OPTIMIZATION_K6_3;
                }
                if (amdcpu.IsK6_2_Compatible()) {
                    return JBIGI_OPTIMIZATION_K6_2;
                }
                if (amdcpu.IsK6Compatible()) {
                    return JBIGI_OPTIMIZATION_K6;
                }
            } else if (c instanceof IntelCPUInfo) {
                IntelCPUInfo intelcpu = (IntelCPUInfo)c;
                if (intelcpu.IsPentium4Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM4;
                }
                if (intelcpu.IsPentium3Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM3;
                }
                if (intelcpu.IsPentium2Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM2;
                }
                if (intelcpu.IsPentiumMMXCompatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUMMMX;
                }
                if (intelcpu.IsPentiumCompatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM;
                }
            }
            return null;
        }
        catch (UnknownCPUException e) {
            return null;
        }
    }

    public static native byte[] nativeModPow(byte[] var0, byte[] var1, byte[] var2);

    public static native double nativeDoubleValue(byte[] var0);

    public NativeBigInteger(byte[] val) {
        super(val);
    }

    public NativeBigInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
    }

    public NativeBigInteger(int bitlen, int certainty, Random rnd) {
        super(bitlen, certainty, rnd);
    }

    public NativeBigInteger(int numbits, Random rnd) {
        super(numbits, rnd);
    }

    public NativeBigInteger(String val) {
        super(val);
    }

    public NativeBigInteger(String val, int radix) {
        super(val, radix);
    }

    public NativeBigInteger(BigInteger integer) {
        this(integer.toByteArray());
    }

    @Override
    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        if (_nativeOk) {
            return new NativeBigInteger(NativeBigInteger.nativeModPow(this.toByteArray(), exponent.toByteArray(), m.toByteArray()));
        }
        return new NativeBigInteger(super.modPow(exponent, m));
    }

    @Override
    public byte[] toByteArray() {
        if (this.cachedBa == null) {
            this.cachedBa = super.toByteArray();
        }
        return this.cachedBa;
    }

    @Override
    public double doubleValue() {
        if (_nativeOk) {
            return NativeBigInteger.nativeDoubleValue(this.toByteArray());
        }
        return super.doubleValue();
    }

    public static boolean isNative() {
        return _nativeOk;
    }

    private static void loadNative() {
        try {
            String wantedProp = System.getProperty("jbigi.enable", "true");
            boolean wantNative = "true".equalsIgnoreCase(wantedProp);
            if (wantNative) {
                boolean loaded = NativeBigInteger.loadFromResource(true);
                if (loaded) {
                    _nativeOk = true;
                    System.err.println("INFO: Optimized native BigInteger library '" + NativeBigInteger.getResourceName(true) + "' loaded from resource");
                } else {
                    loaded = NativeBigInteger.loadGeneric(true);
                    if (loaded) {
                        _nativeOk = true;
                        System.err.println("INFO: Optimized native BigInteger library '" + NativeBigInteger.getMiddleName(true) + "' loaded from somewhere in the path");
                    } else {
                        loaded = NativeBigInteger.loadFromResource(false);
                        if (loaded) {
                            _nativeOk = true;
                            System.err.println("INFO: Non-optimized native BigInteger library '" + NativeBigInteger.getResourceName(false) + "' loaded from resource");
                        } else {
                            loaded = NativeBigInteger.loadGeneric(false);
                            if (loaded) {
                                _nativeOk = true;
                                System.err.println("INFO: Non-optimized native BigInteger library '" + NativeBigInteger.getMiddleName(false) + "' loaded from somewhere in the path");
                            } else {
                                _nativeOk = false;
                            }
                        }
                    }
                }
            }
            if (!_nativeOk) {
                System.err.println("INFO: Native BigInteger library jbigi not loaded - using pure java");
            }
        }
        catch (Throwable e) {
            System.err.println("INFO: Native BigInteger library jbigi not loaded, reason: '" + e.getMessage() + "' - using pure java");
        }
    }

    private static boolean loadGeneric(boolean optimized) {
        try {
            String name = NativeBigInteger.getMiddleName(optimized);
            if (name == null) {
                return false;
            }
            System.loadLibrary(name);
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryLoadResource(File f, URL resource) throws FileNotFoundException, UnsatisfiedLinkError {
        InputStream is;
        try {
            is = resource.openStream();
        }
        catch (IOException e) {
            f.delete();
            throw new FileNotFoundException();
        }
        FileOutputStream fos = null;
        try {
            int read;
            f.deleteOnExit();
            fos = new FileOutputStream(f);
            byte[] buf = new byte[0x400000];
            while ((read = is.read(buf)) > 0) {
                fos.write(buf, 0, read);
            }
            fos.close();
            fos = null;
            System.load(f.getAbsolutePath());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        catch (UnsatisfiedLinkError ule) {
            if (ule.toString().toLowerCase().indexOf("not permitted") == -1) {
                throw ule;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            f.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadFromResource(boolean optimized) {
        String resourceName = NativeBigInteger.getResourceName(optimized);
        if (resourceName == null) {
            return false;
        }
        URL resource = NativeBigInteger.class.getClassLoader().getResource(resourceName);
        if (resource == null) {
            System.err.println("NOTICE: Resource name [" + NativeBigInteger.getResourceName(true) + "] was not found");
            return false;
        }
        File temp = null;
        try {
            try {
                temp = File.createTempFile("jbigi", "lib.tmp");
                if (NativeBigInteger.tryLoadResource(temp, resource)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
            }
            finally {
                if (temp != null) {
                    temp.delete();
                }
            }
            System.err.println("net.i2p.util.NativeBigInteger: Can't load from " + System.getProperty("java.io.tmpdir"));
            temp = new File("jbigi-lib.tmp");
            if (NativeBigInteger.tryLoadResource(temp, resource)) {
                boolean e = true;
                return e;
            }
        }
        catch (Exception fnf) {
            System.err.println("net.i2p.util.NativeBigInteger: Error reading jbigi resource");
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("net.i2p.util.NativeBigInteger: Library " + resourceName + " is not appropriate for this system.");
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
        return false;
    }

    private static String getResourceName(boolean optimized) {
        String name = NativeBigInteger.class.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        String pname = name.replace('.', '/');
        String pref = NativeBigInteger.getLibraryPrefix();
        String middle = NativeBigInteger.getMiddleName(optimized);
        String suff = NativeBigInteger.getLibrarySuffix();
        if (pref == null || middle == null || suff == null) {
            return null;
        }
        return pname + '/' + pref + middle + '.' + suff;
    }

    private static String getMiddleName(boolean optimized) {
        boolean isMacOS;
        String sAppend;
        if (optimized) {
            if (sCPUType == null) {
                return null;
            }
            sAppend = '-' + sCPUType;
        } else {
            sAppend = "-none";
        }
        boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
        boolean isFreebsd = System.getProperty("os.name").toLowerCase().indexOf("freebsd") != -1;
        boolean bl = isMacOS = System.getProperty("os.name").toLowerCase().indexOf("mac os x") != -1;
        if (isWindows) {
            return "jbigi-windows" + sAppend;
        }
        if (isLinux) {
            return "jbigi-linux" + sAppend;
        }
        if (isFreebsd) {
            return "jbigi-freebsd" + sAppend;
        }
        if (isMacOS) {
            return "jbigi-osx" + sAppend;
        }
        throw new RuntimeException("Dont know jbigi library name for os type '" + System.getProperty("os.name") + '\'');
    }

    private static String getLibrarySuffix() {
        boolean isMacOS;
        boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        boolean bl = isMacOS = System.getProperty("os.name").toLowerCase().indexOf("mac os x") != -1;
        if (isWindows) {
            return "dll";
        }
        if (isMacOS) {
            return "jnilib";
        }
        return "so";
    }

    private static String getLibraryPrefix() {
        boolean isWindows;
        boolean bl = isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        if (isWindows) {
            return "";
        }
        return "lib";
    }

    static {
        NativeBigInteger.loadNative();
    }
}

