/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class Uncompress {
    Uncompress() {
    }

    public static void gunzipFile(String from, String to) throws IllegalArgumentException, IOException {
        int bytes_read;
        byte[] buffer = new byte[4096];
        File fin = new File(from);
        if (!fin.exists()) {
            throw new IllegalArgumentException(from + " does not exist.");
        }
        if (!fin.canRead()) {
            throw new IllegalArgumentException(from + " read protected.");
        }
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(from));
        File fout = new File(to);
        if (fout.exists()) {
            throw new IllegalArgumentException("File '" + to + "' already exisits.");
        }
        FileOutputStream out = new FileOutputStream(to);
        while ((bytes_read = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytes_read);
        }
        in.close();
        out.close();
    }

    public static void unzipFile(String from, String to) throws IllegalArgumentException, IOException {
        ZipEntry entry;
        byte[] buffer = new byte[4096];
        File fin = new File(from);
        if (!fin.exists()) {
            throw new IllegalArgumentException(from + " does not exist.");
        }
        if (!fin.canRead()) {
            throw new IllegalArgumentException(from + " read protected.");
        }
        ZipInputStream in = new ZipInputStream(new FileInputStream(from));
        while ((entry = in.getNextEntry()) != null) {
            String toName = to + File.separator + entry.getName();
            File fout = new File(toName);
            if (fout.exists()) {
                System.err.println("File '" + toName + "' already exists.");
                continue;
            }
            if (entry.isDirectory()) {
                if (!fout.mkdirs()) {
                    System.err.println("Unable to create directory: " + toName);
                    System.exit(-1);
                }
            } else {
                int bytes_read;
                FileOutputStream out = new FileOutputStream(toName);
                while ((bytes_read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
                out.close();
            }
            System.out.println(toName);
        }
        in.close();
    }

    public static class Test {
        public static void main(String[] args) {
            String usage = "Usage: java Uncompress$Test <source> [<dest>]";
            String to = "";
            if (args.length != 1 && args.length != 2) {
                Test.fail("Usage: java Uncompress$Test <source> [<dest>]");
            }
            String from = args[0];
            try {
                if (args.length == 2) {
                    to = args[1];
                }
                if (from.substring(from.length() - 3, from.length()).equals(".gz")) {
                    if (to.equals("")) {
                        to = new String(from.substring(0, from.length() - 3));
                    }
                    Uncompress.gunzipFile(from, to);
                } else if (from.substring(from.length() - 4, from.length()).equals(".zip")) {
                    if (to.equals("")) {
                        to = new String(".");
                    }
                    Uncompress.unzipFile(from, to);
                } else {
                    Test.fail("Expecting .zip or .gz file extension.");
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
        }

        protected static void fail(String msg) throws IllegalArgumentException {
            throw new IllegalArgumentException(msg);
        }
    }
}

