/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tags;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.SafeRepresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Representer
extends SafeRepresenter {
    public Representer() {
        this.representers.put(null, new RepresentJavaBean());
    }

    protected Node representJavaBean(Set<Property> properties, Object javaBean) {
        ArrayList<NodeTuple> value = new ArrayList<NodeTuple>(properties.size());
        String customTag = (String)this.classTags.get(javaBean.getClass());
        String tag = customTag != null ? customTag : Tags.getGlobalTagForClass(javaBean.getClass());
        MappingNode node = new MappingNode(tag, value, null);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Property property : properties) {
            Node nodeValue;
            ScalarNode nodeKey = (ScalarNode)this.representData(property.getName());
            Object memberValue = property.get(javaBean);
            boolean hasAlias = false;
            if (this.representedObjects.containsKey(memberValue)) {
                hasAlias = true;
            }
            if ((nodeValue = this.representData(memberValue)) instanceof MappingNode && !hasAlias) {
                if (!Map.class.isAssignableFrom(memberValue.getClass()) && property.getType() == memberValue.getClass()) {
                    nodeValue.setTag("tag:yaml.org,2002:map");
                }
            } else if (memberValue != null && Enum.class.isAssignableFrom(memberValue.getClass())) {
                nodeValue.setTag("tag:yaml.org,2002:str");
            }
            if (nodeValue.getNodeId() != NodeId.scalar && !hasAlias) {
                this.checkGlobalTag(property, nodeValue, memberValue);
            }
            if (nodeKey.getStyle() != null) {
                bestStyle = false;
            }
            if (!(nodeValue instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value.add(new NodeTuple(nodeKey, nodeValue));
        }
        if (this.defaultFlowStyle != null) {
            node.setFlowStyle(this.defaultFlowStyle);
        } else {
            node.setFlowStyle(bestStyle);
        }
        return node;
    }

    protected void checkGlobalTag(Property property, Node node, Object object) {
        block3: {
            Type[] arguments;
            block5: {
                block4: {
                    arguments = property.getActualTypeArguments();
                    if (arguments == null) break block3;
                    if (node.getNodeId() != NodeId.sequence) break block4;
                    Class t = (Class)arguments[0];
                    SequenceNode snode = (SequenceNode)node;
                    List memberList = (List)object;
                    Iterator iter = memberList.iterator();
                    for (Node childNode : snode.getValue()) {
                        Object member = iter.next();
                        if (!t.equals(member.getClass()) || childNode.getNodeId() != NodeId.mapping) continue;
                        childNode.setTag("tag:yaml.org,2002:map");
                    }
                    break block3;
                }
                if (!(object instanceof Set)) break block5;
                Class t = (Class)arguments[0];
                MappingNode mnode = (MappingNode)node;
                Iterator<NodeTuple> iter = mnode.getValue().iterator();
                Set set = (Set)object;
                for (Object member : set) {
                    NodeTuple tuple = iter.next();
                    if (!t.equals(member.getClass()) || tuple.getKeyNode().getNodeId() != NodeId.mapping) continue;
                    tuple.getKeyNode().setTag("tag:yaml.org,2002:map");
                }
                break block3;
            }
            if (node.getNodeId() != NodeId.mapping) break block3;
            Class keyType = (Class)arguments[0];
            Class valueType = (Class)arguments[1];
            MappingNode mnode = (MappingNode)node;
            for (NodeTuple tuple : mnode.getValue()) {
                this.resetTag(keyType, tuple.getKeyNode());
                this.resetTag(valueType, tuple.getValueNode());
            }
        }
    }

    private void resetTag(Class<? extends Object> type, Node node) {
        String tag = node.getTag();
        if (Tags.getGlobalTagForClass(type).equals(tag)) {
            if (Enum.class.isAssignableFrom(type)) {
                node.setTag("tag:yaml.org,2002:str");
            } else {
                node.setTag("tag:yaml.org,2002:map");
            }
        }
    }

    protected Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
        TreeSet<Property> properties = new TreeSet<Property>();
        for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
            if (property.getReadMethod() == null || property.getReadMethod().getName().equals("getClass")) continue;
            properties.add(new MethodProperty(property));
        }
        for (Field field : type.getFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            properties.add(new FieldProperty(field));
        }
        if (properties.isEmpty()) {
            throw new YAMLException("No JavaBean properties found in " + type.getName());
        }
        return properties;
    }

    protected class RepresentJavaBean
    implements Represent {
        private final Map<Class<? extends Object>, Set<Property>> propertiesCache = new HashMap<Class<? extends Object>, Set<Property>>();

        protected RepresentJavaBean() {
        }

        public Node representData(Object data) {
            Class<?> clazz = data.getClass();
            Set<Property> properties = this.propertiesCache.get(clazz);
            if (properties == null) {
                try {
                    properties = Representer.this.getProperties(clazz);
                    this.propertiesCache.put(clazz, properties);
                }
                catch (IntrospectionException e) {
                    throw new YAMLException(e);
                }
            }
            Node node = Representer.this.representJavaBean(properties, data);
            return node;
        }
    }
}

