/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index;

import freenet.keys.FreenetURI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import plugins.Library.Library;
import plugins.Library.client.FreenetArchiver;
import plugins.Library.index.ProtoIndex;
import plugins.Library.index.TermEntry;
import plugins.Library.index.URIEntry;
import plugins.Library.index.URIKey;
import plugins.Library.io.DataFormatException;
import plugins.Library.io.YamlReaderWriter;
import plugins.Library.io.serial.Archiver;
import plugins.Library.io.serial.FileArchiver;
import plugins.Library.io.serial.IterableSerialiser;
import plugins.Library.io.serial.LiveArchiver;
import plugins.Library.io.serial.MapSerialiser;
import plugins.Library.io.serial.Packer;
import plugins.Library.io.serial.ParallelSerialiser;
import plugins.Library.io.serial.ProgressTracker;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.io.serial.Translator;
import plugins.Library.util.SkeletonBTreeMap;
import plugins.Library.util.SkeletonBTreeSet;
import plugins.Library.util.SkeletonTreeMap;
import plugins.Library.util.exec.BaseCompositeProgress;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.SimpleProgress;
import plugins.Library.util.exec.TaskAbortException;
import plugins.Library.util.exec.TaskInProgressException;

public class ProtoIndexComponentSerialiser {
    protected static final HashMap<Integer, ProtoIndexComponentSerialiser> srl_fmt = new HashMap();
    protected static final int FMT_FREENET_SIMPLE = 766757184;
    public static final int FMT_FILE_LOCAL = -734403942;
    public static final int FMT_DEFAULT = 766757184;
    protected static final YamlReaderWriter yamlrw = new YamlReaderWriter();
    protected static final Translator<SkeletonTreeMap<String, SkeletonBTreeSet<TermEntry>>, Map<String, Object>> ttab_keys_mtr = new TreeMapTranslator<String, SkeletonBTreeSet<TermEntry>>(null);
    protected static final Translator<SkeletonTreeMap<TermEntry, TermEntry>, Collection<TermEntry>> term_data_mtr = new SkeletonBTreeSet.TreeSetTranslator<TermEntry>();
    protected static final Translator<URIKey, String> utab_keys_ktr = new Translator<URIKey, String>(){

        @Override
        public String app(URIKey k) {
            return k.toString();
        }

        @Override
        public URIKey rev(String s) {
            return new URIKey(URIKey.hexToBytes(s));
        }
    };
    protected static final Translator<SkeletonTreeMap<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>>, Map<String, Object>> utab_keys_mtr = new TreeMapTranslator<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>>(utab_keys_ktr);
    protected static final MapSerialiser<TermEntry, TermEntry> term_dummy = new DummySerialiser<TermEntry, TermEntry>();
    protected static final MapSerialiser<FreenetURI, URIEntry> uri_dummy = new DummySerialiser<FreenetURI, URIEntry>();
    protected static final Packer.Scale<SkeletonBTreeSet<TermEntry>> term_data_scale = new Packer.Scale<SkeletonBTreeSet<TermEntry>>(){

        @Override
        public int weigh(SkeletonBTreeSet<TermEntry> element) {
            return element.sizeRoot();
        }
    };
    protected static final Packer.Scale<SkeletonBTreeMap<FreenetURI, URIEntry>> uri_data_scale = new Packer.Scale<SkeletonBTreeMap<FreenetURI, URIEntry>>(){

        @Override
        public int weigh(SkeletonBTreeMap<FreenetURI, URIEntry> element) {
            return element.sizeRoot();
        }
    };
    protected final int serialFormatUID;
    protected final LiveArchiver<Map<String, Object>, SimpleProgress> leaf_arx;
    protected final BTreePacker<String, SkeletonBTreeSet<TermEntry>, EntryGroupSerialiser<String, SkeletonBTreeSet<TermEntry>>> ttab_data;
    protected final BTreePacker<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>, EntryGroupSerialiser<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>>> utab_data;

    public static synchronized ProtoIndexComponentSerialiser get(int fmtid, LiveArchiver<Map<String, Object>, SimpleProgress> archiver) {
        ProtoIndexComponentSerialiser srl = srl_fmt.get(fmtid);
        if (srl == null || srl.leaf_arx != null && srl.leaf_arx != archiver) {
            srl = new ProtoIndexComponentSerialiser(fmtid, archiver);
            if (archiver == null) {
                srl_fmt.put(fmtid, srl);
            }
        }
        return srl;
    }

    public static ProtoIndexComponentSerialiser get() {
        return ProtoIndexComponentSerialiser.get(766757184, null);
    }

    public LiveArchiver<Map<String, Object>, SimpleProgress> getLeafSerialiser() {
        return this.leaf_arx;
    }

    protected ProtoIndexComponentSerialiser(int fmtid, LiveArchiver<Map<String, Object>, SimpleProgress> archiver) {
        if (archiver != null) {
            this.leaf_arx = archiver;
        } else {
            switch (fmtid) {
                case 766757184: {
                    short priorityClass = 1;
                    if (archiver instanceof FreenetArchiver) {
                        priorityClass = ((FreenetArchiver)archiver).priorityClass;
                    }
                    this.leaf_arx = Library.makeArchiver(yamlrw, "text/yaml", 384 * ProtoIndex.BTREE_NODE_MIN, priorityClass);
                    break;
                }
                case -734403942: {
                    this.leaf_arx = new FileArchiver<Map<String, Object>>(yamlrw, true, ".yml", "", "", null);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown serial format id");
                }
            }
        }
        this.serialFormatUID = fmtid;
        this.ttab_data = new BTreePacker(new EntryGroupSerialiser(this.leaf_arx, null, new SkeletonBTreeSet.TreeTranslator<TermEntry, TermEntry>(null, term_data_mtr){

            @Override
            public SkeletonBTreeSet<TermEntry> rev(Map<String, Object> tree) throws DataFormatException {
                return ProtoIndexComponentSerialiser.this.setSerialiserFor(super.rev(tree));
            }
        }), term_data_scale, ProtoIndex.BTREE_ENT_MAX);
        this.utab_data = new BTreePacker(new EntryGroupSerialiser(this.leaf_arx, null, new SkeletonBTreeMap.TreeTranslator<FreenetURI, URIEntry>(null, null){

            @Override
            public SkeletonBTreeMap<FreenetURI, URIEntry> rev(Map<String, Object> tree) throws DataFormatException {
                return ProtoIndexComponentSerialiser.this.setSerialiserFor(super.rev(tree));
            }
        }), uri_data_scale, ProtoIndex.BTREE_ENT_MAX);
    }

    public ProtoIndex setSerialiserFor(ProtoIndex index) {
        BTreeNodeSerialiser ttab_keys = new BTreeNodeSerialiser("term listings", this.leaf_arx, index.ttab.makeNodeTranslator(null, ttab_keys_mtr));
        index.ttab.setSerialiser(ttab_keys, this.ttab_data);
        BTreeNodeSerialiser utab_keys = new BTreeNodeSerialiser("uri listings", this.leaf_arx, index.utab.makeNodeTranslator(utab_keys_ktr, utab_keys_mtr));
        index.utab.setSerialiser(utab_keys, this.utab_data);
        index.setSerialiser(this);
        return index;
    }

    public SkeletonBTreeMap<FreenetURI, URIEntry> setSerialiserFor(SkeletonBTreeMap<FreenetURI, URIEntry> entries) {
        BTreeNodeSerialiser uri_keys = new BTreeNodeSerialiser("uri entries", this.leaf_arx, entries.makeNodeTranslator(null, null));
        entries.setSerialiser(uri_keys, uri_dummy);
        return entries;
    }

    public SkeletonBTreeSet<TermEntry> setSerialiserFor(SkeletonBTreeSet<TermEntry> entries) {
        BTreeNodeSerialiser term_keys = new BTreeNodeSerialiser("term entries", this.leaf_arx, entries.makeNodeTranslator(null, term_data_mtr));
        entries.setSerialiser(term_keys, term_dummy);
        return entries;
    }

    public static class DummySerialiser<K, T>
    implements IterableSerialiser<T>,
    MapSerialiser<K, T> {
        @Override
        public void pull(Serialiser.PullTask<T> task) {
            task.data = task.meta;
        }

        @Override
        public void push(Serialiser.PushTask<T> task) {
            task.meta = task.data;
        }

        @Override
        public void pull(Iterable<Serialiser.PullTask<T>> tasks) {
            for (Serialiser.PullTask<T> task : tasks) {
                task.data = task.meta;
            }
        }

        @Override
        public void push(Iterable<Serialiser.PushTask<T>> tasks) {
            for (Serialiser.PushTask<T> task : tasks) {
                task.meta = task.data;
            }
        }

        @Override
        public void pull(Map<K, Serialiser.PullTask<T>> tasks, Object mapmeta) {
            for (Serialiser.PullTask<T> task : tasks.values()) {
                if (task.meta == null) continue;
                task.data = task.meta;
            }
        }

        @Override
        public void push(Map<K, Serialiser.PushTask<T>> tasks, Object mapmeta) {
            for (Serialiser.PushTask<T> task : tasks.values()) {
                if (task.data == null) continue;
                task.meta = task.data;
            }
        }
    }

    public static class EntryGroupSerialiser<K, V>
    extends ParallelSerialiser<Map<K, V>, SimpleProgress>
    implements IterableSerialiser<Map<K, V>>,
    Serialiser.Composite<LiveArchiver<Map<String, Object>, SimpleProgress>> {
        protected final LiveArchiver<Map<String, Object>, SimpleProgress> subsrl;
        protected final Translator<K, String> ktr;
        protected final Translator<V, Map<String, Object>> btr;

        public EntryGroupSerialiser(LiveArchiver<Map<String, Object>, SimpleProgress> s, Translator<K, String> k, Translator<V, Map<String, Object>> b) {
            super(new ProgressTracker(SimpleProgress.class));
            this.subsrl = s;
            this.ktr = k;
            this.btr = b;
        }

        @Override
        public LiveArchiver<Map<String, Object>, SimpleProgress> getChildSerialiser() {
            return this.subsrl;
        }

        @Override
        public void pullLive(Serialiser.PullTask<Map<K, V>> task, SimpleProgress p) throws TaskAbortException {
            p.enteredSerialiser();
            try {
                p.setSubject("Pulling root container " + task.meta);
                Serialiser.PullTask t = new Serialiser.PullTask(task.meta);
                this.subsrl.pullLive(t, p);
                HashMap map = new HashMap(((Map)t.data).size() << 1);
                try {
                    for (Map.Entry en : ((Map)t.data).entrySet()) {
                        map.put(this.ktr == null ? en.getKey() : this.ktr.rev((String)en.getKey()), this.btr.rev((Map)en.getValue()));
                    }
                }
                catch (ClassCastException e) {
                    throw new DataFormatException("Exception in converting data", e, t.data, null, null);
                }
                task.data = map;
                p.exitingSerialiser();
            }
            catch (RuntimeException e) {
                p.abort(new TaskAbortException("Failed task: " + p.getSubject(), e));
            }
            catch (DataFormatException e) {
                p.abort(new TaskAbortException("Failed task: " + p.getSubject(), e));
            }
        }

        @Override
        public void pushLive(Serialiser.PushTask<Map<K, V>> task, SimpleProgress p) throws TaskAbortException {
            p.enteredSerialiser();
            try {
                p.setSubject("Pushing root container for keys " + task.data);
                HashMap<String, Map<String, Object>> conv = new HashMap<String, Map<String, Object>>();
                for (Map.Entry mp : ((Map)task.data).entrySet()) {
                    conv.put(this.ktr == null ? (String)mp.getKey() : this.ktr.app(mp.getKey()), this.btr.app(mp.getValue()));
                }
                Serialiser.PushTask t = new Serialiser.PushTask(conv, task.meta);
                this.subsrl.pushLive(t, p);
                task.meta = t.meta;
                p.exitingSerialiser();
            }
            catch (RuntimeException e) {
                p.abort(new TaskAbortException("Failed task: " + p.getSubject(), e));
            }
        }
    }

    public static class BTreePacker<K, V, S extends IterableSerialiser<Map<K, V>> & Serialiser.Trackable<Map<K, V>>>
    extends Packer<K, V>
    implements MapSerialiser<K, V>,
    Serialiser.Trackable<V> {
        protected final ProgressTracker<V, BaseCompositeProgress> tracker;
        protected final S subsrl;

        public BTreePacker(S s, Packer.Scale<V> sc, int cap) {
            super(s, sc, cap);
            this.subsrl = s;
            this.tracker = new ProgressTracker(BaseCompositeProgress.class);
        }

        @Override
        public ProgressTracker<V, ? extends Progress> getTracker() {
            return this.tracker;
        }

        @Override
        protected void preprocessPullBins(Map<K, Serialiser.PullTask<V>> tasks, Collection<Serialiser.PullTask<Map<K, V>>> bintasks) {
            for (Map.Entry<K, Serialiser.PullTask<V>> en : tasks.entrySet()) {
                try {
                    BaseCompositeProgress p = this.tracker.addPullProgress(en.getValue());
                    p.setSubProgress(ProgressTracker.makePullProgressIterable(((Serialiser.Trackable)this.subsrl).getTracker(), bintasks));
                    p.setEstimate(-1);
                    p.setSubject("Pulling root container for " + en.getKey());
                }
                catch (TaskInProgressException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        @Override
        protected void preprocessPushBins(Map<K, Serialiser.PushTask<V>> tasks, Collection<Serialiser.PushTask<Map<K, V>>> bintasks) {
            for (Map.Entry<K, Serialiser.PushTask<V>> en : tasks.entrySet()) {
                try {
                    BaseCompositeProgress p = this.tracker.addPushProgress(en.getValue());
                    p.setSubProgress(ProgressTracker.makePushProgressIterable(((Serialiser.Trackable)this.subsrl).getTracker(), bintasks));
                    p.setEstimate(-1);
                    p.setSubject("Pushing root container for " + en.getKey());
                }
                catch (TaskInProgressException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    public static class BTreeNodeSerialiser<K, V>
    extends ParallelSerialiser<SkeletonBTreeMap.SkeletonNode, SimpleProgress>
    implements Archiver<SkeletonBTreeMap.SkeletonNode>,
    Serialiser.Translate<SkeletonBTreeMap.SkeletonNode, Map<String, Object>>,
    Serialiser.Composite<LiveArchiver<Map<String, Object>, SimpleProgress>> {
        protected final Translator<SkeletonBTreeMap.SkeletonNode, Map<String, Object>> trans;
        protected final LiveArchiver<Map<String, Object>, SimpleProgress> subsrl;
        protected String name;

        public BTreeNodeSerialiser(String n, LiveArchiver<Map<String, Object>, SimpleProgress> s, SkeletonBTreeMap.NodeTranslator<?, ?> t) {
            super(new ProgressTracker(SimpleProgress.class));
            this.subsrl = s;
            this.trans = t;
            this.name = n;
        }

        @Override
        public Translator<SkeletonBTreeMap.SkeletonNode, Map<String, Object>> getTranslator() {
            return this.trans;
        }

        @Override
        public LiveArchiver<Map<String, Object>, SimpleProgress> getChildSerialiser() {
            return this.subsrl;
        }

        @Override
        public void pullLive(Serialiser.PullTask<SkeletonBTreeMap.SkeletonNode> task, SimpleProgress p) throws TaskAbortException {
            p.enteredSerialiser();
            try {
                SkeletonBTreeMap.GhostNode ghost = (SkeletonBTreeMap.GhostNode)task.meta;
                p.setSubject("Pulling " + this.name + ": " + ghost.getRange());
                Serialiser.PullTask serialisable = new Serialiser.PullTask(ghost.getMeta());
                this.subsrl.pullLive(serialisable, p);
                ghost.setMeta(serialisable.meta);
                task.data = this.trans.rev((Map<String, Object>)serialisable.data);
                p.exitingSerialiser();
            }
            catch (RuntimeException e) {
                p.abort(new TaskAbortException("Could not pull B-tree node", e));
            }
            catch (DataFormatException e) {
                p.abort(new TaskAbortException("Could not pull B-tree node", e));
            }
        }

        @Override
        public void pushLive(Serialiser.PushTask<SkeletonBTreeMap.SkeletonNode> task, SimpleProgress p) throws TaskAbortException {
            p.enteredSerialiser();
            try {
                p.setSubject("Pushing " + this.name + ": " + ((SkeletonBTreeMap.SkeletonNode)task.data).getRange());
                Map<String, Object> intermediate = this.trans.app((SkeletonBTreeMap.SkeletonNode)task.data);
                Serialiser.PushTask<Map<String, Object>> serialisable = new Serialiser.PushTask<Map<String, Object>>(intermediate, task.meta);
                this.subsrl.pushLive(serialisable, p);
                task.meta = ((SkeletonBTreeMap.SkeletonNode)task.data).makeGhost(serialisable.meta);
                p.exitingSerialiser();
            }
            catch (RuntimeException e) {
                p.abort(new TaskAbortException("Could not push B-tree node", e));
            }
        }
    }

    public static class TreeMapTranslator<K, V>
    extends SkeletonTreeMap.TreeMapTranslator<K, V> {
        protected final Translator<K, String> ktr;

        public TreeMapTranslator(Translator<K, String> k) {
            this.ktr = k;
        }

        @Override
        public Map<String, Object> app(SkeletonTreeMap<K, V> map) {
            return TreeMapTranslator.app(map, new TreeMap<String, Object>(), this.ktr);
        }

        @Override
        public SkeletonTreeMap<K, V> rev(Map<String, Object> map) throws DataFormatException {
            return TreeMapTranslator.rev(map, new SkeletonTreeMap(), this.ktr);
        }
    }
}

