/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index;

import freenet.keys.FreenetURI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermIndexEntry;
import plugins.Library.index.TermPageEntry;
import plugins.Library.index.TermTermEntry;
import plugins.Library.io.DataFormatException;
import plugins.Library.io.ObjectStreamReader;
import plugins.Library.io.ObjectStreamWriter;

public class TermEntryReaderWriter
implements ObjectStreamReader<TermEntry>,
ObjectStreamWriter<TermEntry> {
    private static final TermEntryReaderWriter instance = new TermEntryReaderWriter();

    protected TermEntryReaderWriter() {
    }

    public static TermEntryReaderWriter getInstance() {
        return instance;
    }

    @Override
    public TermEntry readObject(InputStream is) throws IOException {
        return this.readObject(new DataInputStream(is));
    }

    public TermEntry readObject(DataInputStream dis) throws IOException {
        long svuid = dis.readLong();
        if (svuid != -994850524944312820L) {
            throw new DataFormatException("Incorrect serialVersionUID", null, svuid);
        }
        int type = dis.readInt();
        String subj = dis.readUTF();
        float rel = dis.readFloat();
        TermEntry.EntryType[] types = TermEntry.EntryType.values();
        if (type < 0 || type >= types.length) {
            throw new DataFormatException("Unrecognised entry type", null, type);
        }
        switch (types[type]) {
            case TERM: {
                return new TermTermEntry(subj, rel, dis.readUTF());
            }
            case INDEX: {
                return new TermIndexEntry(subj, rel, FreenetURI.readFullBinaryKeyWithLength((DataInputStream)dis));
            }
            case PAGE: {
                FreenetURI page = FreenetURI.readFullBinaryKeyWithLength((DataInputStream)dis);
                int size = dis.readInt();
                String title = null;
                if (size < 0) {
                    title = dis.readUTF();
                    size ^= 0xFFFFFFFF;
                }
                HashMap<Integer, String> pos = new HashMap<Integer, String>(size << 1);
                for (int i = 0; i < size; ++i) {
                    int index = dis.readInt();
                    String val = dis.readUTF();
                    pos.put(index, "".equals(val) ? null : val);
                }
                return new TermPageEntry(subj, rel, page, title, pos);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void writeObject(TermEntry en, OutputStream os) throws IOException {
        this.writeObject(en, new DataOutputStream(os));
    }

    public void writeObject(TermEntry en, DataOutputStream dos) throws IOException {
        dos.writeLong(-994850524944312820L);
        TermEntry.EntryType type = en.entryType();
        dos.writeInt(type.ordinal());
        dos.writeUTF(en.subj);
        dos.writeFloat(en.rel);
        switch (type) {
            case TERM: {
                dos.writeUTF(((TermTermEntry)en).term);
                return;
            }
            case INDEX: {
                ((TermIndexEntry)en).index.writeFullBinaryKeyWithLength(dos);
                return;
            }
            case PAGE: {
                int size;
                TermPageEntry enn = (TermPageEntry)en;
                enn.page.writeFullBinaryKeyWithLength(dos);
                int n = size = enn.hasPositions() ? enn.positionsSize() : 0;
                if (enn.title == null) {
                    dos.writeInt(size);
                } else {
                    dos.writeInt(~size);
                    dos.writeUTF(enn.title);
                }
                if (size != 0) {
                    if (enn.hasFragments()) {
                        for (Map.Entry<Integer, String> p : enn.positionsMap().entrySet()) {
                            dos.writeInt(p.getKey());
                            if (p.getValue() == null) {
                                dos.writeUTF("");
                                continue;
                            }
                            dos.writeUTF(p.getValue());
                        }
                    } else {
                        for (int x : enn.positionsRaw()) {
                            dos.writeInt(x);
                            dos.writeUTF("");
                        }
                    }
                }
                return;
            }
        }
    }
}

