/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MainIndexParser
extends DefaultHandler {
    protected int version;
    protected Map<String, String> header;
    protected Set<String> subIndice;
    protected Set<String> siteIndice;
    protected DefaultHandler handler;
    protected Locator locator;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        this.header = new HashMap<String, String>();
        this.subIndice = new HashSet<String>();
        this.siteIndice = new HashSet<String>();
        this.handler = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.handler == null) {
            this.version = this.detectVersion(uri, localName, qName, attributes);
            switch (this.version) {
                case 1: {
                    this.handler = new V1Handler();
                    break;
                }
                default: {
                    throw new SAXException("Unsupported version @(" + this.location() + " : " + this.version);
                }
            }
            this.handler.startDocument();
        }
        this.handler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handler.endElement(uri, localName, qName);
    }

    @Override
    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    private int detectVersion(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("main_index".equals(localName)) {
            return 1;
        }
        throw new SAXException("Unknown tag @" + this.location() + " : " + localName);
    }

    private String location() {
        if (this.locator != null) {
            return "(" + this.locator.getLineNumber() + "," + this.locator.getColumnNumber() + ")";
        }
        return "()";
    }

    public int getVersion() {
        return this.version;
    }

    public String getHeader(String key) {
        return this.header.get(key);
    }

    public Set<String> getSubIndice() {
        return this.subIndice;
    }

    public Set<String> getSiteIndice() {
        return this.siteIndice;
    }

    protected class V1Handler
    extends DefaultHandler {
        V1State state;
        String headerKey;
        StringBuilder headerValue;

        protected V1Handler() {
        }

        @Override
        public void startDocument() {
            this.state = V1State.MAIN;
            this.headerKey = null;
            this.headerValue = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state != V1State.HEADER_INNER || this.headerKey == null) {
                return;
            }
            this.headerValue.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (this.state) {
                case MAIN: {
                    this.mainStartElement(uri, localName, qName, attributes);
                    break;
                }
                case HEADER: {
                    this.headerStartElement(uri, localName, qName, attributes);
                    break;
                }
                case HEADER_INNER: {
                    this.headerInnerStartElement(uri, localName, qName, attributes);
                    break;
                }
                case KEYWORDS: {
                    this.keywordsStartElement(uri, localName, qName, attributes);
                }
            }
        }

        private void mainStartElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("main_index".equals(localName)) {
                this.state = V1State.MAIN;
            } else if ("header".equals(localName)) {
                this.state = V1State.HEADER;
            } else if ("keywords".equals(localName)) {
                this.state = V1State.KEYWORDS;
            } else if (!"prefix".equals(localName)) {
                throw new SAXException("Bad tag <" + localName + "> in main @" + MainIndexParser.this.location());
            }
        }

        private void headerStartElement(String uri, String localName, String qName, Attributes attributes) {
            this.headerKey = localName;
            this.headerValue = new StringBuilder();
            this.state = V1State.HEADER_INNER;
        }

        private void headerInnerStartElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            throw new SAXException("Bad tag <" + localName + "> in header @" + MainIndexParser.this.location());
        }

        private void keywordsStartElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"subIndex".equals(localName)) {
                throw new SAXException("Bad tag <" + localName + "> in keywords @" + MainIndexParser.this.location());
            }
            String key = attributes.getValue("", "key");
            if (key == null || key.length() < 1 || key.length() > 32 || !key.matches("^[0-9a-fA-F]*$")) {
                throw new SAXException("Bad <subIndex> tag @" + MainIndexParser.this.location());
            }
            key = key.toLowerCase(Locale.US);
            MainIndexParser.this.subIndice.add(key);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (this.state) {
                case MAIN: {
                    this.mainEndElement(uri, localName, qName);
                    break;
                }
                case HEADER: {
                    this.headerEndElement(uri, localName, qName);
                    break;
                }
                case HEADER_INNER: {
                    this.headerInnerEndElement(uri, localName, qName);
                    break;
                }
                case KEYWORDS: {
                    this.keywordsEndElement(uri, localName, qName);
                }
            }
        }

        private void mainEndElement(String uri, String localName, String qName) throws SAXException {
            if (!"main_index".equals(localName) && !"prefix".equals(localName)) {
                throw new SAXException("Bad close tag </" + localName + "> in main @" + MainIndexParser.this.location());
            }
        }

        private void headerEndElement(String uri, String localName, String qName) throws SAXException {
            if (!"header".equals(localName)) {
                throw new SAXException("Bad close tag </" + localName + "> in header @" + MainIndexParser.this.location());
            }
            this.state = V1State.MAIN;
        }

        private void headerInnerEndElement(String uri, String localName, String qName) throws SAXException {
            if (!localName.equals(this.headerKey)) {
                throw new SAXException("Bad close tag </" + localName + "> in header @" + MainIndexParser.this.location());
            }
            MainIndexParser.this.header.put(this.headerKey, this.headerValue.toString());
            this.headerKey = null;
            this.headerValue = null;
            this.state = V1State.HEADER;
        }

        private void keywordsEndElement(String uri, String localName, String qName) throws SAXException {
            if (!"subIndex".equals(localName)) {
                if ("keywords".equals(localName)) {
                    this.state = V1State.MAIN;
                } else {
                    throw new SAXException("Bad close tag </" + localName + "> in keywords @" + MainIndexParser.this.location());
                }
            }
        }
    }

    protected static enum V1State {
        MAIN,
        HEADER,
        HEADER_INNER,
        KEYWORDS;

    }
}

