/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.io.serial;

import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import plugins.Library.io.serial.IterableSerialiser;
import plugins.Library.io.serial.MapSerialiser;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.util.IdentityComparator;
import plugins.Library.util.exec.TaskAbortException;
import plugins.Library.util.exec.TaskCompleteException;

public class Packer<K, T>
implements MapSerialiser<K, T>,
Serialiser.Composite<IterableSerialiser<Map<K, T>>> {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    public final int BIN_CAP;
    public final int BIN_CAPHF;
    public final boolean NO_TINY;
    public final Scale<T> scale;
    private Integer aggression = 1;
    protected final IterableSerialiser<Map<K, T>> subsrl;

    @Override
    public IterableSerialiser<Map<K, T>> getChildSerialiser() {
        return this.subsrl;
    }

    public Packer(IterableSerialiser<Map<K, T>> s, Scale<T> sc, int c, boolean n) {
        if (s == null) {
            throw new IllegalArgumentException("Can't have a null child serialiser");
        }
        if (c <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than zero.");
        }
        this.subsrl = s;
        this.scale = sc;
        this.BIN_CAP = c;
        this.BIN_CAPHF = c >> 1;
        this.NO_TINY = n;
    }

    public Packer(IterableSerialiser<Map<K, T>> s, Scale<T> sc, int c) {
        this(s, sc, c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAggression(int i) {
        if (i < 0 || i > 3) {
            throw new IllegalArgumentException("Invalid aggression value: only 0,1,2,3 is allowed.");
        }
        Packer packer = this;
        synchronized (packer) {
            this.aggression = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAggression() {
        Packer packer = this;
        synchronized (packer) {
            return this.aggression;
        }
    }

    protected IDGenerator generator() {
        return new IDGenerator();
    }

    protected void preprocessPullBins(Map<K, Serialiser.PullTask<T>> tasks, Collection<Serialiser.PullTask<Map<K, T>>> bintasks) {
    }

    protected void preprocessPushBins(Map<K, Serialiser.PushTask<T>> tasks, Collection<Serialiser.PushTask<Map<K, T>>> bintasks) {
    }

    protected SortedSet<Bin<K>> initialiseBinSet(SortedSet<Bin<K>> bins, Map<K, Serialiser.PushTask<T>> elems, Inventory<K, T> inv, IDGenerator gen, Object mapmeta) throws TaskAbortException {
        Bin<K> lightest;
        Bin second;
        HashMap<Object, HashSet<K>> binincubator = new HashMap<Object, HashSet<K>>();
        for (Map.Entry<K, Serialiser.PushTask<T>> en : elems.entrySet()) {
            Serialiser.PushTask<T> task = en.getValue();
            if (task.data != null) continue;
            if (task.meta == null) {
                throw new IllegalArgumentException("Packer error: null data and null meta for key" + en.getKey());
            }
            Object binID = this.scale.readMetaID(task.meta);
            HashSet<K> binegg = (HashSet<K>)binincubator.get(binID);
            if (binegg == null) {
                binegg = new HashSet<K>();
                binincubator.put(binID, binegg);
            }
            binegg.add(en.getKey());
        }
        HashMap overflow = null;
        for (Map.Entry en : binincubator.entrySet()) {
            Set keys = (Set)en.getValue();
            Bin bin = new Bin(this.BIN_CAP, inv, gen.registerID(en.getKey()), keys);
            for (Object k : keys) {
                if (!bin.add(k) || bin.weight <= this.BIN_CAP) continue;
                bin.remove(k);
                if (overflow == null) {
                    overflow = new HashMap();
                }
                overflow.put(k, elems.get(k));
            }
            bins.add(bin);
        }
        if (overflow != null) {
            System.err.println("Repacking: data has grown, " + overflow.size() + " items don't fit, pulling data to repack");
            this.pullUnloaded(overflow, mapmeta);
        }
        while (bins.size() > 1 && (second = bins.headSet(lightest = bins.last()).last()).filled() < this.BIN_CAPHF) {
            System.err.println("Merging bins: Data has shrunk!");
            bins.remove(lightest);
            bins.remove(second);
            for (Object k : lightest) {
                second.add(k);
            }
            bins.add(second);
        }
        return bins;
    }

    protected void packBestFitDecreasing(SortedSet<Bin<K>> bins, Map<K, Serialiser.PushTask<T>> elems, Inventory<K, T> inv, IDGenerator gen) {
        Bin<K> bin;
        Bin<K> heaviest;
        if (this.NO_TINY && !bins.isEmpty() && (heaviest = bins.first()).filled() > this.BIN_CAP) {
            Bin bin2 = new Bin(this.BIN_CAP, inv, gen.nextID(), null);
            bins.remove(heaviest);
            while (bin2.filled() < this.BIN_CAPHF) {
                Object key = heaviest.last();
                heaviest.remove(key);
                bin2.add(key);
            }
            bins.add(heaviest);
            bins.add(bin2);
        }
        if (!bins.isEmpty() && bins.first().filled() > this.BIN_CAP) {
            System.err.println("Bins:");
            for (Bin bin3 : bins) {
                System.err.println("Bin: " + bin3.filled());
            }
            assert (false);
        }
        if (bins.size() >= 2 && bins.headSet(bins.last()).last().filled() < this.BIN_CAPHF) {
            System.err.println("Last but one bin should be at least " + this.BIN_CAPHF);
            for (Bin bin4 : bins) {
                System.err.println("Bin: " + bin4.filled());
            }
            assert (false);
        }
        TreeSet sorted = new TreeSet(Collections.reverseOrder(inv));
        for (Map.Entry<K, Serialiser.PushTask<T>> en : elems.entrySet()) {
            if (en.getValue().data == null) continue;
            sorted.add(en.getKey());
        }
        for (Object key : sorted) {
            int weight = inv.getWeight(key);
            SortedSet subbins = bins.tailSet(new DummyBin(this.BIN_CAP, this.BIN_CAP - weight));
            if (subbins.isEmpty()) {
                Bin bin5 = new Bin(this.BIN_CAP, inv, gen.nextID(), null);
                bin5.add(key);
                bins.add(bin5);
                continue;
            }
            Bin lowest = subbins.first();
            bins.remove(lowest);
            lowest.add(key);
            bins.add(lowest);
        }
        assert (bins.isEmpty() || bins.first().filled() <= this.BIN_CAP);
        assert (bins.size() < 2 || bins.headSet(bins.last()).last().filled() >= this.BIN_CAPHF);
        if (this.NO_TINY && bins.size() > 1 && (bin = bins.last()).filled() < this.BIN_CAPHF) {
            bins.remove(bin);
            Bin second = bins.last();
            bins.remove(second);
            for (Object k : bin) {
                second.add(k);
            }
            bins.add(second);
        }
    }

    protected void redistributeWeights(SortedSet<Bin<K>> bins, Inventory<K, T> inv) {
        ArrayList<Bin<K>> binsFinal = new ArrayList<Bin<K>>(bins.size());
        if (bins.size() < 2) {
            return;
        }
        Bin lightest = bins.last();
        while (!bins.isEmpty()) {
            Bin<K> heaviest = bins.first();
            bins.remove(heaviest);
            int n = heaviest.filled() - lightest.filled();
            Object feather = heaviest.first();
            if (inv.getWeight(feather) < n) {
                bins.remove(lightest);
                heaviest.remove(feather);
                lightest.add(feather);
                bins.add(heaviest);
                bins.add(lightest);
                lightest = bins.last();
            } else {
                binsFinal.add(heaviest);
            }
            assert (bins.isEmpty() || bins.first().filled() - bins.last().filled() <= n);
        }
        for (Bin bin : binsFinal) {
            bins.add(bin);
        }
    }

    protected void discardUnchangedBins(SortedSet<Bin<K>> bins, Map<K, Serialiser.PushTask<T>> elems) {
        Iterator it = bins.iterator();
        while (it.hasNext()) {
            Bin bin = (Bin)it.next();
            if (!bin.unchanged()) continue;
            it.remove();
            for (Object key : bin) {
                elems.remove(key);
            }
        }
    }

    protected void pullUnloaded(Map<K, Serialiser.PushTask<T>> tasks, Object meta) throws TaskAbortException {
        Serialiser.PushTask<T> task;
        HashMap newtasks = new HashMap(tasks.size() << 1);
        for (Map.Entry<K, Serialiser.PushTask<T>> en : tasks.entrySet()) {
            task = en.getValue();
            if (task.data != null) continue;
            newtasks.put(en.getKey(), new Serialiser.PullTask(task.meta));
        }
        if (newtasks.isEmpty()) {
            return;
        }
        this.pull(newtasks, meta);
        for (Map.Entry<K, Serialiser.PushTask<T>> en : tasks.entrySet()) {
            task = en.getValue();
            Serialiser.PullTask newtask = (Serialiser.PullTask)newtasks.get(en.getKey());
            if (task.data != null) continue;
            if (newtask == null) {
                throw new IllegalStateException("The child serialiser should *not* discard (what it perceives to be) duplicate requests for bins. See the class documentation for details.");
            }
            if (newtask.data == null) {
                throw new IllegalStateException("Packer did not get the expected data while pulling unloaded bins; the pull method (or the child serialiser) is buggy.");
            }
            task.data = newtask.data;
            task.meta = newtask.meta;
        }
    }

    @Override
    public void pull(Map<K, Serialiser.PullTask<T>> tasks, Object mapmeta) throws TaskAbortException {
        try {
            Serialiser.PullTask bintask;
            Inventory<K, T> inv = new Inventory<K, T>(this, tasks);
            HashMap bintasks = new HashMap();
            for (Map.Entry<K, Serialiser.PullTask<T>> en : tasks.entrySet()) {
                Object binid = this.scale.readMetaID(en.getValue().meta);
                if (bintasks.containsKey(binid)) continue;
                bintasks.put(binid, new Serialiser.PullTask(this.scale.makeBinMeta(mapmeta, binid)));
            }
            this.preprocessPullBins(tasks, bintasks.values());
            this.subsrl.pull(bintasks.values());
            for (Map.Entry<K, Serialiser.PullTask<T>> en : tasks.entrySet()) {
                Serialiser.PullTask<T> task = en.getValue();
                bintask = (Serialiser.PullTask)bintasks.get(this.scale.readMetaID(task.meta));
                if (bintask == null) {
                    tasks.remove(en.getKey());
                    continue;
                }
                if (bintask.data != null && (task.data = ((Map)bintask.data).remove(en.getKey())) != null) continue;
                throw new TaskAbortException("Packer did not find the element (" + en.getKey() + ") in the expected bin (" + this.scale.readMetaID(task.meta) + "). Either the data is corrupt, or the child serialiser is buggy.", new Exception("internal error"));
            }
            HashMap leftovers = new HashMap();
            for (Map.Entry en : bintasks.entrySet()) {
                bintask = (Serialiser.PullTask)en.getValue();
                for (Map.Entry el : ((Map)bintask.data).entrySet()) {
                    if (tasks.containsKey(el.getKey())) {
                        throw new TaskAbortException("Packer found an extra unexpected element (" + el.getKey() + ") inside a bin (" + en.getKey() + "). Either the data is corrupt, or the child serialiser is buggy.", new Exception("internal error"));
                    }
                    Serialiser.PullTask task = new Serialiser.PullTask(this.scale.makeMeta(en.getKey(), this.scale.weigh(el.getValue())));
                    task.data = el.getValue();
                    leftovers.put(el.getKey(), task);
                }
            }
            tasks.putAll(leftovers);
            if (tasks.isEmpty()) {
                throw new TaskCompleteException("All tasks appear to be complete");
            }
        }
        catch (RuntimeException e) {
            throw new TaskAbortException("Could not complete the pull operation", e);
        }
    }

    @Override
    public void push(Map<K, Serialiser.PushTask<T>> tasks, Object mapmeta) throws TaskAbortException {
        try {
            int agg = this.getAggression();
            if (logDEBUG) {
                Logger.debug((Object)this, (String)("Aggression = " + agg + " tasks size = " + tasks.size()));
            }
            IDGenerator gen = this.generator();
            Inventory inv = new Inventory(this, tasks);
            TreeSet<Bin<K>> bins = new TreeSet<Bin<K>>();
            if (agg <= 0) {
                Iterator<Serialiser.PushTask<T>> it = tasks.values().iterator();
                while (it.hasNext()) {
                    Serialiser.PushTask<T> task = it.next();
                    if (task.data != null) continue;
                    it.remove();
                }
            } else if (agg <= 2) {
                this.initialiseBinSet(bins, tasks, inv, gen, mapmeta);
            } else {
                this.pullUnloaded(tasks, mapmeta);
            }
            this.packBestFitDecreasing(bins, tasks, inv, gen);
            if (agg <= 1) {
                this.discardUnchangedBins(bins, tasks);
            }
            this.redistributeWeights(bins, inv);
            if (agg <= 2) {
                this.discardUnchangedBins(bins, tasks);
                this.pullUnloaded(tasks, mapmeta);
            }
            ArrayList bintasks = new ArrayList(bins.size());
            for (Bin bin : bins) {
                HashMap data = new HashMap(bin.size() << 1);
                for (Object k : bin) {
                    data.put(k, tasks.get(k).data);
                }
                bintasks.add(new Serialiser.PushTask(data, this.scale.makeBinMeta(mapmeta, bin.id)));
            }
            this.preprocessPushBins(tasks, bintasks);
            this.subsrl.push(bintasks);
            for (Serialiser.PushTask pushTask : bintasks) {
                for (Object k : ((Map)pushTask.data).keySet()) {
                    tasks.get(k).meta = this.scale.makeMeta(this.scale.readBinMetaID(pushTask.meta), inv.getWeight(k));
                    tasks.get(k).data = null;
                }
            }
        }
        catch (RuntimeException e) {
            throw new TaskAbortException("Could not complete the push operation", e);
        }
    }

    static {
        Logger.registerClass(Packer.class);
    }

    public static abstract class Scale<T> {
        public Object makeBinMeta(Object mapmeta, Object binid) {
            Object[] objectArray;
            if (mapmeta == null) {
                objectArray = binid;
            } else {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = mapmeta;
                objectArray = objectArray2;
                objectArray2[1] = binid;
            }
            return objectArray;
        }

        public Object readBinMetaID(Object binmeta) {
            return binmeta instanceof Object[] ? ((Object[])binmeta)[1] : binmeta;
        }

        public abstract int weigh(T var1);

        public Object readMetaID(Object meta) {
            return ((BinInfo)meta).id;
        }

        public int readMetaWeight(Object meta) {
            return ((BinInfo)meta).weight;
        }

        public Object makeMeta(Object id, int weight) {
            return new BinInfo(id, weight);
        }
    }

    public static class BinInfo
    implements Cloneable {
        protected Object id;
        protected int weight;

        public BinInfo() {
        }

        public BinInfo(Object i, int w) {
            this.id = i;
            this.weight = w;
        }

        public Object getID() {
            return this.id;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setID(Object i) {
            this.id = i;
        }

        public void setWeight(int w) {
            this.weight = w;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BinInfo)) {
                return false;
            }
            BinInfo bi = (BinInfo)o;
            return this.id.equals(bi.id) && this.weight == bi.weight;
        }

        public int hashCode() {
            return this.id.hashCode() + this.weight * 31;
        }

        public String toString() {
            return "Bin \"" + this.id + "\" - " + this.weight + "oz.";
        }
    }

    public static class IDGenerator {
        protected long nextID;

        public Object registerID(Object o) {
            long id;
            if (o instanceof Integer) {
                id = ((Integer)o).intValue();
            } else if (o instanceof Long) {
                id = (Long)o;
            } else if (o instanceof Short) {
                id = ((Short)o).shortValue();
            } else if (o instanceof Byte) {
                id = ((Byte)o).byteValue();
            } else {
                return o;
            }
            if (id > this.nextID) {
                this.nextID = id + 1L;
            }
            return o;
        }

        public Long nextID() {
            return this.nextID++;
        }
    }

    protected static class Inventory<K, T>
    extends IdentityComparator<K> {
        protected final Map<K, Integer> weights = new HashMap<K, Integer>();
        protected final Map<K, ? extends Serialiser.Task<T>> elements;
        protected final Packer<K, T> packer;
        protected final Scale<T> scale;
        protected K giant;

        protected Inventory(Packer<K, T> pk, Map<K, ? extends Serialiser.Task<T>> elem) {
            this.packer = pk;
            this.scale = pk.scale;
            this.elements = elem;
        }

        public int getWeight(K key) {
            Integer i = this.weights.get(key);
            if (i == null) {
                Serialiser.Task<T> task = this.elements.get(key);
                if (task == null) {
                    throw new IllegalArgumentException("This scale does not have a weight for " + key);
                }
                i = task.data == null ? Integer.valueOf(this.scale.readMetaWeight(task.meta)) : Integer.valueOf(this.scale.weigh(task.data));
                if (i > this.packer.BIN_CAP) {
                    if (this.packer.NO_TINY && this.giant == null) {
                        this.giant = key;
                    } else {
                        throw new IllegalArgumentException("Element " + key + " greater than the capacity allowed: " + i + "/" + this.packer.BIN_CAP);
                    }
                }
                this.weights.put(key, i);
            }
            return i;
        }

        @Override
        public int compare(K k1, K k2) {
            int b;
            if (k1 == k2) {
                return 0;
            }
            int a = this.getWeight(k1);
            if (a != (b = this.getWeight(k2))) {
                return a < b ? -1 : 1;
            }
            return k1 == null ? -1 : (k2 == null ? 1 : super.compare(k1, k2));
        }

        public K makeDummyObject(int weight) {
            this.weights.put(null, weight);
            return null;
        }
    }

    protected static class DummyBin<K>
    extends Bin<K> {
        public DummyBin(int c, int w) {
            super(c, null, null, null);
            this.weight = w;
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException("Dummy bins cannot be modified");
        }

        @Override
        public boolean remove(Object c) {
            throw new UnsupportedOperationException("Dummy bins cannot be modified");
        }

        @Override
        public int compareTo(Bin<K> bin) {
            int f2;
            if (this == bin) {
                return 0;
            }
            int f1 = this.filled();
            if (f1 != (f2 = bin.filled())) {
                return f2 > f1 ? 1 : -1;
            }
            return bin instanceof DummyBin ? IdentityComparator.comparator.compare(this, bin) : 1;
        }
    }

    protected static class Bin<K>
    extends TreeSet<K>
    implements Comparable<Bin<K>> {
        protected final Object id;
        protected final Set<K> orig;
        protected final int capacity;
        protected final Inventory<K, ?> inv;
        int weight = 0;

        public Bin(int c, Inventory<K, ?> v, Object i, Set<K> o) {
            super(v);
            this.inv = v;
            this.capacity = c;
            this.id = i;
            this.orig = o;
        }

        public boolean unchanged() {
            return this.orig != null && this.equals(this.orig);
        }

        public int filled() {
            return this.weight;
        }

        public int remainder() {
            return this.capacity - this.weight;
        }

        @Override
        public boolean add(K c) {
            if (super.add(c)) {
                this.weight += this.inv.getWeight(c);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object c) {
            if (super.remove(c)) {
                this.weight -= this.inv.getWeight(c);
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Bin<K> bin) {
            int f2;
            if (this == bin) {
                return 0;
            }
            int f1 = this.filled();
            if (f1 != (f2 = bin.filled())) {
                return f2 > f1 ? 1 : -1;
            }
            return bin instanceof DummyBin ? -1 : IdentityComparator.comparator.compare(this, bin);
        }
    }
}

