/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.search;

import java.util.Arrays;
import java.util.List;

public class SearchUtil {
    private static List<String> stopWords = Arrays.asList("the", "and", "that", "have", "for");

    public static boolean isCJK(int codePoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        return block == Character.UnicodeBlock.CJK_COMPATIBILITY || block == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || block == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || block == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT || block == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || block == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || block == Character.UnicodeBlock.BOPOMOFO || block == Character.UnicodeBlock.BOPOMOFO_EXTENDED || block == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || block == Character.UnicodeBlock.HANGUL_JAMO || block == Character.UnicodeBlock.HANGUL_SYLLABLES || block == Character.UnicodeBlock.KANBUN || block == Character.UnicodeBlock.HIRAGANA || block == Character.UnicodeBlock.KANGXI_RADICALS || block == Character.UnicodeBlock.KANNADA || block == Character.UnicodeBlock.KATAKANA || block == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS;
    }

    public static boolean isStopWord(String word) {
        if (stopWords.contains(word)) {
            return true;
        }
        int len = word.codePointCount(0, word.length());
        if (len < 3) {
            int cp1 = word.codePointAt(0);
            if (SearchUtil.isCJK(cp1)) {
                return false;
            }
            if (len == 2) {
                int cp2 = word.codePointAt(Character.charCount(cp1));
                return !SearchUtil.isCJK(cp2);
            }
            return true;
        }
        return false;
    }
}

