/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PrefixTree<K extends PrefixKey, V> {
    protected final K prefix;
    protected final int preflen;
    protected final PrefixTree<K, V>[] child;
    public final transient int subtreesMax;
    public final int capacityLocal;
    protected int subtrees = 0;
    protected int size = 0;
    protected int[] sizePrefix;
    protected transient int smch_ = -1;

    protected PrefixTree(K p, int len, int maxsz, PrefixTree<K, V>[] chd) {
        if (chd != null) {
            if (chd.length != p.symbols()) {
                throw new IllegalArgumentException("The child array must be able to exactly hold all its potential children, of which there are " + p.symbols());
            }
            for (PrefixTree<K, V> c : chd) {
                if (c == null) continue;
                throw new IllegalArgumentException("Child array to attach must be empty.");
            }
        }
        if (maxsz < p.symbols()) {
            throw new IllegalArgumentException("This tree must be able to hold all its potential children, of which there are " + p.symbols());
        }
        if (len > p.size()) {
            throw new IllegalArgumentException("The key is shorter than the length specified.");
        }
        if (len < 0) {
            throw new IllegalArgumentException("Length cannot be negative.");
        }
        this.prefix = p;
        this.prefix.clearFrom(len);
        this.preflen = len;
        this.child = chd;
        this.sizePrefix = this.child == null ? null : new int[this.child.length];
        this.subtreesMax = p.symbols();
        this.capacityLocal = maxsz;
    }

    public int sizeLeft() {
        return this.capacityLocal - (this.sizeLocal() + this.subtrees);
    }

    public String prefixString() {
        String ps = this.prefix.toString();
        return ps.substring(0, ps.length() * this.preflen / this.prefix.size());
    }

    public int lastIndex() {
        return this.prefix.get(this.preflen - 1);
    }

    protected int smallestChild() {
        if (this.smch_ < 0 && this.subtrees > 0) {
            for (int i = 0; i < this.subtreesMax; ++i) {
                if (this.child[i] == null || this.smch_ >= 0 && this.sizePrefix[i] >= this.sizePrefix[this.smch_]) continue;
                this.smch_ = i;
            }
        }
        return this.smch_;
    }

    private int bindSubTree() {
        assert (this.sizeLocal() > 0);
        assert (this.subtrees < this.subtreesMax);
        int mcount = -1;
        int msym = 0;
        for (int i = 0; i < this.sizePrefix.length; ++i) {
            if (this.child[i] != null || this.sizePrefix[i] <= mcount) continue;
            mcount = this.sizePrefix[i];
            msym = i;
        }
        Object[] mkeys = new Object[mcount];
        int i = 0;
        for (PrefixKey ikey : this.keySetLocal()) {
            int isym = ikey.get(this.preflen);
            if (isym < msym) continue;
            if (isym == msym) {
                mkeys[i] = ikey;
                ++i;
                continue;
            }
            if (isym <= msym) continue;
            break;
        }
        assert (i <= mkeys.length);
        assert (this.child[msym] == null);
        this.child[msym] = this.makeSubTree(msym);
        ++this.subtrees;
        for (i = 0; i < mkeys.length; ++i) {
            this.transferLocalToSubtree(msym, (PrefixKey)mkeys[i]);
        }
        if (this.subtrees == 1 || this.smch_ > -1 && this.sizePrefix[msym] < this.sizePrefix[this.smch_]) {
            this.smch_ = msym;
        }
        return msym;
    }

    private boolean freeSubTree(int ch) {
        if (this.sizePrefix[ch] <= this.sizeLeft() + 1) {
            if (ch == this.smch_) {
                this.smch_ = -1;
            }
            this.transferSubtreeToLocal(this.child[ch]);
            this.child[ch] = null;
            --this.subtrees;
            return true;
        }
        return false;
    }

    protected void reshuffleAfterPut(int i) {
        int n = i;
        this.sizePrefix[n] = this.sizePrefix[n] + 1;
        ++this.size;
        if (this.child[i] != null) {
            if (i == this.smch_) {
                this.smch_ = -1;
            }
        } else if (this.sizeLeft() < 0) {
            this.bindSubTree();
            this.freeSubTree(this.smallestChild());
        } else {
            int sm = this.smallestChild();
            if (sm > -1 && this.sizePrefix[sm] < this.sizePrefix[i]) {
                int j = this.bindSubTree();
                assert (i == j);
                this.freeSubTree(sm);
            }
        }
    }

    protected void reshuffleAfterPut(int i, int n) {
        int n2 = i;
        this.sizePrefix[n2] = this.sizePrefix[n2] + (n - 1);
        this.size += n - 1;
        this.reshuffleAfterPut(i);
    }

    protected void reshuffleAfterRemove(int i) {
        int n = i;
        this.sizePrefix[n] = this.sizePrefix[n] - 1;
        --this.size;
        if (this.child[i] != null) {
            if (this.smch_ < 0 || i == this.smch_) {
                this.freeSubTree(this.smallestChild());
            } else if (this.sizePrefix[i] < this.sizePrefix[this.smch_] && !this.freeSubTree(i)) {
                this.smch_ = i;
            }
        } else {
            int t = this.smallestChild();
            if (t > -1) {
                this.freeSubTree(t);
            }
        }
    }

    protected void reshuffleAfterRemove(int i, int n) {
        int n2 = i;
        this.sizePrefix[n2] = this.sizePrefix[n2] - (n - 1);
        this.size -= n - 1;
        this.reshuffleAfterRemove(i);
    }

    protected abstract PrefixTree<K, V> makeSubTree(int var1);

    protected abstract void transferLocalToSubtree(int var1, K var2);

    protected abstract void transferSubtreeToLocal(PrefixTree<K, V> var1);

    protected abstract Object selectNode(int var1);

    protected abstract Object getLocalMap();

    protected abstract void clearLocal();

    protected abstract Set<K> keySetLocal();

    public abstract int sizeLocal();

    protected abstract Set<K> keySet();

    public void clear() {
        this.size = 0;
        this.clearLocal();
        this.smch_ = -1;
        for (int i = 0; i < this.subtreesMax; ++i) {
            this.child[i] = null;
            this.sizePrefix[i] = 0;
        }
        this.subtrees = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrefixTree)) {
            return false;
        }
        PrefixTree tr = (PrefixTree)o;
        if (this.size() != tr.size()) {
            return false;
        }
        if (!this.prefix.equals(tr.prefix) || this.preflen != tr.preflen || this.capacityLocal != tr.capacityLocal || !this.getLocalMap().equals(tr.getLocalMap())) {
            return false;
        }
        for (int i = 0; i < this.subtreesMax; ++i) {
            if ((this.child[i] != null || tr.child[i] != null) && this.child[i].equals(tr.child[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int sum = this.getLocalMap().hashCode();
        for (PrefixTree<K, V> ch : this.child) {
            if (ch == null) continue;
            sum += ch.hashCode();
        }
        return sum;
    }

    public abstract class PrefixTreeKeyIterator
    implements Iterator<K> {
        final Iterator<K> iterLocal;
        Iterator<K> iterChild;
        protected int index = 0;
        protected K nextLocal = null;

        protected PrefixTreeKeyIterator() {
            this.iterLocal = PrefixTree.this.keySetLocal().iterator();
            while (this.index < PrefixTree.this.subtreesMax && PrefixTree.this.child[this.index++] == null) {
            }
            if (this.index < PrefixTree.this.subtreesMax) {
                this.iterChild = PrefixTree.this.child[this.index].keySet().iterator();
            }
            if (this.iterLocal.hasNext()) {
                this.nextLocal = (PrefixKey)this.iterLocal.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLocal != null || this.iterChild != null;
        }

        @Override
        public K next() {
            while (this.index < PrefixTree.this.subtreesMax || this.nextLocal != null) {
                if (this.nextLocal != null && this.nextLocal.get(PrefixTree.this.preflen) < this.index) {
                    Object k = this.nextLocal;
                    this.nextLocal = this.iterLocal.hasNext() ? (PrefixKey)this.iterLocal.next() : null;
                    return k;
                }
                if (this.iterChild.hasNext()) {
                    return (PrefixKey)this.iterChild.next();
                }
                do {
                    ++this.index;
                } while (this.index < PrefixTree.this.subtreesMax && PrefixTree.this.child[this.index] == null);
                this.iterChild = this.index < PrefixTree.this.subtreesMax ? PrefixTree.this.child[this.index].keySet().iterator() : null;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }

    public static abstract class AbstractPrefixKey<K extends AbstractPrefixKey<K>>
    implements PrefixKey<K> {
        @Override
        public abstract AbstractPrefixKey<K> clone();

        @Override
        public K spawn(int i, int v) {
            Object p = this.clone();
            p.set(i, v);
            return (K)p;
        }

        @Override
        public void clearFrom(int len) {
            for (int i = len; i < this.size(); ++i) {
                this.clear(i);
            }
        }

        @Override
        public boolean match(K p, int len) {
            for (int i = 0; i < len; ++i) {
                if (this.get(i) == p.get(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(K p) {
            for (int i = 0; i < this.size(); ++i) {
                int y;
                int x = this.get(i);
                if (x == (y = p.get(i))) continue;
                return x > y ? 1 : -1;
            }
            return 0;
        }
    }

    public static interface PrefixKey<K extends PrefixKey<K>>
    extends Cloneable,
    Comparable<K> {
        public PrefixKey<K> clone();

        public int symbols();

        public int size();

        public int get(int var1);

        public void set(int var1, int var2);

        public void clear(int var1);

        public K spawn(int var1, int var2);

        public void clearFrom(int var1);

        public boolean match(K var1, int var2);
    }
}

