/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import plugins.Library.io.DataFormatException;
import plugins.Library.io.serial.IterableSerialiser;
import plugins.Library.io.serial.MapSerialiser;
import plugins.Library.io.serial.Translator;
import plugins.Library.util.BTreeSet;
import plugins.Library.util.SkeletonBTreeMap;
import plugins.Library.util.SkeletonTreeMap;
import plugins.Library.util.SortedSetMap;
import plugins.Library.util.TaskAbortExceptionConvertor;
import plugins.Library.util.exec.BaseCompositeProgress;
import plugins.Library.util.exec.TaskAbortException;

public class SkeletonBTreeSet<E>
extends BTreeSet<E> {
    public void setSerialiser(IterableSerialiser<SkeletonBTreeMap.SkeletonNode> n, MapSerialiser<E, E> v) {
        ((SkeletonBTreeMap)this.bkmap).setSerialiser(n, v);
    }

    public SkeletonBTreeSet(Comparator<? super E> cmp, int node_min) {
        super(new SkeletonBTreeMap(cmp, node_min));
    }

    public SkeletonBTreeSet(int node_min) {
        super(new SkeletonBTreeMap(node_min));
    }

    protected SkeletonBTreeSet(SkeletonBTreeMap<E, E> m) {
        super(m);
    }

    public boolean isBare() {
        return ((SkeletonBTreeMap)this.bkmap).isBare();
    }

    public boolean isLive() {
        return ((SkeletonBTreeMap)this.bkmap).isLive();
    }

    public void deflate() throws TaskAbortException {
        ((SkeletonBTreeMap)this.bkmap).deflate();
    }

    public void inflate() throws TaskAbortException {
        ((SkeletonBTreeMap)this.bkmap).inflate();
    }

    public BaseCompositeProgress getProgressInflate() {
        return ((SkeletonBTreeMap)this.bkmap).pr_inf;
    }

    public void update(SortedSet<E> putset, SortedSet<E> remset) throws TaskAbortException {
        ((SkeletonBTreeMap)this.bkmap).update(null, remset, new SortedSetMap(putset), null, new TaskAbortExceptionConvertor());
    }

    public <Q, R> SkeletonBTreeMap.NodeTranslator<Q, R> makeNodeTranslator(Translator<E, Q> ktr, Translator<SkeletonTreeMap<E, E>, R> mtr) {
        return ((SkeletonBTreeMap)this.bkmap).makeNodeTranslator(ktr, mtr);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this);
    }

    public static class TreeTranslator<E, T>
    implements Translator<SkeletonBTreeSet<E>, Map<String, Object>> {
        final SkeletonBTreeMap.TreeTranslator<E, E> trans;

        public TreeTranslator(Translator<E, T> k, Translator<SkeletonTreeMap<E, E>, ? extends Collection<T>> m) {
            this.trans = new SkeletonBTreeMap.TreeTranslator<E, E>(k, m);
        }

        @Override
        public Map<String, Object> app(SkeletonBTreeSet<E> tree) {
            return this.trans.app((SkeletonBTreeMap)tree.bkmap);
        }

        @Override
        public SkeletonBTreeSet<E> rev(Map<String, Object> tree) throws DataFormatException {
            return new SkeletonBTreeSet<E>(this.trans.rev(tree));
        }
    }

    public static class TreeSetTranslator<E>
    extends MapCollectionTranslator<E, SkeletonTreeMap<E, E>, Collection<E>> {
        @Override
        public Collection<E> app(SkeletonTreeMap<E, E> src) {
            ArrayList dst = new ArrayList(src.size());
            TreeSetTranslator.app(src, dst);
            return dst;
        }

        @Override
        public SkeletonTreeMap<E, E> rev(Collection<E> src) {
            SkeletonTreeMap dst = new SkeletonTreeMap();
            TreeSetTranslator.rev(src, dst);
            assert (dst.isBare());
            return dst;
        }
    }

    public static abstract class MapCollectionTranslator<E, M extends SkeletonTreeMap<E, E>, C extends Collection<E>>
    implements Translator<M, C> {
        public static <E, M extends SkeletonTreeMap<E, E>, C extends Collection<E>> C app(M src, C dst) {
            for (E k : src.keySet()) {
                dst.add(k);
            }
            return dst;
        }

        public static <E, M extends SkeletonTreeMap<E, E>, C extends Collection<E>> M rev(C src, M dst) {
            for (E e : src) {
                dst.putGhost(e, e);
            }
            return dst;
        }
    }
}

