/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import plugins.Library.util.Integers;

public final class Sorted {
    private Sorted() {
    }

    public static <E> E second(Iterable<E> ib) {
        Iterator<E> it = ib.iterator();
        it.next();
        return it.hasNext() ? (E)it.next() : null;
    }

    public static <E> E ceiling(SortedSet<E> set, E el) {
        SortedSet<E> tail = set.tailSet(el);
        return tail.isEmpty() ? null : (E)tail.first();
    }

    public static <E> E floor(SortedSet<E> set, E el) {
        SortedSet<E> head;
        return (E)(set.contains(el) ? el : ((head = set.headSet(el)).isEmpty() ? null : head.last()));
    }

    public static <E> E higher(SortedSet<E> set, E el) {
        SortedSet<E> tail = set.tailSet(el);
        return (E)(set.contains(el) ? Sorted.second(tail) : (tail.isEmpty() ? null : tail.first()));
    }

    public static <E> E lower(SortedSet<E> set, E el) {
        SortedSet<E> head = set.headSet(el);
        return head.isEmpty() ? null : (E)head.last();
    }

    public static <K> SortedSet<K> keySet(SortedMap<K, ?> map) {
        Set<K> ks = map.keySet();
        return ks instanceof SortedSet ? (SortedSet<Object>)ks : new SortedKeySet<K>(map);
    }

    public static <E> List<SortedSet<E>> split(SortedSet<E> subj, SortedSet<E> sep, SortedSet<E> foundsep) {
        if (!foundsep.isEmpty()) {
            throw new IllegalArgumentException("split(): Must provide an empty set to add found separators to");
        }
        if (subj.isEmpty()) {
            return Collections.emptyList();
        }
        if (sep.isEmpty()) {
            return Collections.singletonList(subj);
        }
        ArrayList<SortedSet<SortedSet<E>>> res = new ArrayList<SortedSet<SortedSet<E>>>(sep.size() + 2);
        E csub = subj.first();
        do {
            E nsub;
            E nsep;
            E csep = Sorted.floor(sep, csub);
            assert (csub != null);
            if (csub.equals(csep)) {
                assert (subj.contains(csep));
                foundsep.add(csep);
                csub = Sorted.second(subj.tailSet(csep));
                continue;
            }
            E e = nsep = csep == null ? sep.first() : Sorted.second(sep.tailSet(csep));
            assert (nsep == null || ((Comparable)csub).compareTo(nsep) < 0);
            E e2 = nsub = nsep == null ? subj.last() : Sorted.floor(subj, nsep);
            assert (nsub != null);
            if (nsub.equals(nsep)) {
                foundsep.add(nsep);
                nsub = Sorted.lower(subj, nsep);
            }
            assert (csub != null && ((Comparable)csub).compareTo(nsub) <= 0);
            assert (csep != null || nsep != null);
            res.add(csep == null ? subj.headSet(nsep) : (nsep == null ? subj.tailSet(csub) : subj.subSet(csub, nsep)));
            if (nsep == null) break;
            csub = Sorted.second(subj.tailSet(nsub));
        } while (csub != null);
        return res;
    }

    public static <E> List<E> select(SortedSet<E> subj, int num, Inclusivity inc) {
        if (num < 2) {
            if (num == 1) {
                switch (inc) {
                    case LEFT: {
                        return Collections.singletonList(subj.first());
                    }
                    case RIGHT: {
                        return Collections.singletonList(subj.last());
                    }
                    case BOTH: {
                        throw new IllegalArgumentException("select(): can't have num=1 and inc=BOTH");
                    }
                }
            } else {
                if (num == 0) {
                    if (inc == Inclusivity.NONE) {
                        return Collections.emptyList();
                    }
                    throw new IllegalArgumentException("select(): can't have num=0 and inc!=NONE");
                }
                throw new IllegalArgumentException("select(): cannot select a negative number of items");
            }
        }
        if (subj.size() < num) {
            throw new IllegalArgumentException("select(): cannot select " + num + " elements from a set of size " + subj.size());
        }
        if (subj.size() == num) {
            return new ArrayList<E>(subj);
        }
        ArrayList sel = new ArrayList(num);
        int n = num;
        Iterator it = subj.iterator();
        switch (inc) {
            case NONE: {
                ++n;
                break;
            }
            case BOTH: {
                --n;
            }
            case LEFT: {
                sel.add(it.next());
            }
        }
        for (Integer s : Integers.allocateEvenly(subj.size() - num, n)) {
            for (int i = 0; i < s; ++i) {
                it.next();
            }
            if (it.hasNext()) {
                sel.add(it.next());
                continue;
            }
            assert (sel.size() == num && (inc == Inclusivity.NONE || inc == Inclusivity.LEFT));
        }
        assert (sel.size() == num);
        return sel;
    }

    public static <E> List<E> select(SortedSet<E> subj, int n) {
        return Sorted.select(subj, n, Inclusivity.NONE);
    }

    private static class SortedKeySet<K>
    extends AbstractSet<K>
    implements SortedSet<K> {
        final SortedMap<K, ?> map;

        public SortedKeySet(SortedMap<K, ?> m) {
            this.map = m;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            boolean c = this.contains(o);
            this.map.remove(o);
            return c;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map.comparator();
        }

        @Override
        public K first() {
            return this.map.firstKey();
        }

        @Override
        public K last() {
            return this.map.lastKey();
        }

        @Override
        public SortedSet<K> headSet(K r) {
            return new SortedKeySet<K>(this.map.headMap(r));
        }

        @Override
        public SortedSet<K> tailSet(K l) {
            return new SortedKeySet<K>(this.map.tailMap(l));
        }

        @Override
        public SortedSet<K> subSet(K l, K r) {
            return new SortedKeySet<K>(this.map.subMap(l, r));
        }
    }

    public static enum Inclusivity {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }
}

